/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import org.apache.jena.sdb.core.JoinType;
import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.Scope2;
import org.apache.jena.sdb.core.ScopeOptional;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr;
import org.apache.jena.sdb.core.sqlexpr.SqlExprList;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase2;
import org.slf4j.LoggerFactory;

public abstract class SqlJoin
extends SqlNodeBase2 {
    private JoinType joinType;
    private Scope idScope;
    private Scope nodeScope;
    private SqlExprList conditions = new SqlExprList();

    public static SqlJoin create(JoinType joinType, SqlNode left, SqlNode right) {
        switch (joinType) {
            case INNER: {
                return new SqlJoinInner(left, right);
            }
            case LEFT: {
                return new SqlJoinLeftOuter(left, right);
            }
        }
        LoggerFactory.getLogger(SqlJoin.class).warn("Unknown join type: " + joinType.printName());
        return null;
    }

    protected SqlJoin(JoinType joinType, SqlNode left, SqlNode right) {
        super(null, left, right);
        this.joinType = joinType;
        if (joinType == JoinType.LEFT) {
            this.idScope = new Scope2(left.getIdScope(), new ScopeOptional(right.getIdScope()));
            this.nodeScope = new Scope2(left.getNodeScope(), new ScopeOptional(right.getNodeScope()));
        } else {
            this.idScope = new Scope2(left.getIdScope(), right.getIdScope());
            this.nodeScope = new Scope2(left.getNodeScope(), right.getNodeScope());
        }
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public boolean isJoin() {
        return true;
    }

    @Override
    public SqlJoin asJoin() {
        return this;
    }

    public SqlExprList getConditions() {
        return this.conditions;
    }

    public void addCondition(SqlExpr e2) {
        this.conditions.add(e2);
    }

    public void addConditions(SqlExprList exprs) {
        this.conditions.addAll(exprs);
    }

    @Override
    public Scope getIdScope() {
        return this.idScope;
    }

    @Override
    public Scope getNodeScope() {
        return this.nodeScope;
    }
}

