/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.jena.sdb.core.ScopeStatus;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sparql.core.Var;

public class ScopeEntry {
    Var var;
    SqlColumn column;
    ScopeStatus status;
    public static Predicate<ScopeEntry> OptionalFilter = item -> item.getStatus() == ScopeStatus.OPTIONAL;
    public static Consumer<ScopeEntry> SetOpt = item -> item.setStatus(ScopeStatus.OPTIONAL);

    public ScopeEntry(Var var, SqlColumn column) {
        this(var, column, ScopeStatus.FIXED);
    }

    private ScopeEntry(Var var, SqlColumn column, ScopeStatus status) {
        this.var = var;
        this.column = column;
        this.status = status;
    }

    public void reset(Var var, SqlColumn column, ScopeStatus status) {
        this.var = var;
        this.column = column;
        this.status = status;
    }

    public ScopeEntry duplicate() {
        return new ScopeEntry(this.var, this.column, this.status);
    }

    public SqlColumn getColumn() {
        return this.column;
    }

    public ScopeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScopeStatus newStatus) {
        this.status = newStatus;
    }

    public boolean isOptional() {
        return this.hasStatus(ScopeStatus.OPTIONAL);
    }

    public boolean isFixed() {
        return this.hasStatus(ScopeStatus.FIXED);
    }

    public boolean hasStatus(ScopeStatus testStatus2) {
        return this.status == testStatus2;
    }

    public Var getVar() {
        return this.var;
    }

    public String toString() {
        return "(" + this.var + ", " + this.column + "/" + this.status.name() + ")";
    }
}

