/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb;

import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.shared.Env;
import org.apache.jena.sdb.sql.MySQLEngineType;
import org.apache.jena.sdb.sql.SAPStorageType;
import org.apache.jena.sdb.sql.SDBConnectionDesc;
import org.apache.jena.sdb.store.DatabaseType;
import org.apache.jena.sdb.store.FeatureSet;
import org.apache.jena.sdb.store.LayoutType;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDesc {
    private static Logger log = LoggerFactory.getLogger(StoreDesc.class);
    public SDBConnectionDesc connDesc = null;
    private DatabaseType dbType = null;
    private LayoutType layout = null;
    private FeatureSet featureSet = null;
    public MySQLEngineType engineType = null;
    public SAPStorageType storageType = null;

    public static StoreDesc read(String filename) {
        Model m = Env.fileManager().loadModel(filename);
        return StoreDesc.read(m);
    }

    public StoreDesc(String layoutName, String dbTypeName) {
        this(layoutName, dbTypeName, null);
    }

    public StoreDesc(String layoutName, String dbTypeName, FeatureSet featureSet) {
        this(LayoutType.fetch(layoutName), DatabaseType.fetch(dbTypeName), featureSet);
    }

    public StoreDesc(LayoutType layout, DatabaseType dbType) {
        this(layout, dbType, null);
    }

    public StoreDesc(LayoutType layout, DatabaseType dbType, FeatureSet featureSet) {
        this.layout = layout;
        this.dbType = dbType;
        if (featureSet == null) {
            featureSet = new FeatureSet();
        }
        this.featureSet = featureSet;
    }

    public LayoutType getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutType layout) {
        this.layout = layout;
    }

    public static StoreDesc read(Model m) {
        Resource r = GraphUtils.getResourceByType(m, AssemblerVocab.StoreAssemblerType);
        if (r == null) {
            throw new SDBException("Can't find store description");
        }
        return StoreDesc.read(r);
    }

    public static StoreDesc read(Resource r) {
        return (StoreDesc)AssemblerBase.general.open(r);
    }

    public DatabaseType getDbType() {
        return this.dbType;
    }

    public void setDbType(DatabaseType dbType) {
        this.dbType = dbType;
    }
}

