/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.ArgDecl;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModResultsOut;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.util.PrintSDB;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;
import sdb.cmd.CmdArgsDB;

public class sdbquery
extends CmdArgsDB {
    public static final String usage = "sdbquery --sdb <SPEC> [--direct] [ <query> | --query=file ]";
    private static ArgDecl argDeclDirect = new ArgDecl(false, "direct", new String[0]);
    private static ArgDecl argDeclRepeat = new ArgDecl(true, "repeat", new String[0]);
    boolean printResults = true;
    int repeatCount = 1;
    ModQueryIn modQuery = new ModQueryIn();
    ModResultsOut modResults = new ModResultsOut();
    static final String divider = "- - - - - - - - - - - - - -";

    public static void main(String ... argv) {
        SDB.init();
        new sdbquery(argv).mainRun();
    }

    protected sdbquery(String ... args) {
        super(args);
        this.addModule(this.modQuery);
        this.addModule(this.modResults);
        this.getUsage().startCategory("Misc");
        this.add(argDeclRepeat);
        this.getUsage().addUsage("--repeat=N", "Do the query N times (for timing)");
    }

    @Override
    protected String getCommandName() {
        return Utils.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " <SPEC> [--direct] [ <query> | --query=file ]";
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.contains(argDeclRepeat)) {
            this.repeatCount = Integer.parseInt(this.getArg(argDeclRepeat).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execCmd(List<String> positionalArgs) {
        if (this.contains(argDeclDirect)) {
            QueryEngineSDB.unregister();
        }
        if (this.isVerbose()) {
            SDB_QC.PrintSQL = true;
            this.modQuery.getQuery().serialize(System.out);
            System.out.println(divider);
        }
        this.getStore();
        this.getModStore().getDataset();
        Query query2 = this.modQuery.getQuery();
        QueryExecution qExec = QueryExecutionFactory.create(query2, this.getModStore().getDataset());
        qExec.abort();
        if (this.getModTime().timingEnabled()) {
            this.getModTime().startTimer();
            long connectTime = this.getModTime().endTimer();
            this.getModTime().startTimer();
            Query query3 = this.modQuery.getQuery();
            long javaTime = this.getModTime().endTimer();
            if (this.isVerbose()) {
                System.out.println("Class load time: " + this.getModTime().timeStr(javaTime));
            }
        }
        long totalTime = 0L;
        try {
            long queryTime;
            this.getModTime().startTimer();
            for (int i = 0; i < this.repeatCount; ++i) {
                Query query4 = this.modQuery.getQuery();
                QueryExecution qExec2 = QueryExecutionFactory.create(query4, this.getModStore().getDataset());
                if (this.isVerbose()) {
                    PrintSDB.print(((QueryExecutionBase)qExec2).getPlan().getOp());
                }
                QueryExecUtils.executeQuery(query4, qExec2, this.modResults.getResultsFormat());
                qExec2.close();
            }
            totalTime = queryTime = this.getModTime().endTimer();
        }
        catch (QueryException ex) {
            try {
                System.out.println("Query exception: " + ex.getMessage());
                if (!this.getModTime().timingEnabled()) return;
            }
            catch (Throwable throwable) {
                if (!this.getModTime().timingEnabled()) throw throwable;
                System.out.println("Execute time:    " + String.format("%.4f", new Double((double)totalTime / (1000.0 * (double)this.repeatCount))));
                throw throwable;
            }
            System.out.println("Execute time:    " + String.format("%.4f", new Double((double)totalTime / (1000.0 * (double)this.repeatCount))));
            return;
        }
        if (!this.getModTime().timingEnabled()) return;
        System.out.println("Execute time:    " + String.format("%.4f", new Double((double)totalTime / (1000.0 * (double)this.repeatCount))));
        return;
    }

    static String memStr() {
        long mem = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return "[T:" + mem + "/F:" + free + "]";
    }
}

