/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModLangParse;
import arq.cmdline.ModSymbol;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.query.ARQ;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.log4j.PropertyConfigurator;

public abstract class CmdLangParse
extends CmdGeneral {
    protected ModTime modTime = new ModTime();
    protected ModLangParse modLangParse = new ModLangParse();
    protected ModSymbol modSymbol = new ModSymbol();
    protected ArgDecl argStrict = new ArgDecl(false, "strict", new String[0]);
    protected InferenceSetupRDFS setup = null;
    static LangHandler langHandlerQuads = new LangHandler(){

        @Override
        public String getItemsName() {
            return "quads";
        }

        @Override
        public String getRateName() {
            return "QPS";
        }
    };
    static LangHandler langHandlerTriples = new LangHandler(){

        @Override
        public String getItemsName() {
            return "triples";
        }

        @Override
        public String getRateName() {
            return "TPS";
        }
    };
    static LangHandler langHandlerAny = new LangHandler(){

        @Override
        public String getItemsName() {
            return "tuples";
        }

        @Override
        public String getRateName() {
            return "TPS";
        }
    };
    protected static Map<Lang, LangHandler> dispatch = new HashMap<Lang, LangHandler>();
    protected LangHandler langHandlerOverall = null;
    private static final String log4Jsetup;
    protected long totalMillis = 0L;
    protected long totalTuples = 0L;
    OutputStream output = System.out;

    public static void setLogging() {
        Properties p = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(log4Jsetup));
        try {
            p.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyConfigurator.configure(p);
        System.setProperty("log4j.configuration", "set");
    }

    protected CmdLangParse(String[] argv) {
        super(argv);
        CmdLangParse.setLogging();
        super.addModule(this.modTime);
        super.addModule(this.modLangParse);
        super.addModule(this.modSymbol);
        this.modVersion.addClass(Jena.class);
        this.modVersion.addClass(ARQ.class);
        this.modVersion.addClass(RIOT.class);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--time] [--check|--noCheck] [--sink] [--base=IRI] file ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.contains(this.argStrict)) {
            RIOT.setStrictMode(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exec() {
        if (this.modLangParse.strictMode()) {
            RIOT.setStrictMode(true);
        }
        if (this.modLangParse.getRDFSVocab() != null) {
            this.setup = new InferenceSetupRDFS(this.modLangParse.getRDFSVocab());
        }
        try {
            if (super.getPositional().isEmpty()) {
                this.parseFile("-");
            } else {
                boolean b = super.getPositional().size() > 1;
                for (String fn : super.getPositional()) {
                    if (b && !super.isQuiet()) {
                        SysRIOT.getLogger().info("File: " + fn);
                    }
                    this.parseFile(fn);
                }
            }
        }
        finally {
            System.err.flush();
            System.out.flush();
            if (super.getPositional().size() > 1 && this.modTime.timingEnabled()) {
                this.output("Total", this.totalTuples, this.totalMillis, this.langHandlerOverall);
            }
        }
    }

    public void parseFile(String filename) {
        InputStream in = null;
        if (filename.equals("-")) {
            this.parseFile("http://base/", "stdin", System.in);
        } else {
            try {
                in = IO.openFile(filename);
            }
            catch (Exception ex) {
                System.err.println("Can't open '" + filename + "' " + ex.getMessage());
                return;
            }
            this.parseFile(null, filename, in);
            IO.close(in);
        }
    }

    public void parseFile(String defaultBaseURI, String filename, InputStream in) {
        String baseURI = this.modLangParse.getBaseIRI();
        if (baseURI == null) {
            baseURI = defaultBaseURI;
        }
        this.parseRIOT(baseURI, filename, in);
    }

    protected abstract Lang selectLang(String var1, Lang var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRIOT(String baseURI, String filename, InputStream in) {
        Lang lang;
        LangHandler handler;
        baseURI = SysRIOT.chooseBaseIRI(baseURI, filename);
        boolean checking = true;
        if (this.modLangParse.explicitChecking()) {
            checking = true;
        }
        if (this.modLangParse.explicitNoChecking()) {
            checking = false;
        }
        ErrorHandler errHandler = null;
        if (checking) {
            errHandler = this.modLangParse.stopOnBadTerm() ? ErrorHandlerFactory.errorHandlerStd : ErrorHandlerFactory.errorHandlerWarn;
        }
        if (this.modLangParse.skipOnBadTerm()) {
            // empty if block
        }
        if ((handler = dispatch.get(lang = this.selectLang(filename, RDFLanguages.NQUADS))) == null) {
            throw new CmdException("Undefined language: " + lang);
        }
        if (this.langHandlerOverall == null) {
            this.langHandlerOverall = handler;
        } else if (this.langHandlerOverall != langHandlerAny && this.langHandlerOverall != handler) {
            this.langHandlerOverall = langHandlerAny;
        }
        boolean labelsAsGiven = false;
        NodeToLabel labels = SyntaxLabels.createNodeToLabel();
        StreamRDF s = StreamRDFLib.sinkNull();
        if (!this.modLangParse.toBitBucket()) {
            s = StreamRDFLib.writer(this.output);
        }
        if (this.setup != null) {
            s = InfFactory.inf(s, this.setup);
        }
        StreamRDFCounting sink = StreamRDFLib.count(s);
        s = null;
        LangRIOT parser = RiotReader.createParser(in, lang, baseURI, (StreamRDF)sink);
        try {
            if (checking) {
                if (parser.getLang() == RDFLanguages.NTRIPLES || parser.getLang() == RDFLanguages.NQUADS) {
                    parser.setProfile(RiotLib.profile(baseURI, false, true, errHandler));
                } else {
                    parser.setProfile(RiotLib.profile(baseURI, true, true, errHandler));
                }
            } else {
                parser.setProfile(RiotLib.profile(baseURI, false, false, errHandler));
            }
            this.modTime.startTimer();
            parser.parse();
        }
        catch (RiotException ex) {
            if (this.modLangParse.stopOnBadTerm()) {
                return;
            }
        }
        finally {
            sink.finish();
            IO.close(in);
        }
        long x = this.modTime.endTimer();
        long n = sink.countTriples() + sink.countQuads();
        if (this.modTime.timingEnabled()) {
            this.output(filename, n, x, handler);
        }
        this.totalMillis += x;
        this.totalTuples += n;
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(in);
        return tokenizer;
    }

    protected void output(String label, long numberTriples, long timeMillis, LangHandler handler) {
        double timeSec = (double)timeMillis / 1000.0;
        System.out.flush();
        System.err.printf("%s : %,5.2f sec  %,d %s  %,.2f %s\n", label, (double)timeMillis / 1000.0, numberTriples, handler.getItemsName(), timeSec == 0.0 ? 0.0 : (double)numberTriples / timeSec, handler.getRateName());
    }

    protected void output(String label) {
        System.err.printf("%s : \n", label);
    }

    static {
        for (Lang lang : RDFLanguages.getRegisteredLanguages()) {
            if (RDFLanguages.isQuads(lang)) {
                dispatch.put(lang, langHandlerQuads);
                continue;
            }
            dispatch.put(lang, langHandlerTriples);
        }
        log4Jsetup = StrUtils.strjoin("\n", "## Plain output to stderr", "log4j.appender.riot.plainerr=org.apache.log4j.ConsoleAppender", "log4j.appender.riot.plainerr.target=System.err", "log4j.appender.riot.plainerr.layout=org.apache.log4j.PatternLayout", "log4j.appender.riot.plainerr.layout.ConversionPattern=%-5p %m%n", "## Everything", "log4j.rootLogger=INFO, riot.plainerr", "## Parser output", "log4j.additivity.org.apache.jena.riot=false", "log4j.logger.org.apache.jena.riot=ALL, riot.plainerr ");
    }

    static interface LangHandler {
        public String getItemsName();

        public String getRateName();
    }
}

