/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.modify.UpdateEngineRegistry;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemote;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemoteForm;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorBase;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorStreamingBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateProcessorStreaming;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateExecutionFactory {
    public static UpdateProcessor create(Update update2, GraphStore graphStore) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), graphStore);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, null);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore) {
        return UpdateExecutionFactory.makeStreaming(graphStore, null);
    }

    public static UpdateProcessorStreaming createStreaming(GraphStore graphStore, Context context) {
        return UpdateExecutionFactory.makeStreaming(graphStore, context);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Context context) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, context);
    }

    private static UpdateProcessor make(UpdateRequest updateRequest, GraphStore graphStore, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(graphStore.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(graphStore, context)) == null) {
            return null;
        }
        UpdateProcessorBase uProc = new UpdateProcessorBase(updateRequest, graphStore, context, f);
        return uProc;
    }

    private static UpdateProcessorStreaming makeStreaming(GraphStore graphStore, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
            context.putAll(graphStore.getContext());
        }
        if ((f = UpdateEngineRegistry.get().find(graphStore, context)) == null) {
            return null;
        }
        UpdateProcessorStreamingBase uProc = new UpdateProcessorStreamingBase(graphStore, context, f);
        return uProc;
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(update2, remoteEndpoint, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, context);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, context);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context) {
        return new UpdateProcessRemoteForm(new UpdateRequest(update2), remoteEndpoint, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context);
    }
}

