/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.BufferBase;
import com.hp.hpl.jena.tdb.base.buffer.BufferException;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public final class PtrBuffer
extends BufferBase {
    private IntBuffer iBuff;

    private PtrBuffer(int maxRec) {
        this(ByteBuffer.allocate(4 * maxRec), 0);
    }

    public PtrBuffer(ByteBuffer bb, int num) {
        super(bb, 4, num);
        this.iBuff = bb.asIntBuffer();
        if (CheckBuffer && (this.iBuff.position() != 0 || bb.order() != SystemTDB.NetworkOrder)) {
            throw new RecordException("Duff pointer buffer");
        }
    }

    public int get(int idx) {
        PtrBuffer.checkBounds(idx, this.numSlot);
        return this._get(idx);
    }

    public int getHigh() {
        if (this.numSlot == 0) {
            throw new IllegalArgumentException("Empty PtrBuffer");
        }
        return this._get(this.numSlot - 1);
    }

    public int getLow() {
        if (this.numSlot == 0) {
            throw new IllegalArgumentException("Empty PtrBuffer");
        }
        return this._get(0);
    }

    public void add(int val) {
        this.add(this.numSlot, val);
    }

    public void add(int idx, int val) {
        if (idx != this.numSlot) {
            PtrBuffer.checkBounds(idx, this.numSlot);
            this.shiftUp(idx);
        } else {
            if (this.numSlot >= this.maxSlot) {
                throw new BufferException(String.format("Out of bounds: idx=%d, ptrs=%d", idx, this.maxSlot));
            }
            ++this.numSlot;
        }
        this._set(idx, val);
    }

    public void set(int idx, int val) {
        PtrBuffer.checkBounds(idx, this.numSlot);
        this._set(idx, val);
    }

    private final int _get(int idx) {
        return this.iBuff.get(idx);
    }

    private final void _set(int idx, int val) {
        this.iBuff.put(idx, val);
    }

    public String toString() {
        StringBuilder str2 = new StringBuilder();
        str2.append(String.format("Len=%d Max=%d ", this.numSlot, this.maxSlot));
        for (int i = 0; i < this.numSlot; ++i) {
            if (i != 0) {
                str2.append(" ");
            }
            int x = this._get(i);
            str2.append(String.format("%04d", x));
        }
        return str2.toString();
    }

    private static void checkBounds(int idx, int len) {
        if (idx < 0 || idx >= len) {
            throw new BufferException(String.format("Out of bounds: idx=%d, ptrs=%d", idx, len));
        }
    }

    public PtrBuffer duplicate() {
        PtrBuffer n = new PtrBuffer(this.maxSlot);
        this.copy(0, n, 0, this.maxSlot);
        n.numSlot = this.numSlot;
        return n;
    }
}

