/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.riot.system.IRIResolver;

public class DatasetUtils {
    public static Dataset createDataset(String uri, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uri, namedSourceList, null, null);
    }

    public static Dataset createDataset(String uri, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDataset(uriList, namedSourceList, fileManager, baseURI);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uriList, namedSourceList, null, null);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        Dataset ds = DatasetFactory.createMemFixed();
        DatasetUtils.addInGraphs(ds, uriList, namedSourceList, fileManager, baseURI);
        return ds;
    }

    public static Dataset createDataset(DatasetDescription datasetDesc) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static Dataset createDataset(DatasetDescription datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static Dataset addInGraphs(Dataset ds, List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.addInGraphs(ds, uriList, namedSourceList, null, null);
    }

    public static Dataset addInGraphs(Dataset ds, List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        String absURI;
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (ds.getDefaultModel() == null) {
            ds.setDefaultModel(GraphFactory.makeDefaultModel());
        }
        if (uriList != null) {
            for (String sourceURI : uriList) {
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolveString(sourceURI, baseURI) : IRIResolver.resolveString(sourceURI);
                fileManager.readModel(ds.getDefaultModel(), sourceURI, absURI, null);
            }
        }
        if (namedSourceList != null) {
            for (String sourceURI : namedSourceList) {
                absURI = null;
                absURI = baseURI != null ? IRIResolver.resolveString(sourceURI, baseURI) : IRIResolver.resolveString(sourceURI);
                Model m = GraphFactory.makeDefaultModel();
                fileManager.readModel(m, sourceURI, absURI, null);
                ds.addNamedModel(absURI, m);
            }
        }
        return ds;
    }

    public static DatasetGraph createDatasetGraph(DatasetDescription datasetDesc) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null, null);
    }

    public static DatasetGraph createDatasetGraph(DatasetDescription datasetDesc, FileManager fileManager, String baseURI) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(String uri, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDatasetGraph(uriList, namedSourceList, fileManager, baseURI);
    }

    public static DatasetGraph createDatasetGraph(List<String> uriList, List<String> namedSourceList, FileManager fileManager, String baseURI) {
        DatasetGraph ds = DatasetGraphFactory.createMem();
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        if (uriList != null) {
            Model m = GraphFactory.makeDefaultModel();
            for (String sourceURI : uriList) {
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolveString(sourceURI, baseURI) : IRIResolver.resolveString(sourceURI);
                fileManager.readModel(m, sourceURI, absURI, null);
            }
            ds.setDefaultGraph(m.getGraph());
        } else {
            ds.setDefaultGraph(GraphFactory.createDefaultGraph());
        }
        if (namedSourceList != null) {
            for (String sourceURI : namedSourceList) {
                String absURI = null;
                absURI = baseURI != null ? IRIResolver.resolveString(baseURI, sourceURI) : IRIResolver.resolveString(sourceURI);
                Model m = fileManager.loadModel(sourceURI, absURI, null);
                Node gn = NodeFactory.createURI(sourceURI);
                ds.addGraph(gn, m.getGraph());
            }
        }
        return ds;
    }
}

