/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.layout2.ValueType;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.LoggerFactory;

public class NodeLayout2 {
    public static String nodeToLex(Node node) {
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isLiteral()) {
            return node.getLiteralLexicalForm();
        }
        if (node.isBlank()) {
            return node.getBlankNodeId().getLabelString();
        }
        throw new SDBException("Can't create lexical representation for " + node);
    }

    public static String nodeToLexTruncate(Node node, int length) {
        return NodeLayout2.nodeToLexTruncate(node, length, null);
    }

    public static String nodeToLexTruncate(Node node, int length, String logPrefix) {
        String lex = NodeLayout2.nodeToLex(node);
        if (length < 0) {
            return lex;
        }
        if (lex.length() > length) {
            String tmp = "Too long (" + length + "/" + lex.length() + "): " + lex.substring(0, 20) + "...";
            if (logPrefix != null) {
                tmp = logPrefix + ": " + tmp;
            }
            LoggerFactory.getLogger(NodeLayout2.class).warn(tmp);
            lex = lex.substring(0, length);
        }
        return lex;
    }

    public static int nodeToType(Node node) {
        return ValueType.lookup(node).getTypeId();
    }

    public static String nodeToLang(Node node) {
        if (!node.isLiteral()) {
            return "";
        }
        String lang = node.getLiteralLanguage();
        if (lang == null) {
            return "";
        }
        return lang;
    }

    public static long hash(Node n) {
        String lexForm = null;
        if (n.isURI()) {
            lexForm = n.getURI();
        } else if (n.isLiteral()) {
            lexForm = n.getLiteralLexicalForm();
        } else if (n.isBlank()) {
            lexForm = n.getBlankNodeLabel();
        } else {
            throw new SDBException("Attempt to hash a variable");
        }
        String datatypeStr = "";
        if (n.isLiteral()) {
            datatypeStr = n.getLiteralDatatypeURI();
        }
        String langStr = "";
        if (n.isLiteral()) {
            langStr = n.getLiteralLanguage();
        }
        ValueType vType = ValueType.lookup(n);
        return NodeLayout2.hash(lexForm, langStr, datatypeStr, vType.getTypeId());
    }

    public static long hash(String lex, String lang, String datatype, int type) {
        if (datatype == null) {
            datatype = "";
        }
        if (lang == null) {
            lang = "";
        }
        String toHash = lex + "|" + lang + "|" + datatype;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(toHash.getBytes("UTF8"));
            digest.update((byte)type);
            byte[] hash = digest.digest();
            BigInteger bigInt = new BigInteger(hash);
            return bigInt.longValue();
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        return -1L;
    }
}

