/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.engine;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.SDBCompile;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterEquality;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformPropertyFunction;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCheck;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineSDB
extends QueryEngineBase {
    private static Logger log = LoggerFactory.getLogger(QueryEngineSDB.class);
    private Store store;
    private SDBRequest request = null;
    private Op originalOp = null;
    private static QueryEngineFactory factory = new QueryEngineFactorySDB();

    public QueryEngineSDB(Store store, Query q) {
        this(new DatasetStoreGraph(store, SDB.getContext().copy()), q, BindingRoot.create(), SDB.getContext().copy());
    }

    public QueryEngineSDB(DatasetStoreGraph dsg, Query query2, Binding initialBinding, Context context) {
        super(query2, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, query2, initialBinding, context);
    }

    public QueryEngineSDB(DatasetStoreGraph dsg, Op op, Binding initialBinding, Context context) {
        super(op, (DatasetGraph)dsg, initialBinding, context);
        this.init(dsg, null, initialBinding, context);
    }

    private void init(DatasetStoreGraph dsg, Query query2, Binding initialBinding, Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        if (query2 != null && query2.hasDatasetDescription()) {
            throw new SDBException("Queries with dataset descriptions (FROM/FROM NAMED) not supported");
        }
        if (context.isDefined(ARQConstants.sysDatasetDescription)) {
            throw new SDBException("Queries with dataset descriptions set in the context not supported");
        }
        this.store = dsg.getStore();
        this.request = new SDBRequest(this.store, query2, context);
        Op op = this.originalOp = this.getOp();
        op = Transformer.transform(new TransformPropertyFunction(context), op);
        op = Transformer.transform(new TransformFilterEquality(), op);
        op = Algebra.toQuadForm(op);
        op = SDBCompile.compile(this.store, op, initialBinding, context, this.request);
        this.setOp(op);
    }

    public SDBRequest getRequest() {
        return this.request;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding binding, Context context) {
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory(context));
        if (!(op instanceof OpSQL)) {
            QueryIterSingleton input = QueryIterSingleton.create(binding, execCxt);
            QueryIterator qIter = QC.execute(op, input, execCxt);
            qIter = QueryIteratorCheck.check(qIter, execCxt);
            return qIter;
        }
        OpSQL opSQL = (OpSQL)op;
        QueryIterator qIter = opSQL.getSqlNode() == null ? (binding != null && binding.size() != 0 ? QueryIterSingleton.create(binding, execCxt) : QueryIterRoot.create(execCxt)) : opSQL.exec(binding, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        return qIter;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    private static class QueryEngineFactorySDB
    implements QueryEngineFactory {
        private QueryEngineFactorySDB() {
        }

        @Override
        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetStoreGraph;
        }

        @Override
        public Plan create(Query query2, DatasetGraph dataset, Binding inputBinding, Context context) {
            QueryEngineSDB qe = new QueryEngineSDB((DatasetStoreGraph)dataset, query2, inputBinding, context);
            return qe.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetStoreGraph;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            QueryEngineSDB qe = new QueryEngineSDB((DatasetStoreGraph)dataset, op, inputBinding, context);
            return qe.getPlan();
        }
    }
}

