/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.shared.Access;
import com.hp.hpl.jena.sdb.sql.SDBConnectionDesc;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.vocabulary.RDFS;

public class SDBConnectionDescAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public SDBConnectionDesc open(Assembler a, Resource root, Mode mode) {
        SDBConnectionDesc sDesc = SDBConnectionDesc.blank();
        sDesc.setType(GraphUtils.getStringValue(root, AssemblerVocab.pSDBtype));
        sDesc.setHost(GraphUtils.getStringValue(root, AssemblerVocab.pSDBhost));
        sDesc.setName(GraphUtils.getStringValue(root, AssemblerVocab.pSDBname));
        sDesc.setUser(GraphUtils.getStringValue(root, AssemblerVocab.pSDBuser));
        sDesc.setPassword(GraphUtils.getStringValue(root, AssemblerVocab.pSDBpassword));
        sDesc.setDriver(GraphUtils.getStringValue(root, AssemblerVocab.pDriver));
        sDesc.setJdbcURL(GraphUtils.getStringValue(root, AssemblerVocab.pJDBC));
        sDesc.setPoolSize(GraphUtils.getStringValue(root, AssemblerVocab.pPoolSize));
        sDesc.setLabel(GraphUtils.getStringValue(root, RDFS.label));
        if (sDesc.getUser() == null) {
            sDesc.setUser(Access.getUser());
        }
        if (sDesc.getPassword() == null) {
            sDesc.setPassword(Access.getPassword());
        }
        return sDesc;
    }
}

