/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.UnknownPropertyException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTripleWriter
implements RDFWriter {
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    protected static Logger logger = LoggerFactory.getLogger(NTripleWriter.class);
    private static boolean[] okURIChars = new boolean[128];

    @Override
    public void write(Model model, OutputStream out, String base) {
        try {
            Writer w;
            try {
                w = new OutputStreamWriter(out, "ascii");
            }
            catch (UnsupportedEncodingException e2) {
                logger.warn("ASCII is not supported: in NTripleWriter.write", e2);
                w = FileUtils.asUTF8(out);
            }
            this.write(model, w, base);
            w.flush();
        }
        catch (Exception ioe) {
            this.errorHandler.error(ioe);
        }
    }

    @Override
    public void write(Model model, Writer writer, String base) {
        try {
            PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            StmtIterator iter = model.listStatements();
            Statement stmt = null;
            while (iter.hasNext()) {
                stmt = iter.nextStatement();
                NTripleWriter.writeResource(stmt.getSubject(), pw);
                pw.print(" ");
                NTripleWriter.writeResource(stmt.getPredicate(), pw);
                pw.print(" ");
                NTripleWriter.writeNode(stmt.getObject(), pw);
                pw.println(" .");
            }
            pw.flush();
        }
        catch (Exception e2) {
            this.errorHandler.error(e2);
        }
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        throw new UnknownPropertyException(propName);
    }

    public void setNsPrefix(String prefix, String ns) {
    }

    public String getPrefixFor(String uri) {
        return null;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public static void write(Model model, PrintWriter writer) throws IOException {
        StmtIterator iter = model.listStatements();
        Statement stmt = null;
        while (iter.hasNext()) {
            stmt = iter.nextStatement();
            NTripleWriter.writeResource(stmt.getSubject(), writer);
            writer.print(" ");
            NTripleWriter.writeResource(stmt.getPredicate(), writer);
            writer.print(" ");
            NTripleWriter.writeNode(stmt.getObject(), writer);
            writer.println(" .");
        }
    }

    protected static void writeResource(Resource r, PrintWriter writer) {
        if (r.isAnon()) {
            writer.print(NTripleWriter.anonName(r.getId()));
        } else {
            writer.print("<");
            NTripleWriter.writeURIString(r.getURI(), writer);
            writer.print(">");
        }
    }

    private static void writeURIString(String s, PrintWriter writer) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < okURIChars.length && okURIChars[c]) {
                writer.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
            writer.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                writer.print("0");
            }
            writer.print(hexstr);
        }
    }

    private static void writeString(String s, PrintWriter writer) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                writer.print('\\');
                writer.print(c);
                continue;
            }
            if (c == '\n') {
                writer.print("\\n");
                continue;
            }
            if (c == '\r') {
                writer.print("\\r");
                continue;
            }
            if (c == '\t') {
                writer.print("\\t");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                writer.print(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase();
            writer.print("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                writer.print("0");
            }
            writer.print(hexstr);
        }
    }

    protected static void writeLiteral(Literal l, PrintWriter writer) {
        String dt;
        String s = l.getString();
        writer.print('\"');
        NTripleWriter.writeString(s, writer);
        writer.print('\"');
        String lang = l.getLanguage();
        if (lang != null && !lang.equals("")) {
            writer.print("@" + lang);
        }
        if ((dt = l.getDatatypeURI()) != null && !dt.equals("")) {
            writer.print("^^<" + dt + ">");
        }
    }

    protected static void writeNode(RDFNode n, PrintWriter writer) {
        if (n instanceof Literal) {
            NTripleWriter.writeLiteral((Literal)n, writer);
        } else {
            NTripleWriter.writeResource((Resource)n, writer);
        }
    }

    protected static String anonName(AnonId id) {
        String name = "_:A";
        String sid = id.toString();
        for (int i = 0; i < sid.length(); ++i) {
            char c = sid.charAt(i);
            name = c == 'X' ? name + "XX" : (Character.isLetterOrDigit(c) ? name + c : name + "X" + Integer.toHexString(c) + "X");
        }
        return name;
    }

    static {
        for (int i = 32; i < 127; ++i) {
            NTripleWriter.okURIChars[i] = true;
        }
        NTripleWriter.okURIChars[60] = false;
        NTripleWriter.okURIChars[62] = false;
        NTripleWriter.okURIChars[92] = false;
    }
}

