/*
 * Decompiled with CFR 0.152.
 */
package scala.build.tastylib;

import java.io.OutputStream;
import java.io.Serializable;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.build.tastylib.TastyBuffer$Addr$;
import scala.build.tastylib.TastyBuffer$NameRef$;
import scala.build.tastylib.TastyReader$;
import scala.build.tastylib.TastyReader$Bytes$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TastyReader {
    private final byte[] bytes;
    private final int start;
    private final int end;
    private final int base;
    private int bp;

    public static int $lessinit$greater$default$4() {
        return TastyReader$.MODULE$.$lessinit$greater$default$4();
    }

    public TastyReader(byte[] bytes, int start, int end, int base) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
        this.base = base;
        this.bp = start;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int base() {
        return this.base;
    }

    public TastyReader(byte[] bytes) {
        this(bytes, 0, bytes.length, TastyReader$.MODULE$.$lessinit$greater$default$4());
    }

    public int pos() {
        return this.bp;
    }

    public Bytes read() {
        return TastyReader$Bytes$.MODULE$.apply((Tuple3<byte[], Object, Object>)Tuple3$.MODULE$.apply((Object)this.bytes(), (Object)BoxesRunTime.boxToInteger((int)this.start()), (Object)BoxesRunTime.boxToInteger((int)this.bp)));
    }

    public Bytes toRead() {
        return TastyReader$Bytes$.MODULE$.apply((Tuple3<byte[], Object, Object>)Tuple3$.MODULE$.apply((Object)this.bytes(), (Object)BoxesRunTime.boxToInteger((int)this.bp), (Object)BoxesRunTime.boxToInteger((int)this.end())));
    }

    public TastyReader readerFromCurrentPos() {
        return new TastyReader(this.bytes(), this.bp, this.end(), this.base());
    }

    public int addr(int idx) {
        return TastyBuffer$Addr$.MODULE$.apply(idx - this.base());
    }

    public int index(int addr) {
        return addr + this.base();
    }

    public int currentAddr() {
        return this.addr(this.bp);
    }

    public int endAddr() {
        return this.addr(this.end());
    }

    public boolean isAtEnd() {
        return this.bp == this.end();
    }

    public int readByte() {
        int result = this.bytes()[this.bp] & 0xFF;
        ++this.bp;
        return result;
    }

    public int readNat() {
        return (int)this.readLongNat();
    }

    public int readInt() {
        return (int)this.readLongInt();
    }

    public long readLongNat() {
        long b = 0L;
        long x = 0L;
        do {
            b = Byte$.MODULE$.byte2long(this.bytes()[this.bp]);
            x = x << 7 | b & 0x7FL;
            ++this.bp;
        } while ((b & 0x80L) == 0L);
        return x;
    }

    public long readLongInt() {
        byte b = this.bytes()[this.bp];
        long x = Int$.MODULE$.int2long((byte)(b << 1) >> 1);
        ++this.bp;
        while ((b & 0x80) == 0) {
            b = this.bytes()[this.bp];
            x = x << 7 | (long)(b & 0x7F);
            ++this.bp;
        }
        return x;
    }

    public long readUncompressedLong() {
        LongRef x = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            long l;
            int n = x$12;
            x$1.elem = l = x$1.elem << 8 | (long)(this.readByte() & 0xFF);
        });
        return x.elem;
    }

    public int readNameRef() {
        return TastyBuffer$NameRef$.MODULE$.apply(this.readNat());
    }

    public int readEnd() {
        return this.addr(this.readNat() + this.bp);
    }

    public void goto(int addr) {
        this.bp = this.index(addr);
    }

    public <T> List<T> until(int end, Function0<T> op) {
        ListBuffer buf = new ListBuffer();
        this.doUntil(end, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            TastyReader.until$$anonfun$1(op, buf);
            return BoxedUnit.UNIT;
        });
        return buf.toList();
    }

    public void doUntil(int end, Function0<BoxedUnit> op) {
        while (this.bp < this.index(end)) {
            op.apply$mcV$sp();
        }
        if (this.bp != this.index(end)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    private static final void until$$anonfun$1(Function0 op$1, ListBuffer buf$1) {
        buf$1.$plus$eq(op$1.apply());
    }

    public static final class Bytes {
        private final byte[] buf;
        private final int start;
        private final int end;

        public static Bytes apply(Tuple3<byte[], Object, Object> tuple3) {
            return TastyReader$Bytes$.MODULE$.apply(tuple3);
        }

        public Bytes(byte[] buf, int start, int end) {
            this.buf = buf;
            this.start = start;
            this.end = end;
        }

        public byte[] buf() {
            return this.buf;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int length() {
            return this.end() - this.start();
        }

        public void writeTo(OutputStream os) {
            os.write(this.buf(), this.start(), this.end() - this.start());
        }
    }
}

