/*
 * Decompiled with CFR 0.152.
 */
package scala.build.preprocessing.directives;

import com.virtuslab.using_directives.custom.model.StringValue;
import java.io.Serializable;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.SubPath;
import os.SubPath$;
import os.exists$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Logger;
import scala.build.errors.BuildException;
import scala.build.options.BuildOptions;
import scala.build.options.BuildOptions$;
import scala.build.options.ClassPathOptions;
import scala.build.options.ClassPathOptions$;
import scala.build.options.InternalDependenciesOptions;
import scala.build.options.InternalOptions;
import scala.build.options.JavaOptions;
import scala.build.options.JmhOptions;
import scala.build.options.PostBuildOptions;
import scala.build.options.ScalaJsOptions;
import scala.build.options.ScalaNativeOptions;
import scala.build.options.ScalaOptions;
import scala.build.options.ScriptOptions;
import scala.build.options.ShadowingSeq;
import scala.build.options.TestOptions;
import scala.build.preprocessing.directives.Directive$;
import scala.build.preprocessing.directives.DirectiveHandler;
import scala.build.preprocessing.directives.ProcessedDirective;
import scala.build.preprocessing.directives.ProcessedDirective$;
import scala.build.preprocessing.directives.ScopedDirective;
import scala.build.preprocessing.directives.ScopedValue;
import scala.build.preprocessing.directives.UsingDirectiveHandler;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class UsingResourcesDirectiveHandler$
implements DirectiveHandler,
UsingDirectiveHandler,
Product,
Serializable,
Mirror.Singleton {
    public static final UsingResourcesDirectiveHandler$ MODULE$ = new UsingResourcesDirectiveHandler$();

    private UsingResourcesDirectiveHandler$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UsingResourcesDirectiveHandler$.class);
    }

    public int hashCode() {
        return -1948613572;
    }

    public String toString() {
        return "UsingResourcesDirectiveHandler";
    }

    public boolean canEqual(Object that) {
        return that instanceof UsingResourcesDirectiveHandler$;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "UsingResourcesDirectiveHandler";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public String name() {
        return "Resource directories";
    }

    @Override
    public String description() {
        return "Manually add a resource directory to the class path";
    }

    @Override
    public String usage() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("//> using resource _path_\n                |\n                |//> using resources _path1_, _path2_ \u2026"));
    }

    @Override
    public String usageMd() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`//> using resourceDir `_path_\n      |\n      |`//> using resourceDirs `_path1_, _path2_ \u2026"));
    }

    @Override
    public Seq<String> examples() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"//> using resourceDir \"./resources\""}));
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public Seq<String> keys() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"resourceDir", "resourceDirs"}));
    }

    @Override
    public Either<BuildException, ProcessedDirective<BuildOptions>> handleValues(ScopedDirective scopedDirective, Logger logger) {
        return this.checkIfValuesAreExpected(scopedDirective).map((Function1 & Serializable)groupedValues -> {
            Seq<ScopedValue<StringValue>> paths = groupedValues.scopedStringValues();
            Tuple2<Option<SubPath>, Option<Path>> tuple2 = Directive$.MODULE$.osRootResource(scopedDirective.cwd());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option virtualRootOpt = (Option)tuple2._1();
            Option rootOpt = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)virtualRootOpt, (Object)rootOpt);
            Option virtualRootOpt2 = (Option)tuple22._1();
            Option rootOpt2 = (Option)tuple22._2();
            List paths0 = rootOpt2.toList().flatMap((Function1 & Serializable)root -> (IterableOnce)((IterableOps)paths.map((Function1 & Serializable)_$1 -> (String)_$1.positioned().value())).map((Function1 & Serializable)_$2 -> Path$.MODULE$.apply(_$2, root, (PathConvertible)PathConvertible.StringConvertible$.MODULE$)));
            Option virtualPaths = virtualRootOpt2.map((Function1 & Serializable)virtualRoot -> (Seq)((IterableOps)paths.map((Function1 & Serializable)_$3 -> (String)_$3.positioned().value())).map((Function1 & Serializable)path -> (SubPath)virtualRoot.$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(SubPath$.MODULE$.apply(path, (PathConvertible)PathConvertible.StringConvertible$.MODULE$)))));
            this.warnIfNotExistsPath((Seq<Path>)paths0, logger);
            List list = (List)virtualPaths.toList().flatten(Predef$.MODULE$.$conforms());
            Seq seq = ClassPathOptions$.MODULE$.$lessinit$greater$default$1();
            Seq seq2 = ClassPathOptions$.MODULE$.$lessinit$greater$default$2();
            Seq seq3 = ClassPathOptions$.MODULE$.$lessinit$greater$default$3();
            Seq seq4 = ClassPathOptions$.MODULE$.$lessinit$greater$default$4();
            Option option = ClassPathOptions$.MODULE$.$lessinit$greater$default$5();
            ShadowingSeq shadowingSeq = ClassPathOptions$.MODULE$.$lessinit$greater$default$6();
            ClassPathOptions classPathOptions = ClassPathOptions$.MODULE$.apply(seq, seq2, seq3, seq4, option, shadowingSeq, (Seq)paths0, (Seq)list);
            ScalaOptions scalaOptions = BuildOptions$.MODULE$.$lessinit$greater$default$1();
            ScalaJsOptions scalaJsOptions = BuildOptions$.MODULE$.$lessinit$greater$default$2();
            ScalaNativeOptions scalaNativeOptions = BuildOptions$.MODULE$.$lessinit$greater$default$3();
            InternalDependenciesOptions internalDependenciesOptions = BuildOptions$.MODULE$.$lessinit$greater$default$4();
            JavaOptions javaOptions = BuildOptions$.MODULE$.$lessinit$greater$default$5();
            JmhOptions jmhOptions = BuildOptions$.MODULE$.$lessinit$greater$default$6();
            ScriptOptions scriptOptions = BuildOptions$.MODULE$.$lessinit$greater$default$8();
            InternalOptions internalOptions = BuildOptions$.MODULE$.$lessinit$greater$default$9();
            Option option2 = BuildOptions$.MODULE$.$lessinit$greater$default$10();
            TestOptions testOptions = BuildOptions$.MODULE$.$lessinit$greater$default$11();
            PostBuildOptions postBuildOptions = BuildOptions$.MODULE$.$lessinit$greater$default$12();
            return ProcessedDirective$.MODULE$.apply(Some$.MODULE$.apply((Object)BuildOptions$.MODULE$.apply(scalaOptions, scalaJsOptions, scalaNativeOptions, internalDependenciesOptions, javaOptions, jmhOptions, classPathOptions, scriptOptions, internalOptions, option2, testOptions, postBuildOptions)), (Seq)package$.MODULE$.Seq().empty());
        });
    }

    private void warnIfNotExistsPath(Seq<Path> paths, Logger logger) {
        paths.foreach((Function1)(JProcedure1 & Serializable)path -> {
            if (!exists$.MODULE$.apply(path)) {
                logger.message(() -> this.warnIfNotExistsPath$$anonfun$1$$anonfun$1(path));
                return;
            }
        });
    }

    private final String warnIfNotExistsPath$$anonfun$1$$anonfun$1(Path path$1) {
        return new StringBuilder(57).append("WARNING: provided resource directory path doesn't exist: ").append(path$1).toString();
    }
}

