/*
 * Decompiled with CFR 0.152.
 */
package scala.build.preprocessing.directives;

import com.virtuslab.using_directives.custom.model.EmptyValue;
import com.virtuslab.using_directives.custom.model.Value;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.build.Logger;
import scala.build.errors.BuildException;
import scala.build.errors.UsingDirectiveExpectationError;
import scala.build.errors.UsingDirectiveValueNumError;
import scala.build.errors.UsingDirectiveWrongValueTypeError;
import scala.build.preprocessing.directives.DirectiveUtil$;
import scala.build.preprocessing.directives.GroupedScopedValuesContainer;
import scala.build.preprocessing.directives.GroupedScopedValuesContainer$;
import scala.build.preprocessing.directives.ProcessedDirective;
import scala.build.preprocessing.directives.ScopedDirective;
import scala.build.preprocessing.directives.UsingDirectiveValueKind$;
import scala.build.preprocessing.directives.UsingDirectiveValueNumberBounds;
import scala.build.preprocessing.directives.UsingDirectiveValueNumberBounds$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface DirectiveHandler<T> {
    public String name();

    public String description();

    public static String descriptionMd$(DirectiveHandler $this) {
        return $this.descriptionMd();
    }

    default public String descriptionMd() {
        return this.description();
    }

    public String usage();

    public static String usageMd$(DirectiveHandler $this) {
        return $this.usageMd();
    }

    default public String usageMd() {
        return new StringBuilder(2).append("`").append(this.usage()).append("`").toString();
    }

    public static Seq examples$(DirectiveHandler $this) {
        return $this.examples();
    }

    default public Seq<String> examples() {
        return package$.MODULE$.Nil();
    }

    public boolean isRestricted();

    public Seq<String> keys();

    public Either<BuildException, ProcessedDirective<T>> handleValues(ScopedDirective var1, Logger var2);

    public static Either checkIfValuesAreExpected$(DirectiveHandler $this, ScopedDirective scopedDirective) {
        return $this.checkIfValuesAreExpected(scopedDirective);
    }

    default public Either<BuildException, GroupedScopedValuesContainer> checkIfValuesAreExpected(ScopedDirective scopedDirective) {
        return this.receiveTheRightNumberOfValues(scopedDirective).flatMap((Function1 & Serializable)_$1 -> this.checkAndGroupValuesByType((ScopedDirective)_$1));
    }

    public static Set getSupportedTypes$(DirectiveHandler $this, String key) {
        return $this.getSupportedTypes(key);
    }

    default public Set<Enumeration.Value> getSupportedTypes(String key) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UsingDirectiveValueKind$.MODULE$.STRING()}));
    }

    public static UsingDirectiveValueNumberBounds getValueNumberBounds$(DirectiveHandler $this, String key) {
        return $this.getValueNumberBounds(key);
    }

    default public UsingDirectiveValueNumberBounds getValueNumberBounds(String key) {
        return UsingDirectiveValueNumberBounds$.MODULE$.apply(UsingDirectiveValueNumberBounds$.MODULE$.$lessinit$greater$default$1(), UsingDirectiveValueNumberBounds$.MODULE$.$lessinit$greater$default$2());
    }

    public static String unexpectedValueHint$(DirectiveHandler $this, String key) {
        return $this.unexpectedValueHint(key);
    }

    default public String unexpectedValueHint(String key) {
        return new StringBuilder(102).append("Did you forget to put the quotation marks around the string values passed to the using directive key ").append(key).append("?").toString();
    }

    private boolean isEmptyValue(Value<?> v) {
        Value<?> value = v;
        return value instanceof EmptyValue;
    }

    public static Either receiveTheRightNumberOfValues$(DirectiveHandler $this, ScopedDirective scopedDirective) {
        return $this.receiveTheRightNumberOfValues(scopedDirective);
    }

    default public Either<UsingDirectiveExpectationError, ScopedDirective> receiveTheRightNumberOfValues(ScopedDirective scopedDirective) {
        UsingDirectiveValueNumberBounds numberBounds;
        Seq nonEmptyValues = (Seq)scopedDirective.directive().values().filterNot((Function1 & Serializable)_$2 -> this.isEmptyValue((Value<?>)_$2));
        int length = nonEmptyValues.length();
        if (length < (numberBounds = this.getValueNumberBounds(scopedDirective.directive().key())).lower() || length > numberBounds.upper()) {
            return package$.MODULE$.Left().apply((Object)new UsingDirectiveValueNumError(scopedDirective.maybePath(), scopedDirective.directive().key(), numberBounds, length));
        }
        return package$.MODULE$.Right().apply((Object)scopedDirective.copy(scopedDirective.directive().copy(scopedDirective.directive().copy$default$1(), nonEmptyValues), scopedDirective.copy$default$2(), scopedDirective.copy$default$3()));
    }

    public static Either checkAndGroupValuesByType$(DirectiveHandler $this, ScopedDirective scopedDirective) {
        return $this.checkAndGroupValuesByType(scopedDirective);
    }

    default public Either<UsingDirectiveExpectationError, GroupedScopedValuesContainer> checkAndGroupValuesByType(ScopedDirective scopedDirective) {
        GroupedScopedValuesContainer groupedPositionedValuesContainer = DirectiveUtil$.MODULE$.getGroupedValues(scopedDirective);
        GroupedScopedValuesContainer groupedUnsupportedValues = GroupedScopedValuesContainer$.MODULE$.apply(GroupedScopedValuesContainer$.MODULE$.$lessinit$greater$default$1(), GroupedScopedValuesContainer$.MODULE$.$lessinit$greater$default$2(), GroupedScopedValuesContainer$.MODULE$.$lessinit$greater$default$3(), GroupedScopedValuesContainer$.MODULE$.$lessinit$greater$default$4());
        Set<Enumeration.Value> supportedTypes = this.getSupportedTypes(scopedDirective.directive().key());
        if (!supportedTypes.contains((Object)UsingDirectiveValueKind$.MODULE$.BOOLEAN())) {
            GroupedScopedValuesContainer groupedScopedValuesContainer = groupedUnsupportedValues;
            groupedUnsupportedValues = groupedScopedValuesContainer.copy(groupedScopedValuesContainer.copy$default$1(), groupedScopedValuesContainer.copy$default$2(), groupedPositionedValuesContainer.scopedBooleanValues(), groupedScopedValuesContainer.copy$default$4());
        }
        if (!supportedTypes.contains((Object)UsingDirectiveValueKind$.MODULE$.NUMERIC())) {
            GroupedScopedValuesContainer groupedScopedValuesContainer = groupedUnsupportedValues;
            groupedUnsupportedValues = groupedScopedValuesContainer.copy(groupedScopedValuesContainer.copy$default$1(), groupedPositionedValuesContainer.scopedNumericValues(), groupedScopedValuesContainer.copy$default$3(), groupedScopedValuesContainer.copy$default$4());
        }
        if (!supportedTypes.contains((Object)UsingDirectiveValueKind$.MODULE$.STRING())) {
            GroupedScopedValuesContainer groupedScopedValuesContainer = groupedUnsupportedValues;
            groupedUnsupportedValues = groupedScopedValuesContainer.copy(groupedPositionedValuesContainer.scopedStringValues(), groupedScopedValuesContainer.copy$default$2(), groupedScopedValuesContainer.copy$default$3(), groupedScopedValuesContainer.copy$default$4());
        }
        if (!supportedTypes.contains((Object)UsingDirectiveValueKind$.MODULE$.EMPTY())) {
            GroupedScopedValuesContainer groupedScopedValuesContainer = groupedUnsupportedValues;
            groupedUnsupportedValues = groupedScopedValuesContainer.copy(groupedScopedValuesContainer.copy$default$1(), groupedScopedValuesContainer.copy$default$2(), groupedScopedValuesContainer.copy$default$3(), groupedPositionedValuesContainer.maybeScopedEmptyValue());
        }
        if (groupedUnsupportedValues.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)groupedPositionedValuesContainer);
        }
        return package$.MODULE$.Left().apply((Object)new UsingDirectiveWrongValueTypeError(scopedDirective.maybePath(), scopedDirective.directive().key(), supportedTypes, groupedUnsupportedValues, this.unexpectedValueHint(scopedDirective.directive().key())));
    }
}

