/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands;

import caseapp.core.RemainingArgs;
import coursier.env.EnvironmentUpdate;
import coursier.env.EnvironmentUpdate$;
import coursier.env.ProfileUpdater;
import coursier.env.ProfileUpdater$;
import coursier.paths.Util;
import os.CommandResult;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.PermSet$;
import os.ProcessInput;
import os.ProcessOutput;
import os.Shellable;
import os.Shellable$;
import os.copy$;
import os.exists$;
import os.isFile$;
import os.perms;
import os.proc;
import os.proc$;
import os.remove$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.build.Directories$;
import scala.cli.CurrentParams$;
import scala.cli.commands.CommandUtils$;
import scala.cli.commands.CustomWindowsEnvVarUpdater;
import scala.cli.commands.CustomWindowsEnvVarUpdater$;
import scala.cli.commands.InstallHomeOptions;
import scala.cli.commands.InstallHomeOptions$;
import scala.cli.commands.ScalaCommand;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.StdIn$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;

public final class InstallHome$
extends ScalaCommand<InstallHomeOptions> {
    public static final InstallHome$ MODULE$ = new InstallHome$();

    private InstallHome$() {
        super(InstallHomeOptions$.MODULE$.parser(), InstallHomeOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InstallHome$.class);
    }

    public boolean hidden() {
        return true;
    }

    @Override
    public boolean inSipScala() {
        return false;
    }

    private Nothing$ logEqual(String version) {
        System.err.println(new StringBuilder(47).append("Scala CLI ").append(version).append(" is already installed and up-to-date.").toString());
        return scala.sys.package$.MODULE$.exit(0);
    }

    private void logUpdate(boolean env, String newVersion, String oldVersion) {
        if (!env) {
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(107).append("scala-cli ").append(oldVersion).append(" is already installed and out-of-date.\n         |scala-cli will be updated to version ").append(newVersion).append("\n         |").toString())));
        }
    }

    private void logDowngrade(boolean env, String newVersion, String oldVersion) {
        if (!env && Util.useAnsiOutput()) {
            String response;
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("scala-cli ").append(oldVersion).append(" is already installed and up-to-date.").toString());
            Predef$.MODULE$.println((Object)new StringBuilder(52).append("Do you want to downgrade scala-cli to version ").append(newVersion).append(" [Y/n]").toString());
            String string = response = StdIn$.MODULE$.readLine();
            String string2 = "Y";
            if (string == null ? string2 != null : !string.equals(string2)) {
                System.err.println("Abort");
                throw scala.sys.package$.MODULE$.exit(1);
            }
        } else {
            System.err.println(new StringBuilder(88).append("Error: scala-cli is already installed ").append(oldVersion).append(" and up-to-date. Downgrade to ").append(newVersion).append(" pass -f or --force.").toString());
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    public void run(InstallHomeOptions options, RemainingArgs args) {
        String oldVersion;
        boolean bl;
        long l;
        boolean bl2;
        ProcessOutput processOutput;
        ProcessOutput processOutput2;
        ProcessInput processInput;
        Map map;
        Path path;
        proc proc2;
        CommandResult res;
        CurrentParams$.MODULE$.verbosity_$eq(options.verbosity().verbosity());
        Path binDirPath = (Path)options.binDirPath().getOrElse(this::$anonfun$1);
        Path destBinPath = binDirPath.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(options.binaryName()));
        Path newScalaCliBinPath = Path$.MODULE$.apply((Object)options.scalaCliBinaryPath(), os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$);
        proc proc3 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(newScalaCliBinPath), Shellable$.MODULE$.StringShellable("version")}));
        String newVersion = proc3.call(os.package$.MODULE$.pwd(), proc3.call$default$2(), proc3.call$default$3(), proc3.call$default$4(), proc3.call$default$5(), proc3.call$default$6(), proc3.call$default$7(), proc3.call$default$8(), proc3.call$default$9()).out().text().trim();
        String string = isFile$.MODULE$.apply(destBinPath) ? ((res = (proc2 = proc$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Shellable[]{Shellable$.MODULE$.PathShellable(destBinPath), Shellable$.MODULE$.StringShellable("version")}))).call(path = os.package$.MODULE$.pwd(), map = proc2.call$default$2(), processInput = proc2.call$default$3(), processOutput2 = proc2.call$default$4(), processOutput = proc2.call$default$5(), bl2 = proc2.call$default$6(), l = proc2.call$default$7(), false, bl = proc2.call$default$9())).exitCode() == 0 ? res.out().text().trim() : "0.0.0") : (oldVersion = "0.0.0");
        if (exists$.MODULE$.apply(binDirPath) && !options.force()) {
            String string2 = newVersion;
            String string3 = oldVersion;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                throw this.logEqual(newVersion);
            }
            if (CommandUtils$.MODULE$.isOutOfDateVersion(newVersion, oldVersion)) {
                this.logUpdate(options.env(), newVersion, oldVersion);
            } else {
                this.logDowngrade(options.env(), newVersion, oldVersion);
            }
        }
        if (exists$.MODULE$.apply(destBinPath)) {
            remove$.MODULE$.apply(destBinPath);
        }
        copy$.MODULE$.apply(newScalaCliBinPath, destBinPath, copy$.MODULE$.apply$default$3(), copy$.MODULE$.apply$default$4(), copy$.MODULE$.apply$default$5(), true, copy$.MODULE$.apply$default$7());
        if (!Properties$.MODULE$.isWin()) {
            perms.set$.MODULE$.apply(destBinPath, PermSet$.MODULE$.fromString("rwxr-xr-x"));
        }
        if (options.env()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("export PATH=\"").append(binDirPath).append(":$PATH\"").toString());
        } else {
            boolean bl3;
            Object[] objectArray = new Tuple2[1];
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"PATH");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)binDirPath.toString());
            EnvironmentUpdate update = EnvironmentUpdate$.MODULE$.apply((Seq)package$.MODULE$.Nil(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            if (Properties$.MODULE$.isWin()) {
                CustomWindowsEnvVarUpdater updater = CustomWindowsEnvVarUpdater$.MODULE$.apply(CustomWindowsEnvVarUpdater$.MODULE$.$lessinit$greater$default$1(), CustomWindowsEnvVarUpdater$.MODULE$.$lessinit$greater$default$2()).withUseJni((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)Util.useJni())));
                bl3 = updater.applyUpdate(update);
            } else {
                ProfileUpdater updater = ProfileUpdater$.MODULE$.apply();
                bl3 = updater.applyUpdate(update);
            }
            boolean didUpdate = bl3;
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("Successfully installed scala-cli ").append(newVersion).toString());
            if (didUpdate) {
                if (Properties$.MODULE$.isLinux()) {
                    Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Profile file(s) updated.\n                |To run scala-cli, log out and log back in, or run 'source ~/.profile'")));
                }
                if (Properties$.MODULE$.isMac()) {
                    Predef$.MODULE$.println((Object)"To run scala-cli, open new terminal or run 'source ~/.profile'");
                }
            }
        }
    }

    private final Path $anonfun$1() {
        return Directories$.MODULE$.default().binRepoDir().$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("scala-cli"));
    }
}

