/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish.checks;

import coursier.cache.ArchiveCache$;
import coursier.cache.FileCache;
import java.io.Serializable;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.build.EitherCps$;
import scala.build.Logger;
import scala.build.Ops;
import scala.build.Ops$;
import scala.build.errors.BuildException;
import scala.build.errors.BuildException$;
import scala.build.errors.CompositeBuildException$;
import scala.build.errors.MalformedCliInputError;
import scala.build.options.BuildOptions;
import scala.build.options.JavaOptions;
import scala.build.options.PublishContextualOptions;
import scala.build.options.PublishOptions;
import scala.build.options.publish.ConfigPasswordOption;
import scala.cli.commands.config.ThrowawayPgpSecret$;
import scala.cli.commands.pgp.KeyServer$;
import scala.cli.commands.pgp.PgpProxyMaker;
import scala.cli.commands.publish.ConfigUtil$;
import scala.cli.commands.publish.OptionCheck;
import scala.cli.commands.publish.OptionCheck$DefaultValue$;
import scala.cli.commands.publish.OptionCheck$Kind$Signing$;
import scala.cli.commands.publish.PublishSetupOptions;
import scala.cli.commands.publish.SetSecret;
import scala.cli.commands.publish.SetSecret$;
import scala.cli.commands.publish.checks.PgpSecretKeyCheck$;
import scala.cli.commands.util.JvmUtils$;
import scala.cli.config.ConfigDb;
import scala.cli.config.Key;
import scala.cli.config.Keys$;
import scala.cli.config.PasswordOption;
import scala.cli.config.Secret;
import scala.cli.errors.MissingPublishOptionError;
import scala.cli.errors.MissingPublishOptionError$;
import scala.cli.util.ConfigPasswordOptionHelpers$;
import scala.cli.util.ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$;
import scala.cli.util.MaybeConfigPasswordOption;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client3.SttpBackend;
import sttp.model.Uri;
import sttp.model.Uri$;

public final class PgpSecretKeyCheck
implements OptionCheck,
Product,
Serializable {
    private final PublishSetupOptions options;
    private final FileCache coursierCache;
    private final Function0 configDb;
    private final Logger logger;
    private final SttpBackend backend;
    private final Set<Object> base64Chars;

    public static PgpSecretKeyCheck apply(PublishSetupOptions publishSetupOptions, FileCache<Function1> fileCache, Function0<ConfigDb> function0, Logger logger, SttpBackend<Object, Object> sttpBackend) {
        return PgpSecretKeyCheck$.MODULE$.apply(publishSetupOptions, fileCache, function0, logger, sttpBackend);
    }

    public static PgpSecretKeyCheck fromProduct(Product product) {
        return PgpSecretKeyCheck$.MODULE$.fromProduct(product);
    }

    public static PgpSecretKeyCheck unapply(PgpSecretKeyCheck pgpSecretKeyCheck) {
        return PgpSecretKeyCheck$.MODULE$.unapply(pgpSecretKeyCheck);
    }

    public PgpSecretKeyCheck(PublishSetupOptions options, FileCache<Function1> coursierCache, Function0<ConfigDb> configDb, Logger logger, SttpBackend<Object, Object> backend) {
        this.options = options;
        this.coursierCache = coursierCache;
        this.configDb = configDb;
        this.logger = logger;
        this.backend = backend;
        this.base64Chars = ((IterableOnceOps)((IndexedSeqOps)((IterableOps)((IterableOps)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'+', '/', '='})))).map((Function1 & Serializable)_$1 -> PgpSecretKeyCheck.$init$$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)))).toSet();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PgpSecretKeyCheck)) return false;
        PgpSecretKeyCheck pgpSecretKeyCheck = (PgpSecretKeyCheck)object;
        PublishSetupOptions publishSetupOptions = this.options();
        PublishSetupOptions publishSetupOptions2 = pgpSecretKeyCheck.options();
        if (publishSetupOptions == null) {
            if (publishSetupOptions2 != null) {
                return false;
            }
        } else if (!((Object)publishSetupOptions).equals(publishSetupOptions2)) return false;
        FileCache<Function1> fileCache = this.coursierCache();
        FileCache<Function1> fileCache2 = pgpSecretKeyCheck.coursierCache();
        if (fileCache == null) {
            if (fileCache2 != null) {
                return false;
            }
        } else if (!fileCache.equals(fileCache2)) return false;
        Function0<ConfigDb> function0 = this.configDb();
        Function0<ConfigDb> function02 = pgpSecretKeyCheck.configDb();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        Logger logger = this.logger();
        Logger logger2 = pgpSecretKeyCheck.logger();
        if (logger == null) {
            if (logger2 != null) {
                return false;
            }
        } else if (!logger.equals(logger2)) return false;
        SttpBackend<Object, Object> sttpBackend = this.backend();
        SttpBackend<Object, Object> sttpBackend2 = pgpSecretKeyCheck.backend();
        if (sttpBackend == null) {
            if (sttpBackend2 == null) return true;
            return false;
        } else {
            if (!sttpBackend.equals(sttpBackend2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PgpSecretKeyCheck;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "PgpSecretKeyCheck";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "options";
            }
            case 1: {
                return "coursierCache";
            }
            case 2: {
                return "configDb";
            }
            case 3: {
                return "logger";
            }
            case 4: {
                return "backend";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PublishSetupOptions options() {
        return this.options;
    }

    public FileCache<Function1> coursierCache() {
        return this.coursierCache;
    }

    public Function0<ConfigDb> configDb() {
        return this.configDb;
    }

    public Logger logger() {
        return this.logger;
    }

    public SttpBackend<Object, Object> backend() {
        return this.backend;
    }

    @Override
    public OptionCheck.Kind kind() {
        return OptionCheck$Kind$Signing$.MODULE$;
    }

    @Override
    public String fieldName() {
        return "pgp-secret-key";
    }

    @Override
    public String directivePath() {
        return new StringBuilder(17).append("publish").append(this.options().publishParams().setupCi() ? ".ci" : "").append(".secretKey").toString();
    }

    @Override
    public boolean check(PublishOptions pubOpt) {
        PublishContextualOptions opt0 = pubOpt.retained(this.options().publishParams().setupCi());
        return opt0.repository().orElse(this::check$$anonfun$1).contains((Object)"github") || opt0.secretKey().isDefined();
    }

    private String maybeEncodeBase64(byte[] input) {
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(input);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object2) && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.byteArrayOps(input), (Function1 & Serializable)elem -> this.maybeEncodeBase64$$anonfun$1(BoxesRunTime.unboxToByte((Object)elem)))) {
            Object object3 = Predef$.MODULE$.byteArrayOps(input);
            return new String((char[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$2 -> PgpSecretKeyCheck.maybeEncodeBase64$$anonfun$2(BoxesRunTime.unboxToByte((Object)_$2)), ClassTag$.MODULE$.apply(Character.TYPE)));
        }
        return Base64.getEncoder().encodeToString(input);
    }

    public Either<BuildException, Function0<String>> javaCommand() {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$1 -> (Function0 & Serializable)() -> ((BuildOptions.JavaHomeInfo)((JavaOptions)EitherCps$.MODULE$.value(evidence$1, JvmUtils$.MODULE$.javaOptions(this.options().sharedJvm()))).javaHome(ArchiveCache$.MODULE$.apply(ArchiveCache$.MODULE$.apply$default$1()).withCache(this.coursierCache()), this.coursierCache(), this.logger().verbosity()).value()).javaCommand());
    }

    @Override
    public Either<BuildException, OptionCheck.DefaultValue> defaultValue(PublishOptions pubOpt) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$2 -> {
            if (this.options().publishParams().setupCi()) {
                Secret secret;
                Function0 & Serializable intersect;
                Tuple3 tuple3;
                Option<MaybeConfigPasswordOption> option = this.options().publishParams().secretKey();
                if (option instanceof Some) {
                    MaybeConfigPasswordOption secretKey = (MaybeConfigPasswordOption)((Some)option).value();
                    Option pubKeyOpt = this.options().publicKey().map((Function1 & Serializable)_$3 -> ConfigUtil$.MODULE$.toConfig(_$3.get()));
                    Option option2 = Ops$.MODULE$.EitherOptOps(this.options().publishParams().secretKeyPassword().map((Function1 & Serializable)_$4 -> _$4.configPasswordOptions()).map((Function1 & Serializable)_$5 -> ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)_$5), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$3$$anonfun$1))));
                    Option passwordOpt = (Option)EitherCps$.MODULE$.value(evidence$2, Ops.EitherOptOps$.MODULE$.sequence$extension(option2));
                    tuple3 = Tuple3$.MODULE$.apply((Object)pubKeyOpt, (Object)package$.MODULE$.Left().apply((Object)secretKey), (Object)passwordOpt);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    Option option3 = (Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKey())));
                    if (option3 instanceof Some) {
                        PasswordOption secretKey = (PasswordOption)((Some)option3).value();
                        Option pubKeyOpt = (Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpPublicKey())));
                        Option passwordOpt = (Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKeyPassword())));
                        tuple3 = Tuple3$.MODULE$.apply((Object)pubKeyOpt.map((Function1 & Serializable)_$6 -> _$6.get()), (Object)package$.MODULE$.Right().apply((Object)secretKey), (Object)passwordOpt);
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                        boolean randomSecretKey = BoxesRunTime.unboxToBoolean((Object)this.options().randomSecretKey().getOrElse(PgpSecretKeyCheck::$anonfun$5));
                        if (randomSecretKey) {
                            Option option4 = Ops$.MODULE$.EitherOptOps(this.options().publishParams().secretKeyPassword().map((Function1 & Serializable)_$7 -> _$7.configPasswordOptions()).map((Function1 & Serializable)_$8 -> ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps((ConfigPasswordOption)_$8), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$7$$anonfun$1))));
                            Option res = (Option)EitherCps$.MODULE$.value(evidence$2, Ops.EitherOptOps$.MODULE$.sequence$extension(option4));
                            scala.cli.signing.shared.Secret password = (scala.cli.signing.shared.Secret)res.map((Function1 & Serializable)_$9 -> ConfigUtil$.MODULE$.toCliSigning(_$9.get())).getOrElse(PgpSecretKeyCheck::$anonfun$9);
                            String mail = (String)EitherCps$.MODULE$.value(evidence$2, this.options().randomSecretKeyMail().toRight(PgpSecretKeyCheck::$anonfun$10));
                            Tuple2 tuple2 = (Tuple2)EitherCps$.MODULE$.value(evidence$2, ThrowawayPgpSecret$.MODULE$.pgpSecret(mail, (scala.cli.signing.shared.Secret<String>)password, this.logger(), this.coursierCache(), (Function0<String>)((Function0)EitherCps$.MODULE$.value(evidence$2, this.javaCommand())), this.options().scalaSigning().cliOptions()));
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            scala.cli.signing.shared.Secret pgpPublic = (scala.cli.signing.shared.Secret)tuple2._1();
                            scala.cli.signing.shared.Secret pgpSecret0 = (scala.cli.signing.shared.Secret)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pgpPublic, (Object)pgpSecret0);
                            scala.cli.signing.shared.Secret pgpPublic2 = (scala.cli.signing.shared.Secret)tuple22._1();
                            scala.cli.signing.shared.Secret pgpSecret02 = (scala.cli.signing.shared.Secret)tuple22._2();
                            Base64.Encoder encoder = Base64.getEncoder();
                            scala.cli.signing.shared.Secret pgpSecretBase64 = pgpSecret02.map((Function1 & Serializable)x$0 -> encoder.encodeToString((byte[])x$0));
                            tuple3 = Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply(ConfigUtil$.MODULE$.toConfig(pgpPublic2)), (Object)package$.MODULE$.Right().apply((Object)PasswordOption.Value$.MODULE$.apply(ConfigUtil$.MODULE$.toConfig(pgpSecretBase64))), (Object)Some$.MODULE$.apply((Object)PasswordOption.Value$.MODULE$.apply(ConfigUtil$.MODULE$.toConfig(password))));
                        } else {
                            tuple3 = (Tuple3)EitherCps$.MODULE$.value(evidence$2, (Either)package$.MODULE$.Left().apply((Object)new MissingPublishOptionError("publish secret key", "--secret-key", "publish.secretKey", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Keys$.MODULE$.pgpSecretKey().fullName()}))), new StringBuilder(74).append(", and specify publish.secretKeyPassword / --secret-key-password if needed.").append(this.options().publishParams().setupCi() ? " Alternatively, pass --random-secret-key" : "").toString())));
                        }
                    }
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Option pubKeyOpt = (Option)tuple32._1();
                Either secretKey = (Either)tuple32._2();
                Option passwordOpt = (Option)tuple32._3();
                Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)pubKeyOpt, (Object)secretKey, (Object)passwordOpt);
                Option pubKeyOpt2 = (Option)tuple33._1();
                Either secretKey2 = (Either)tuple33._2();
                Option passwordOpt2 = (Option)tuple33._3();
                Option option5 = pubKeyOpt2;
                if (option5 instanceof Some) {
                    Right right;
                    Secret pubKey = (Secret)((Some)option5).value();
                    String keyId = (String)EitherCps$.MODULE$.value(evidence$2, new PgpProxyMaker().get().keyId((String)pubKey.value(), "[generated key]", this.coursierCache(), this.logger(), (Function0<String>)((Function0)EitherCps$.MODULE$.value(evidence$2, this.javaCommand())), this.options().scalaSigning().cliOptions()));
                    List rawKeyServers = this.options().sharedPgp().keyServer().filter((Function1 & Serializable)_$10 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$10.trim())));
                    if (rawKeyServers.filter((Function1 & Serializable)_$11 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$11.trim()))).isEmpty()) {
                        right = package$.MODULE$.Right().apply(KeyServer$.MODULE$.allDefaults());
                    } else {
                        Seq seq = Ops$.MODULE$.EitherSeqOps((Seq)rawKeyServers.map((Function1 & Serializable)keyServerUriStr -> Uri$.MODULE$.parse(keyServerUriStr).left().map((Function1 & Serializable)err -> new MalformedCliInputError(new StringBuilder(29).append("Malformed key server URI '").append((String)keyServerUriStr).append("': ").append((String)err).toString()))));
                        right = Ops.EitherSeqOps$.MODULE$.sequence$extension(seq).left().map((Function1 & Serializable)_$12 -> CompositeBuildException$.MODULE$.apply(_$12));
                    }
                    Seq keyServers = (Seq)EitherCps$.MODULE$.value(evidence$2, (Either)right);
                    intersect = (Function0 & Serializable)() -> {
                        Seq seq = Ops$.MODULE$.EitherSeqOps((Seq)keyServers.map((Function1 & Serializable)keyServer -> {
                            if (this.options().dummy()) {
                                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            }
                            Either e = EitherCps$.MODULE$.either().apply((Function1)(JProcedure1 & Serializable)evidence$3 -> {
                                Either checkResp = (Either)EitherCps$.MODULE$.value(evidence$3, KeyServer$.MODULE$.check(keyId, (Uri)keyServer, this.backend()).left().map((Function1 & Serializable)msg -> new KeyServerError(new StringBuilder(26).append("Error getting key ").append(keyId).append(" from ").append(keyServer).append(": ").append((String)msg).toString())));
                                this.logger().debug(() -> PgpSecretKeyCheck.$anonfun$17$$anonfun$1(checkResp));
                                boolean check = checkResp.isRight();
                                if (!check) {
                                    String resp = (String)EitherCps$.MODULE$.value(evidence$3, KeyServer$.MODULE$.add((String)pubKey.value(), (Uri)keyServer, this.backend()).left().map((Function1 & Serializable)msg -> new KeyServerError(new StringBuilder(26).append("Error uploading key ").append(keyId).append(" to ").append(keyServer).append(": ").append((String)msg).toString())));
                                    this.logger().debug(() -> PgpSecretKeyCheck.$anonfun$17$$anonfun$2(resp));
                                    this.logger().message(PgpSecretKeyCheck::$anonfun$17$$anonfun$3);
                                    this.logger().message(() -> PgpSecretKeyCheck.$anonfun$17$$anonfun$4(keyId, keyServer));
                                    return;
                                }
                            });
                            return e;
                        }));
                        return Ops.EitherSeqOps$.MODULE$.sequence$extension(seq).left().map((Function1 & Serializable)_$13 -> CompositeBuildException$.MODULE$.apply(_$13)).map((Function1)(JProcedure1 & Serializable)_$14 -> {});
                    };
                } else {
                    if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
                    this.logger().message(PgpSecretKeyCheck::$anonfun$20);
                    intersect = (Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                }
                Function0 & Serializable pushKey = intersect;
                Tuple2 tuple2 = (Tuple2)passwordOpt2.map((Function1 & Serializable)p -> {
                    if (this.options().publishParams().setupCi()) {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.ci.secretKeyPassword");
                        Tuple2 dir = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"env:PUBLISH_SECRET_KEY_PASSWORD");
                        SetSecret setSec = SetSecret$.MODULE$.apply("PUBLISH_SECRET_KEY_PASSWORD", (Secret<String>)p.get(), true);
                        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SetSecret[]{setSec})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{dir})));
                    }
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"publish.secretKeyPassword");
                    Tuple2 dir = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, p.asString().value());
                    return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{dir})));
                }).getOrElse(PgpSecretKeyCheck::$anonfun$23);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq passwordSetSecret = (Seq)tuple2._1();
                Seq extraDirectives = (Seq)tuple2._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)passwordSetSecret, (Object)extraDirectives);
                Seq passwordSetSecret2 = (Seq)tuple23._1();
                Seq extraDirectives2 = (Seq)tuple23._2();
                Seq$ seq$ = package$.MODULE$.Seq();
                Object[] objectArray = new SetSecret[1];
                Either either = secretKey2;
                if (either instanceof Left) {
                    MaybeConfigPasswordOption p2 = (MaybeConfigPasswordOption)((Left)either).value();
                    secret = ((PasswordOption)EitherCps$.MODULE$.value(evidence$2, ConfigPasswordOptionHelpers$ConfigPasswordOptionOps$.MODULE$.get$extension(ConfigPasswordOptionHelpers$.MODULE$.ConfigPasswordOptionOps(p2.configPasswordOptions()), (Function0<ConfigDb>)((Function0 & Serializable)this::$anonfun$24)))).getBytes().map((Function1 & Serializable)input -> this.maybeEncodeBase64((byte[])input));
                } else {
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    PasswordOption p3 = (PasswordOption)((Right)either).value();
                    secret = p3.getBytes().map((Function1 & Serializable)input -> this.maybeEncodeBase64((byte[])input));
                }
                objectArray[0] = SetSecret$.MODULE$.apply("PUBLISH_SECRET_KEY", (Secret<String>)secret, true);
                Seq setSecrets = (Seq)seq$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).$plus$plus((IterableOnce)passwordSetSecret2);
                return OptionCheck$DefaultValue$.MODULE$.apply((Function0<Either<BuildException, Option<String>>>)(Function0 & Serializable)() -> ((Either)pushKey.apply()).map((Function1 & Serializable)_$15 -> Some$.MODULE$.apply((Object)"env:PUBLISH_SECRET_KEY")), (Seq<Tuple2<String, String>>)extraDirectives2, (Seq<SetSecret>)setSecrets);
            }
            if (!((Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKey())))).isDefined()) return (OptionCheck.DefaultValue)EitherCps$.MODULE$.value(evidence$2, (Either)package$.MODULE$.Left().apply((Object)new MissingPublishOptionError("publish secret key", "", "publish.secretKey", (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Keys$.MODULE$.pgpSecretKey().fullName()}))), MissingPublishOptionError$.MODULE$.$lessinit$greater$default$5())));
            boolean hasPubKey = ((Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpPublicKey())))).isDefined();
            boolean hasPassword = ((Option)EitherCps$.MODULE$.value(evidence$2, ConfigUtil$.MODULE$.wrapConfigException(((ConfigDb)this.configDb().apply()).get((Key)Keys$.MODULE$.pgpSecretKeyPassword())))).isDefined();
            if (!hasPubKey) {
                this.logger().message(PgpSecretKeyCheck::defaultValue$$anonfun$1$$anonfun$2);
            }
            if (hasPassword) return OptionCheck$DefaultValue$.MODULE$.empty();
            this.logger().message(PgpSecretKeyCheck::defaultValue$$anonfun$1$$anonfun$3);
            return OptionCheck$DefaultValue$.MODULE$.empty();
        });
    }

    public PgpSecretKeyCheck copy(PublishSetupOptions options, FileCache<Function1> coursierCache, Function0<ConfigDb> configDb, Logger logger, SttpBackend<Object, Object> backend) {
        return new PgpSecretKeyCheck(options, coursierCache, configDb, logger, backend);
    }

    public PublishSetupOptions copy$default$1() {
        return this.options();
    }

    public FileCache<Function1> copy$default$2() {
        return this.coursierCache();
    }

    public Function0<ConfigDb> copy$default$3() {
        return this.configDb();
    }

    public Logger copy$default$4() {
        return this.logger();
    }

    public SttpBackend<Object, Object> copy$default$5() {
        return this.backend();
    }

    public PublishSetupOptions _1() {
        return this.options();
    }

    public FileCache<Function1> _2() {
        return this.coursierCache();
    }

    public Function0<ConfigDb> _3() {
        return this.configDb();
    }

    public Logger _4() {
        return this.logger();
    }

    public SttpBackend<Object, Object> _5() {
        return this.backend();
    }

    private static final /* synthetic */ byte $init$$$anonfun$1(char _$1) {
        return (byte)_$1;
    }

    private final Option check$$anonfun$1() {
        return this.options().publishRepo().publishRepository();
    }

    private final /* synthetic */ boolean maybeEncodeBase64$$anonfun$1(byte elem) {
        return this.base64Chars.contains((Object)BoxesRunTime.boxToByte((byte)elem));
    }

    private static final /* synthetic */ char maybeEncodeBase64$$anonfun$2(byte _$2) {
        return (char)_$2;
    }

    private final ConfigDb $anonfun$3$$anonfun$1() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final boolean $anonfun$5() {
        return false;
    }

    private final ConfigDb $anonfun$7$$anonfun$1() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final scala.cli.signing.shared.Secret $anonfun$9() {
        return ThrowawayPgpSecret$.MODULE$.pgpPassPhrase();
    }

    private static final MissingPublishOptionError $anonfun$10() {
        return new MissingPublishOptionError("random secret key mail", "--random-secret-key-mail", "", MissingPublishOptionError$.MODULE$.$lessinit$greater$default$4(), MissingPublishOptionError$.MODULE$.$lessinit$greater$default$5());
    }

    private static final String $anonfun$17$$anonfun$1(Either checkResp$1) {
        return new StringBuilder(27).append("Key server check response: ").append(checkResp$1).toString();
    }

    private static final String $anonfun$17$$anonfun$2(String resp$1) {
        return new StringBuilder(28).append("Key server upload response: ").append(resp$1).toString();
    }

    private static final String $anonfun$17$$anonfun$3() {
        return "";
    }

    private static final String $anonfun$17$$anonfun$4(String keyId$6, Uri keyServer$4) {
        return new StringBuilder(19).append("Uploaded key 0x").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(keyId$6), "0x")).append(" to ").append(keyServer$4).toString();
    }

    private static final String $anonfun$20() {
        return "Warning: no public key passed, not checking if the key needs to be uploaded to a key server.";
    }

    private static final Tuple2 $anonfun$23() {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Nil());
    }

    private final ConfigDb $anonfun$24() {
        return (ConfigDb)this.configDb().apply();
    }

    private static final String defaultValue$$anonfun$1$$anonfun$2() {
        return "Warning: no PGP public key found in config";
    }

    private static final String defaultValue$$anonfun$1$$anonfun$3() {
        return "Warning: no PGP secret key password found in config";
    }

    public static final class KeyServerError
    extends BuildException {
        public KeyServerError(String message) {
            super(message, BuildException$.MODULE$.$lessinit$greater$default$2(), BuildException$.MODULE$.$lessinit$greater$default$3());
        }

        private String message$accessor() {
            return super.message();
        }
    }
}

