/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.publish;

import java.io.File;
import java.io.Serializable;
import java.nio.file.attribute.UserPrincipal;
import org.eclipse.jgit.api.Git;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.isDir$;
import os.owner$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Logger;
import scala.cli.commands.publish.GitRepoError;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Properties$;
import scala.util.Using;
import scala.util.Using$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class GitRepo$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitRepo$.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private static UserPrincipal user$lzy1;
    public static final GitRepo$ MODULE$;

    private GitRepo$() {
    }

    static {
        MODULE$ = new GitRepo$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitRepo$.class);
    }

    private UserPrincipal user() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 0)) continue;
                try {
                    UserPrincipal userPrincipal;
                    user$lzy1 = userPrincipal = owner$.MODULE$.apply(os.package$.MODULE$.home());
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 0);
                    return userPrincipal;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 0);
        }
        return user$lzy1;
    }

    private boolean trusted(Path path) {
        if (Properties$.MODULE$.isWin()) {
            return path.toIO().canWrite();
        }
        UserPrincipal userPrincipal = owner$.MODULE$.apply(path);
        UserPrincipal userPrincipal2 = this.user();
        return !(userPrincipal != null ? !userPrincipal.equals(userPrincipal2) : userPrincipal2 != null);
    }

    public Option<Path> gitRepoOpt(Path workspace) {
        while (this.trusted(workspace)) {
            if (isDir$.MODULE$.apply(workspace.$div((PathChunk)PathChunk$.MODULE$.StringPathChunk(".git")))) {
                return Some$.MODULE$.apply((Object)workspace);
            }
            if (workspace.segmentCount() > 0) {
                workspace = workspace.$div((PathChunk)PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up()));
                continue;
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Either<GitRepoError, Tuple2<String, String>> ghRepoOrgName(Path workspace, Logger logger) {
        Option<Path> option = this.gitRepoOpt(workspace);
        if (option instanceof Some) {
            Path repo = (Path)((Some)option).value();
            Seq<Tuple2<String, Tuple2<String, String>>> seq = this.remotes(repo, logger);
            if (seq != null) {
                Tuple2 tuple2;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    return package$.MODULE$.Left().apply((Object)new GitRepoError(new StringBuilder(50).append("Cannot determine GitHub organization and name for ").append(workspace).toString()));
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
                    Tuple2 orgName = (Tuple2)tuple2._2();
                    return package$.MODULE$.Right().apply((Object)orgName);
                }
            }
            Seq<Tuple2<String, Tuple2<String, String>>> more = seq;
            Map map = more.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return map.get((Object)"upstream").orElse(() -> this.ghRepoOrgName$$anonfun$1(map)).toRight(() -> this.ghRepoOrgName$$anonfun$2(workspace));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new GitRepoError(new StringBuilder(27).append(workspace).append(" is not in a git repository").toString()));
        }
        throw new MatchError(option);
    }

    private Seq<Tuple2<String, Tuple2<String, String>>> remotes(Path repo, Logger logger) {
        Buffer remoteList = (Buffer)Using$.MODULE$.resource((Object)Git.open((File)repo.toIO()), (Function1 & Serializable)git -> CollectionConverters$.MODULE$.ListHasAsScala(git.remoteList().call()).asScala(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        logger.debug(() -> this.remotes$$anonfun$1(repo, remoteList));
        return remoteList.iterator().flatMap((Function1 & Serializable)remote -> {
            String name = remote.getName();
            return CollectionConverters$.MODULE$.ListHasAsScala(remote.getURIs()).asScala().iterator().map((Function1 & Serializable)_$1 -> _$1.toASCIIString()).flatMap((Function1 & Serializable)uri -> this.maybeGhOrgName((String)uri)).map((Function1 & Serializable)_$2 -> Tuple2$.MODULE$.apply((Object)name, _$2));
        }).toVector();
    }

    public Option<Tuple2<String, String>> maybeGhRepoOrgName(Path workspace, Logger logger) {
        return this.gitRepoOpt(workspace).flatMap((Function1 & Serializable)repo -> {
            Seq<Tuple2<String, Tuple2<String, String>>> more;
            Map map;
            Option res;
            Seq<Tuple2<String, Tuple2<String, String>>> seq = this.remotes((Path)repo, logger);
            if (seq != null) {
                Tuple2 tuple2;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    logger.debug(() -> this.maybeGhRepoOrgName$$anonfun$1$$anonfun$1(workspace));
                    return None$.MODULE$;
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
                    Tuple2 orgName = (Tuple2)tuple2._2();
                    return Some$.MODULE$.apply((Object)orgName);
                }
            }
            if ((res = (map = (more = seq).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).get((Object)"upstream").orElse(() -> this.$anonfun$2(map))).isEmpty()) {
                new GitRepoError(new StringBuilder(58).append("Cannot determine default GitHub organization and name for ").append(workspace).toString());
            }
            return res;
        });
    }

    public Option<Tuple2<String, String>> maybeGhOrgName(String uri) {
        if (uri.startsWith("https://github.com/")) {
            Object object;
            String pathPart = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(uri), "https://github.com/")), ".git");
            String[] stringArray = pathPart.split("/");
            if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String org = string;
                String name = string2;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)org, (Object)name));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private final Option ghRepoOrgName$$anonfun$1(Map map$1) {
        return map$1.get((Object)"origin");
    }

    private final GitRepoError ghRepoOrgName$$anonfun$2(Path workspace$1) {
        return new GitRepoError(new StringBuilder(58).append("Cannot determine default GitHub organization and name for ").append(workspace$1).toString());
    }

    private final String remotes$$anonfun$1(Path repo$1, Buffer remoteList$1) {
        return new StringBuilder(27).append("Found ").append(remoteList$1.length()).append(" remotes in Git repo ").append(repo$1).toString();
    }

    private final String maybeGhRepoOrgName$$anonfun$1$$anonfun$1(Path workspace$3) {
        return new StringBuilder(26).append("No GitHub remote found in ").append(workspace$3).toString();
    }

    private final Option $anonfun$2(Map map$2) {
        return map$2.get((Object)"origin");
    }
}

