/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.github;

import caseapp.core.RemainingArgs;
import coursier.cache.ArchiveCache;
import coursier.cache.ArchiveCache$;
import coursier.cache.Cache;
import coursier.cache.FileCache;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import libsodiumjni.Sodium;
import os.Path$;
import os.PathConvertible;
import os.ReadablePath;
import os.read;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.build.EitherCps$;
import scala.build.Logger;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.github.GitHubApi;
import scala.cli.commands.github.GitHubApi$;
import scala.cli.commands.github.GitHubApi$EncryptedSecret$;
import scala.cli.commands.github.LibSodiumJni$;
import scala.cli.commands.github.SecretCreateOptions;
import scala.cli.commands.github.SecretCreateOptions$;
import scala.cli.commands.publish.ConfigUtil$;
import scala.cli.commands.util.ScalaCliSttpBackend;
import scala.cli.commands.util.ScalaCliSttpBackend$;
import scala.cli.config.PasswordOption;
import scala.cli.config.PasswordOption$;
import scala.cli.config.Secret;
import scala.cli.errors.GitHubApiError;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client3.Response;
import sttp.client3.SttpBackend;
import sttp.model.StatusCode;
import sttp.model.Uri;

public final class SecretCreate$
extends ScalaCommand<SecretCreateOptions> {
    public static final SecretCreate$ MODULE$ = new SecretCreate$();

    private SecretCreate$() {
        super(SecretCreateOptions$.MODULE$.parser(), SecretCreateOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SecretCreate$.class);
    }

    public boolean hidden() {
        return false;
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.RESTRICTED$.MODULE$;
    }

    public List<List<String>> names() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"github", "secret", "create"})), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"gh", "secret", "create"}))}));
    }

    private Tuple2<String, Secret<String>> parseSecretKv(String input) {
        Object object;
        String[] stringArray = input.split("=", 2);
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String name = string;
            String value = string2;
            Either either = PasswordOption$.MODULE$.parse(value);
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("Error parsing secret: ").append(err).toString());
            }
            if (either instanceof Right) {
                PasswordOption opt = (PasswordOption)((Right)either).value();
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)opt.get());
            }
            throw new MatchError((Object)either);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(109).append("Malformed secret '").append(input).append("' (expected name=password, with password either file:path, command:command, or value:value)").toString());
    }

    public Either<GitHubApiError, GitHubApi.PublicKey> publicKey(String repoOrg, String repoName, Secret<String> token, SttpBackend<Object, Object> backend, Logger logger) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$1 -> {
            String string;
            Either either;
            Response publicKeyResp = (Response)sttp.client3.package$.MODULE$.basicRequest().get(sttp.client3.package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"https://api.github.com/repos/", "/", "/actions/secrets/public-key"}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{repoOrg, repoName}))).header("Authorization", new StringBuilder(6).append("token ").append(token.value()).toString()).header("Accept", "application/vnd.github.v3+json").send(backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (publicKeyResp.code() != 200) {
                EitherCps$.MODULE$.value(evidence$1, (Either)package$.MODULE$.Left().apply((Object)new GitHubApiError(new StringBuilder(38).append("Error getting public key (code ").append(new StatusCode(publicKeyResp.code())).append(") for ").append(repoOrg).append("/").append(repoName).toString())));
            }
            if ((either = (Either)publicKeyResp.body()) instanceof Left) {
                string = (String)EitherCps$.MODULE$.value(evidence$1, (Either)package$.MODULE$.Left().apply((Object)new GitHubApiError(new StringBuilder(61).append("Unexpected missing body in response when listing secrets of ").append(repoOrg).append("/").append(repoName).toString())));
            } else if (either instanceof Right) {
                String value;
                string = value = (String)((Right)either).value();
            } else {
                throw new MatchError((Object)either);
            }
            String publicKeyRespBody = string;
            logger.debug(() -> this.publicKey$$anonfun$1$$anonfun$1(publicKeyRespBody));
            return (GitHubApi.PublicKey)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromString(publicKeyRespBody, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromString$default$2(), GitHubApi$.MODULE$.publicKeyCodec());
        });
    }

    public Either<GitHubApiError, Object> createOrUpdate(String repoOrg, String repoName, Secret<String> token, String secretName, Secret<String> secretValue, GitHubApi.PublicKey pubKey, boolean dummy, boolean printRequest, SttpBackend<Object, Object> backend, Logger logger) {
        return EitherCps$.MODULE$.either().apply((Function1 & Serializable)evidence$2 -> {
            byte[] secretBytes = ((String)secretValue.value()).getBytes(StandardCharsets.UTF_8);
            byte[] encryptedValue = Sodium.seal((byte[])secretBytes, (byte[])pubKey.decodedKey());
            GitHubApi.EncryptedSecret content = GitHubApi$EncryptedSecret$.MODULE$.apply(Base64.getEncoder().encodeToString(encryptedValue), pubKey.key_id());
            Uri uri = sttp.client3.package$.MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"https://api.github.com/repos/", "/", "/actions/secrets/", ""}))).uri((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{repoOrg, repoName, secretName}));
            byte[] requestBody = com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray((Object)content, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.writeToArray$default$2(), GitHubApi$.MODULE$.encryptedSecretCodec());
            if (printRequest) {
                System.out.write(requestBody);
            }
            if (dummy) {
                logger.debug(() -> this.createOrUpdate$$anonfun$1$$anonfun$1(uri));
                logger.message(() -> this.createOrUpdate$$anonfun$1$$anonfun$2(repoOrg, repoName, secretName));
                return false;
            }
            Response r = (Response)sttp.client3.package$.MODULE$.basicRequest().put(uri).header("Authorization", new StringBuilder(6).append("token ").append(token.value()).toString()).header("Accept", "application/vnd.github.v3+json").body(requestBody).send(backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
            int n = r.code();
            if (201 == n) {
                logger.message(() -> this.createOrUpdate$$anonfun$1$$anonfun$3(secretName));
                return true;
            }
            if (204 == n) {
                logger.message(() -> this.createOrUpdate$$anonfun$1$$anonfun$4(secretName));
                return false;
            }
            int code = n;
            return BoxesRunTime.unboxToBoolean((Object)EitherCps$.MODULE$.value(evidence$2, (Either)package$.MODULE$.Left().apply((Object)new GitHubApiError(new StringBuilder(62).append("Unexpected status code ").append(code).append(" in response when creating secret ").append(secretName).append(" in ").append(repoOrg).append("/").append(repoName).toString()))));
        });
    }

    @Override
    public void runCommand(SecretCreateOptions options, RemainingArgs args, Logger logger) {
        GitHubApi.PublicKey publicKey;
        Seq secrets = (Seq)args.all().map((Function1 & Serializable)input -> this.parseSecretKv((String)input));
        ScalaCliSttpBackend backend = ScalaCliSttpBackend$.MODULE$.httpURLConnection(logger);
        Option option = options.publicKey().filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.trim())));
        if (option instanceof Some) {
            String path = (String)((Some)option).value();
            byte[] content = read.bytes$.MODULE$.apply((ReadablePath)Path$.MODULE$.apply((Object)path, os.package$.MODULE$.pwd(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$));
            publicKey = (GitHubApi.PublicKey)com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray(content, com.github.plokhotnyuk.jsoniter_scala.core.package$.MODULE$.readFromArray$default$2(), GitHubApi$.MODULE$.publicKeyCodec());
        } else if (None$.MODULE$.equals(option)) {
            publicKey = (GitHubApi.PublicKey)this.EitherBuildExceptionOps((Either)this.publicKey(options.shared().repoOrg(), options.shared().repoName(), ConfigUtil$.MODULE$.toConfig(options.shared().token().get()), backend, logger)).orExit(logger);
        } else {
            throw new MatchError((Object)option);
        }
        GitHubApi.PublicKey pubKey = publicKey;
        FileCache<Function1> cache = options.coursier().coursierCache(logger.coursierLogger(""));
        ArchiveCache archiveCache = ArchiveCache$.MODULE$.apply(ArchiveCache$.MODULE$.apply$default$1()).withCache(cache);
        LibSodiumJni$.MODULE$.init((Cache<Function1>)cache, (ArchiveCache<Function1>)archiveCache, logger);
        secrets.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Secret secretValue = (Secret)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Secret secretValue = (Secret)tuple2._2();
                logger.debug(() -> this.runCommand$$anonfun$2$$anonfun$1(name));
                return BoxesRunTime.unboxToBoolean(this.EitherBuildExceptionOps((Either)this.createOrUpdate(options.shared().repoOrg(), options.shared().repoName(), ConfigUtil$.MODULE$.toConfig(options.shared().token().get()), name, (Secret<String>)secretValue, pubKey, options.dummy(), options.printRequest(), backend, logger)).orExit(logger));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final String publicKey$$anonfun$1$$anonfun$1(String publicKeyRespBody$1) {
        return new StringBuilder(12).append("Public key: ").append(publicKeyRespBody$1).toString();
    }

    private final String createOrUpdate$$anonfun$1$$anonfun$1(Uri uri$1) {
        return new StringBuilder(42).append("Dummy mode - would have sent a request to ").append(uri$1).toString();
    }

    private final String createOrUpdate$$anonfun$1$$anonfun$2(String repoOrg$3, String repoName$3, String secretName$2) {
        return new StringBuilder(39).append("Dummy mode - NOT uploading secret ").append(secretName$2).append(" to ").append(repoOrg$3).append("/").append(repoName$3).toString();
    }

    private final String createOrUpdate$$anonfun$1$$anonfun$3(String secretName$3) {
        return new StringBuilder(10).append("  created ").append(secretName$3).toString();
    }

    private final String createOrUpdate$$anonfun$1$$anonfun$4(String secretName$4) {
        return new StringBuilder(10).append("  updated ").append(secretName$4).toString();
    }

    private final String runCommand$$anonfun$2$$anonfun$1(String name$1) {
        return new StringBuilder(13).append("Secret name: ").append(name$1).toString();
    }
}

