/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.metabrowse;

import caseapp.core.RemainingArgs;
import dependency.CovariantSet;
import dependency.CovariantSet$;
import dependency.DependencyLike;
import dependency.DependencyLike$;
import dependency.ModuleLike;
import dependency.ModuleLike$;
import dependency.NameAttributes;
import dependency.NoAttributes$;
import java.io.File;
import java.io.Serializable;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.isFile$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.Build;
import scala.build.Build$;
import scala.build.BuildThreads;
import scala.build.BuildThreads$;
import scala.build.Builds;
import scala.build.Logger;
import scala.build.Positioned$;
import scala.build.compiler.ScalaCompilerMaker;
import scala.build.input.Inputs;
import scala.build.internal.Constants$;
import scala.build.internal.ExternalBinary;
import scala.build.internal.ExternalBinaryParams;
import scala.build.internal.ExternalBinaryParams$;
import scala.build.internal.FetchExternalBinary$;
import scala.build.internal.Runner$;
import scala.build.options.BuildOptions;
import scala.build.options.ClassPathOptions;
import scala.build.options.InternalDependenciesOptions;
import scala.build.options.InternalOptions;
import scala.build.options.JavaOptions;
import scala.build.options.JmhOptions;
import scala.build.options.PostBuildOptions;
import scala.build.options.ScalaJsOptions;
import scala.build.options.ScalaNativeOptions;
import scala.build.options.ScalaOptions;
import scala.build.options.ScriptOptions;
import scala.build.options.ShadowingSeq;
import scala.build.options.TestOptions;
import scala.cli.CurrentParams$;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.WatchUtil$;
import scala.cli.commands.metabrowse.MetabrowseOptions;
import scala.cli.commands.metabrowse.MetabrowseOptions$;
import scala.cli.commands.package0.Package$;
import scala.cli.commands.shared.SharedOptions;
import scala.cli.config.ConfigDb;
import scala.cli.config.Key;
import scala.cli.config.Keys$;
import scala.cli.packaging.Library$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Properties$;

public final class Metabrowse$
extends ScalaCommand<MetabrowseOptions> {
    public static final Metabrowse$ MODULE$ = new Metabrowse$();

    private Metabrowse$() {
        super(MetabrowseOptions$.MODULE$.parser(), MetabrowseOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Metabrowse$.class);
    }

    public boolean hidden() {
        return true;
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.RESTRICTED$.MODULE$;
    }

    public String group() {
        return "Miscellaneous";
    }

    public List<List<String>> names() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"browse"})), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metabrowse"}))}));
    }

    @Override
    public Option<SharedOptions> sharedOptions(MetabrowseOptions options) {
        return Some$.MODULE$.apply((Object)options.shared());
    }

    private Tuple2<String, Object> metabrowseBinaryUrl(String scalaVersion, MetabrowseOptions options) {
        String osArchSuffix0 = (String)options.osArchSuffix().map((Function1 & Serializable)_$1 -> _$1.trim()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).getOrElse(this::$anonfun$3);
        String metabrowseTag0 = (String)options.metabrowseTag().getOrElse(this::$anonfun$4);
        String metabrowseGithubOrgName0 = (String)options.metabrowseGithubOrgName().getOrElse(this::$anonfun$5);
        String metabrowseExtension0 = Properties$.MODULE$.isWin() ? ".zip" : ".gz";
        String url = new java.lang.StringBuilder(51).append("https://github.com/").append(metabrowseGithubOrgName0).append("/releases/download/").append(metabrowseTag0).append("/metabrowse-").append(scalaVersion).append("-").append(osArchSuffix0).append(metabrowseExtension0).toString();
        return Tuple2$.MODULE$.apply((Object)url, (Object)BoxesRunTime.boxToBoolean((!metabrowseTag0.startsWith("v") ? 1 : 0) != 0));
    }

    @Override
    public Option<BuildOptions> buildOptions(MetabrowseOptions options) {
        BuildOptions baseOptions = (BuildOptions)this.EitherBuildExceptionOps((Either)options.shared().buildOptions(options.shared().buildOptions$default$1(), options.shared().buildOptions$default$2(), options.shared().buildOptions$default$3())).orExit(options.shared().logger());
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq seq = baseOptions.classPathOptions().copy$default$1();
        Seq seq2 = baseOptions.classPathOptions().copy$default$2();
        Seq seq3 = baseOptions.classPathOptions().copy$default$3();
        Seq seq4 = baseOptions.classPathOptions().copy$default$4();
        ShadowingSeq shadowingSeq = baseOptions.classPathOptions().copy$default$6();
        Seq seq5 = baseOptions.classPathOptions().copy$default$7();
        Seq seq6 = baseOptions.classPathOptions().copy$default$8();
        ClassPathOptions classPathOptions = baseOptions.classPathOptions().copy(seq, seq2, seq3, seq4, (Option)some, shadowingSeq, seq5, seq6);
        Option option = baseOptions.javaOptions().jvmIdOpt().orElse(this::$anonfun$6);
        Option option2 = baseOptions.javaOptions().copy$default$1();
        Option option3 = baseOptions.javaOptions().copy$default$3();
        Option option4 = baseOptions.javaOptions().copy$default$4();
        Option option5 = baseOptions.javaOptions().copy$default$5();
        ShadowingSeq shadowingSeq2 = baseOptions.javaOptions().copy$default$6();
        Seq seq7 = baseOptions.javaOptions().copy$default$7();
        Seq seq8 = baseOptions.javaOptions().copy$default$8();
        Seq seq9 = baseOptions.javaOptions().copy$default$9();
        JavaOptions javaOptions = baseOptions.javaOptions().copy(option2, option, option3, option4, option5, shadowingSeq2, seq7, seq8, seq9);
        ScalaOptions scalaOptions = baseOptions.copy$default$1();
        ScalaJsOptions scalaJsOptions = baseOptions.copy$default$2();
        ScalaNativeOptions scalaNativeOptions = baseOptions.copy$default$3();
        InternalDependenciesOptions internalDependenciesOptions = baseOptions.copy$default$4();
        JmhOptions jmhOptions = baseOptions.copy$default$6();
        ScriptOptions scriptOptions = baseOptions.copy$default$8();
        InternalOptions internalOptions = baseOptions.copy$default$9();
        Option option6 = baseOptions.copy$default$10();
        TestOptions testOptions = baseOptions.copy$default$11();
        PostBuildOptions postBuildOptions = baseOptions.copy$default$12();
        return Some$.MODULE$.apply((Object)baseOptions.copy(scalaOptions, scalaJsOptions, scalaNativeOptions, internalDependenciesOptions, javaOptions, jmhOptions, classPathOptions, scriptOptions, internalOptions, option6, testOptions, postBuildOptions));
    }

    @Override
    public void runCommand(MetabrowseOptions options, RemainingArgs args, Logger logger) {
        BuildOptions initialBuildOptions = this.buildOptionsOrExit(options);
        Inputs inputs = (Inputs)this.EitherBuildExceptionOps((Either)options.shared().inputs((Seq<String>)args.all(), options.shared().inputs$default$2())).orExit(logger);
        CurrentParams$.MODULE$.workspaceOpt_$eq((Option<Path>)Some$.MODULE$.apply((Object)inputs.workspace()));
        BuildThreads threads = BuildThreads$.MODULE$.create();
        ScalaCompilerMaker compilerMaker = (ScalaCompilerMaker)this.EitherBuildExceptionOps((Either)options.shared().compilerMaker(threads, options.shared().compilerMaker$default$2())).orExit(logger);
        ConfigDb configDb = (ConfigDb)this.EitherBuildExceptionOps((Either)options.shared().configDb()).orExit(logger);
        Option actionableDiagnostics = options.shared().logging().verbosityOptions().actions().orElse(() -> this.$anonfun$7(configDb));
        Builds builds = (Builds)this.EitherBuildExceptionOps(Build$.MODULE$.build(inputs, initialBuildOptions, compilerMaker, (Option)None$.MODULE$, logger, false, false, (Option)None$.MODULE$, actionableDiagnostics)).orExit(logger);
        Build build = builds.main();
        if (build instanceof Build.Failed) {
            System.err.println("Build failed");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (!(build instanceof Build.Successful)) {
            throw new MatchError((Object)build);
        }
        Build.Successful s = (Build.Successful)build;
        Build.Successful successfulBuild = s;
        Library$.MODULE$.withLibraryJar(successfulBuild, Library$.MODULE$.withLibraryJar$default$2(), Library$.MODULE$.withLibraryJar$default$3(), (JProcedure1 & Serializable)jar -> Package$.MODULE$.withSourceJar(successfulBuild, System.currentTimeMillis(), Package$.MODULE$.withSourceJar$default$3(), (JProcedure1 & Serializable)sourceJar -> this.runServer(options, logger, successfulBuild, (Path)jar, (Path)sourceJar)));
    }

    public void runServer(MetabrowseOptions options, Logger logger, Build.Successful successfulBuild, Path jar, Path sourceJar) {
        Nil$ nil$;
        Seq command = (Seq)options.metabrowseLauncher().filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3))).map((Function1 & Serializable)_$4 -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{_$4}))).getOrElse(() -> this.$anonfun$10(options, logger, successfulBuild));
        logger.debug(() -> this.runServer$$anonfun$1(command));
        if (BoxesRunTime.unboxToBoolean((Object)options.addRtJar().getOrElse(this::$anonfun$16))) {
            Path rtJarLocation = ((Path)successfulBuild.options().javaHomeLocation().value()).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("jre")).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("lib")).$div((PathChunk)PathChunk$.MODULE$.StringPathChunk("rt.jar"));
            Option rtJarOpt = Some$.MODULE$.apply((Object)rtJarLocation).filter((Function1)isFile$.MODULE$);
            if (rtJarOpt.isEmpty() && options.shared().logging().verbosity() >= 0) {
                System.err.println(new java.lang.StringBuilder(24).append("Warning: could not find ").append(rtJarLocation).toString());
            }
            nil$ = Option$.MODULE$.option2Iterable(rtJarOpt).toSeq();
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ extraJars = nil$;
        List classPath = ((IterableOnceOps)successfulBuild.artifacts().classPath().$plus$plus((IterableOnce)extraJars)).toList().$colon$colon((Object)jar);
        List sources = successfulBuild.artifacts().sourcePath().toList().$colon$colon((Object)sourceJar);
        logger.debug(() -> this.runServer$$anonfun$2(classPath));
        logger.debug(() -> this.runServer$$anonfun$3(sources));
        String message = WatchUtil$.MODULE$.waitMessage("Metabrowse server running at http://{HOST}:{PORT}");
        Seq command0 = (Seq)command.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--class-path", classPath.map((Function1 & Serializable)_$8 -> _$8.toString()).mkString(File.pathSeparator), "--source-path", sources.map((Function1 & Serializable)_$9 -> _$9.toString()).mkString(File.pathSeparator), "--host", options.host(), "--port", BoxesRunTime.boxToInteger((int)options.port()).toString(), "--dialect", (String)options.metabrowseDialect().map((Function1 & Serializable)_$10 -> _$10.trim()).filter((Function1 & Serializable)_$11 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$11))).getOrElse(() -> this.$anonfun$23(successfulBuild)), "--message", message})));
        Runner$.MODULE$.maybeExec("metabrowse", command0, logger, Runner$.MODULE$.maybeExec$default$4(), Runner$.MODULE$.maybeExec$default$5());
    }

    private final String $anonfun$3() {
        return FetchExternalBinary$.MODULE$.platformSuffix(false);
    }

    private final String $anonfun$4() {
        return "latest";
    }

    private final String $anonfun$5() {
        return "alexarchambault/metabrowse";
    }

    private final Option $anonfun$6() {
        return Some$.MODULE$.apply((Object)Positioned$.MODULE$.none((Object)"8"));
    }

    private final Option $anonfun$7$$anonfun$1() {
        return None$.MODULE$;
    }

    private final Option $anonfun$7(ConfigDb configDb$1) {
        return (Option)configDb$1.get((Key)Keys$.MODULE$.actions()).getOrElse(this::$anonfun$7$$anonfun$1);
    }

    private final String $anonfun$12() {
        return Constants$.MODULE$.defaultScalaVersion();
    }

    private final String $anonfun$14() {
        return "2.4.4";
    }

    private final Seq $anonfun$10(MetabrowseOptions options$3, Logger logger$3, Build.Successful successfulBuild$3) {
        String sv = (String)successfulBuild$3.scalaParams().map((Function1 & Serializable)_$5 -> _$5.scalaVersion()).getOrElse(this::$anonfun$12);
        Tuple2<String, Object> tuple2 = this.metabrowseBinaryUrl(sv, options$3);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String url = (String)tuple2._1();
        boolean changing = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)url, (Object)BoxesRunTime.boxToBoolean((boolean)changing));
        String url2 = (String)tuple22._1();
        boolean changing2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        ExternalBinaryParams params = ExternalBinaryParams$.MODULE$.apply(url2, changing2, "metabrowse", (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DependencyLike[]{DependencyLike$.MODULE$.apply(ModuleLike$.MODULE$.apply("org.scalameta", "metabrowse-server_2.13", (NameAttributes)NoAttributes$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), new java.lang.StringBuilder(0).append(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{options$3.metabrowseTag().map((Function1 & Serializable)_$6 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$6), "v")).getOrElse(this::$anonfun$14)}).apply(0).toString()).toString(), (CovariantSet)CovariantSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ModuleLike[0])), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])))})), "metabrowse.server.cli.MetabrowseServerCli", ExternalBinaryParams$.MODULE$.$lessinit$greater$default$6(), ExternalBinaryParams$.MODULE$.$lessinit$greater$default$7());
        Either res = FetchExternalBinary$.MODULE$.fetch(params, successfulBuild$3.options().archiveCache(), logger$3, (Function0 & Serializable)() -> ((BuildOptions.JavaHomeInfo)successfulBuild$3.options().javaHome().value()).javaCommand());
        return ((ExternalBinary)this.EitherBuildExceptionOps(res).orExit(logger$3)).command();
    }

    private final String runServer$$anonfun$1(Seq command$1) {
        return new java.lang.StringBuilder(25).append("Using metabrowse command ").append(command$1).toString();
    }

    private final boolean $anonfun$16() {
        return true;
    }

    private final String runServer$$anonfun$2(List classPath$1) {
        String newLine = System.lineSeparator();
        StringBuilder b = new StringBuilder();
        b.append("Class path:");
        b.append(newLine);
        classPath$1.foreach((Function1 & Serializable)jar -> {
            b.append("  ");
            b.append(jar.toString());
            return b.append(newLine);
        });
        return b.result();
    }

    private final String runServer$$anonfun$3(List sources$1) {
        String newLine = System.lineSeparator();
        StringBuilder b = new StringBuilder();
        b.append("Source path:");
        b.append(newLine);
        sources$1.foreach((Function1 & Serializable)jar -> {
            b.append("  ");
            b.append(jar.toString());
            return b.append(newLine);
        });
        return b.result();
    }

    private final String $anonfun$18() {
        return Constants$.MODULE$.defaultScalaVersion();
    }

    private final String defaultDialect$1(Build.Successful successfulBuild$5) {
        String sv = (String)successfulBuild$5.scalaParams().map((Function1 & Serializable)_$7 -> _$7.scalaVersion()).getOrElse(this::$anonfun$18);
        if (sv.startsWith("2.12.")) {
            return "Scala212";
        }
        if (sv.startsWith("2.13.")) {
            return "Scala213";
        }
        return "Scala3";
    }

    private final String $anonfun$23(Build.Successful successfulBuild$6) {
        return this.defaultDialect$1(successfulBuild$6);
    }
}

