/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.doctor;

import caseapp.core.RemainingArgs;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.build.Logger;
import scala.build.internal.Constants$;
import scala.cli.ScalaCli$;
import scala.cli.commands.CommandUtils$;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.doctor.DoctorOptions;
import scala.cli.commands.doctor.DoctorOptions$;
import scala.cli.commands.update.Update$;
import scala.cli.internal.ProcUtil$;
import scala.cli.signing.shared.Secret;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;

public final class Doctor$
extends ScalaCommand<DoctorOptions> {
    public static final Doctor$ MODULE$ = new Doctor$();

    private Doctor$() {
        super(DoctorOptions$.MODULE$.parser(), DoctorOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Doctor$.class);
    }

    public String group() {
        return "Doctor";
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.IMPLEMENTATION$.MODULE$;
    }

    @Override
    public void runCommand(DoctorOptions options, RemainingArgs args, Logger logger) {
        this.checkIsVersionOutdated((Option<Secret<String>>)options.ghToken().map((Function1 & Serializable)_$1 -> _$1.get()));
        this.checkBloopStatus();
        this.checkDuplicatesOnPath();
        this.checkNativeDependencies();
        this.checkJSDependencies();
        this.checkAccessToMavneOrGithub();
        this.checkIsNativeOrJvm();
        Predef$.MODULE$.println((Object)"");
    }

    private void checkIsVersionOutdated(Option<Secret<String>> ghToken) {
        String currentVersion = Constants$.MODULE$.version();
        String newestScalaCliVersion = Update$.MODULE$.newestScalaCliVersion(ghToken);
        boolean isOutdated = CommandUtils$.MODULE$.isOutOfDateVersion(newestScalaCliVersion, currentVersion);
        if (isOutdated) {
            Predef$.MODULE$.println((Object)new StringBuilder(64).append("Your ").append(this.baseRunnerName()).append(" version is out of date. your version: ").append(currentVersion).append(". please update to: ").append(newestScalaCliVersion).toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(28).append("Your ").append(this.baseRunnerName()).append(" version (").append(currentVersion).append(") is current.").toString());
    }

    private void checkBloopStatus() {
    }

    private void checkDuplicatesOnPath() {
        List<String> scalaCliPaths = ProcUtil$.MODULE$.findApplicationPathsOnPATH(ScalaCli$.MODULE$.progName());
        if (scalaCliPaths.size() > 1) {
            Predef$.MODULE$.println((Object)new StringBuilder(84).append(this.baseRunnerName()).append(" would not be able to update itself since it is installed in multiple directories: ").append(scalaCliPaths.mkString(", ")).append(".").toString());
            return;
        }
        if (Update$.MODULE$.isScalaCLIInstalledByInstallationScript()) {
            Predef$.MODULE$.println((Object)new StringBuilder(76).append(this.baseRunnerName()).append(" could update itself since it is correctly installed in only one location: ").append(scalaCliPaths.mkString()).append(".").toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(95).append(this.baseRunnerName()).append(" can be updated by your package manager since it is correctly installed in only one location: ").append(scalaCliPaths.mkString()).append(".").toString());
    }

    private void checkNativeDependencies() {
    }

    private void checkJSDependencies() {
    }

    private void checkAccessToMavneOrGithub() {
    }

    private void checkIsNativeOrJvm() {
        String string = System.getProperty("org.graalvm.nativeimage.kind");
        String string2 = "executable";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.println((Object)new StringBuilder(30).append("Your ").append(this.baseRunnerName()).append(" is a native application.").toString());
            return;
        }
        String jvmVersion = System.getProperty("java.vm.name");
        String javaVendorVersion = System.getProperty("java.vendor.version");
        Predef$.MODULE$.println((Object)new StringBuilder(47).append("Your ").append(this.baseRunnerName()).append(" is using the java launcher with JVM: ").append(jvmVersion).append(" (").append(javaVendorVersion).append(").").toString());
    }
}

