/*
 * Decompiled with CFR 0.152.
 */
package scala.cli.commands.dependencyupdate;

import caseapp.core.RemainingArgs;
import geny.Writable$;
import java.io.Serializable;
import os.Path;
import os.ReadablePath;
import os.Source;
import os.Source$;
import os.read$;
import os.write;
import pprint.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.CrossSources;
import scala.build.CrossSources$;
import scala.build.Logger;
import scala.build.Position;
import scala.build.ScopedSources;
import scala.build.Sources;
import scala.build.Sources$;
import scala.build.actionable.ActionableDependencyHandler$;
import scala.build.actionable.ActionableDiagnostic;
import scala.build.input.Inputs;
import scala.build.internal.CodeWrapper;
import scala.build.internal.CustomCodeWrapper$;
import scala.build.options.BuildOptions;
import scala.build.options.Scope;
import scala.cli.commands.ScalaCommand;
import scala.cli.commands.SpecificationLevel;
import scala.cli.commands.dependencyupdate.DependencyUpdateOptions;
import scala.cli.commands.dependencyupdate.DependencyUpdateOptions$;
import scala.cli.commands.shared.SharedOptions;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class DependencyUpdate$
extends ScalaCommand<DependencyUpdateOptions> {
    public static final DependencyUpdate$ MODULE$ = new DependencyUpdate$();

    private DependencyUpdate$() {
        super(DependencyUpdateOptions$.MODULE$.parser(), DependencyUpdateOptions$.MODULE$.help());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DependencyUpdate$.class);
    }

    public String group() {
        return "Main";
    }

    @Override
    public SpecificationLevel scalaSpecificationLevel() {
        this.SpecificationLevel();
        return SpecificationLevel.RESTRICTED$.MODULE$;
    }

    @Override
    public Option<SharedOptions> sharedOptions(DependencyUpdateOptions options) {
        return Some$.MODULE$.apply((Object)options.shared());
    }

    @Override
    public void runCommand(DependencyUpdateOptions options, RemainingArgs args, Logger logger) {
        int verbosity = options.shared().logging().verbosity();
        BuildOptions buildOptions = this.buildOptionsOrExit(options);
        Inputs inputs = (Inputs)this.EitherBuildExceptionOps((Either)options.shared().inputs((Seq<String>)args.all(), options.shared().inputs$default$2())).orExit(logger);
        Tuple2 tuple2 = (Tuple2)this.EitherBuildExceptionOps(CrossSources$.MODULE$.forInputs(inputs, Sources$.MODULE$.defaultPreprocessors((CodeWrapper)buildOptions.scriptOptions().codeWrapper().getOrElse(this::$anonfun$1), buildOptions.archiveCache(), buildOptions.internal().javaClassNameVersionOpt(), (Function0 & Serializable)() -> ((BuildOptions.JavaHomeInfo)buildOptions.javaHome().value()).javaCommand()), logger, CrossSources$.MODULE$.forInputs$default$4())).orExit(logger);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CrossSources crossSources = (CrossSources)tuple2._1();
        CrossSources crossSources2 = crossSources;
        ScopedSources scopedSources = (ScopedSources)this.EitherBuildExceptionOps(crossSources2.scopedSources(buildOptions)).orExit(logger);
        Seq actionableMainUpdateDiagnostics = this.generateActionableUpdateDiagnostic$1(logger, verbosity, buildOptions, crossSources2, scopedSources, (Scope)Scope.Main$.MODULE$);
        Seq actionableTestUpdateDiagnostics = this.generateActionableUpdateDiagnostic$1(logger, verbosity, buildOptions, crossSources2, scopedSources, (Scope)Scope.Test$.MODULE$);
        Seq actionableUpdateDiagnostics = (Seq)((SeqOps)actionableMainUpdateDiagnostics.$plus$plus((IterableOnce)actionableTestUpdateDiagnostics)).distinct();
        if (options.all()) {
            this.updateDependencies((Seq<ActionableDiagnostic.ActionableDependencyUpdateDiagnostic>)actionableUpdateDiagnostics, logger);
            return;
        }
        Predef$.MODULE$.println((Object)"Updates");
        actionableUpdateDiagnostics.foreach((Function1)(JProcedure1 & Serializable)update -> Predef$.MODULE$.println((Object)new StringBuilder(9).append("   * ").append(update.oldDependency().render()).append(" -> ").append(update.newVersion()).toString()));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(80).append("|To update all dependencies run:\n                  |    ").append(this.baseRunnerName()).append(" dependency-update --all").toString())));
    }

    private void updateDependencies(Seq<ActionableDiagnostic.ActionableDependencyUpdateDiagnostic> actionableUpdateDiagnostics, Logger logger) {
        Map groupedByFileDiagnostics = ((IterableOps)actionableUpdateDiagnostics.flatMap((Function1 & Serializable)diagnostic -> (IterableOnce)diagnostic.positions().collect((PartialFunction)new Serializable((ActionableDiagnostic.ActionableDependencyUpdateDiagnostic)diagnostic){
            private final ActionableDiagnostic.ActionableDependencyUpdateDiagnostic diagnostic$1;
            {
                this.diagnostic$1 = diagnostic$4;
            }

            public final boolean isDefinedAt(Position x) {
                Position position = x;
                if (position instanceof Position.File) {
                    Position.File file = (Position.File)position;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Position x, Function1 function1) {
                Position position = x;
                if (position instanceof Position.File) {
                    Position.File file = (Position.File)position;
                    Either either = (Either)Predef$.MODULE$.ArrowAssoc((Object)file.path());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)either, (Object)Tuple2$.MODULE$.apply((Object)file, (Object)this.diagnostic$1));
                }
                return function1.apply((Object)x);
            }
        }))).groupMap((Function1 & Serializable)_$1 -> (Either)_$1._1(), (Function1 & Serializable)_$2 -> (Tuple2)_$2._2());
        groupedByFileDiagnostics.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (either instanceof Right) {
                    Path file = (Path)((Right)either).value();
                    Seq diagnostics = seq;
                    Seq sortedByLine = (Seq)((SeqOps)diagnostics.sortBy((Function1 & Serializable)_$3 -> ((Position.File)_$3._1()).startPos()._1$mcI$sp(), (Ordering)Ordering.Int$.MODULE$)).reverse();
                    String appliedDiagnostics = this.updateDependencies(file, (Seq<Tuple2<Position.File, ActionableDiagnostic.ActionableDependencyUpdateDiagnostic>>)sortedByLine);
                    write.over$.MODULE$.apply(file, (Source)Source$.MODULE$.WritableSource((Object)appliedDiagnostics, (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write.over$.MODULE$.apply$default$3(), write.over$.MODULE$.apply$default$4(), write.over$.MODULE$.apply$default$5(), write.over$.MODULE$.apply$default$6());
                    diagnostics.foreach((Function1)(JProcedure1 & Serializable)diagnostic -> logger.message(() -> this.updateDependencies$$anonfun$1$$anonfun$2$$anonfun$1(diagnostic)));
                    return;
                }
                if (either instanceof Left) {
                    String file = (String)((Left)either).value();
                    Seq diagnostics = seq;
                    diagnostics.foreach((Function1)(JProcedure1 & Serializable)diagnostic -> logger.message(() -> this.updateDependencies$$anonfun$1$$anonfun$3$$anonfun$1(file, diagnostic)));
                    return;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String updateDependencies(Path file, Seq<Tuple2<Position.File, ActionableDiagnostic.ActionableDependencyUpdateDiagnostic>> diagnostics) {
        String fileContent = read$.MODULE$.apply((ReadablePath)file);
        int[] startIndicies = Position.Raw$.MODULE$.lineStartIndices(fileContent);
        return (String)diagnostics.foldLeft((Object)fileContent, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                String fileContent = (String)tuple2._1();
                if (tuple22 != null) {
                    Position.File file = (Position.File)tuple22._1();
                    ActionableDiagnostic.ActionableDependencyUpdateDiagnostic diagnostic = (ActionableDiagnostic.ActionableDependencyUpdateDiagnostic)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)file.startPos()._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)file.startPos()._2$mcI$sp()));
                    int line = tuple23._1$mcI$sp();
                    int column = tuple23._2$mcI$sp();
                    int startIndex = startIndicies[line] + column;
                    int endIndex = startIndex + diagnostic.oldDependency().render().length();
                    String newDependency = diagnostic.suggestion();
                    return new StringBuilder(0).append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(fileContent), 0, startIndex)).append(newDependency).append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(fileContent), endIndex)).toString();
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final CodeWrapper $anonfun$1() {
        return CustomCodeWrapper$.MODULE$;
    }

    private final Seq generateActionableUpdateDiagnostic$1(Logger logger$1, int verbosity$1, BuildOptions buildOptions$2, CrossSources crossSources$1, ScopedSources scopedSources$1, Scope scope) {
        Sources sources = scopedSources$1.sources(scope, crossSources$1.sharedOptions(buildOptions$2));
        if (verbosity$1 >= 3) {
            package$.MODULE$.err().log(Text$.MODULE$.apply((Object)sources, "sources"), package$.MODULE$.err().log$default$2(), package$.MODULE$.err().log$default$3(), package$.MODULE$.err().log$default$4(), package$.MODULE$.err().log$default$5(), package$.MODULE$.err().log$default$6(), package$.MODULE$.err().log$default$7(), Line$.MODULE$.apply(49), FileName$.MODULE$.apply("DependencyUpdate.scala"));
        }
        BuildOptions options = buildOptions$2.orElse(sources.buildOptions());
        return (Seq)this.EitherBuildExceptionOps(ActionableDependencyHandler$.MODULE$.createActionableDiagnostics(options)).orExit(logger$1);
    }

    private final String updateDependencies$$anonfun$1$$anonfun$2$$anonfun$1(Tuple2 diagnostic$2) {
        return new StringBuilder(23).append("Updated dependency to: ").append(((ActionableDiagnostic.ActionableDependencyUpdateDiagnostic)diagnostic$2._2()).suggestion()).toString();
    }

    private final String updateDependencies$$anonfun$1$$anonfun$3$$anonfun$1(String file$2, Tuple2 diagnostic$3) {
        return new StringBuilder(27).append("Warning: ").append(this.fullRunnerName()).append(" can't update ").append(((ActionableDiagnostic.ActionableDependencyUpdateDiagnostic)diagnostic$3._2()).suggestion()).append(" in ").append(file$2).toString();
    }
}

