/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlwriter;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.GroupingAttribute;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.OrderbyAttribute;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SetOperationRelation;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.exception.VerdictDBValueException;
import org.verdictdb.sqlsyntax.PostgresqlSyntax;
import org.verdictdb.sqlsyntax.SqlSyntax;

public class SelectQueryToSql {
    SqlSyntax syntax;
    Set<String> opTypeNotRequiringParentheses = Sets.newHashSet((Object[])new String[]{"sum", "avg", "count", "max", "min", "std", "sqrt", "is_not_null", "is_null", "rand", "floor"});

    public SelectQueryToSql(SqlSyntax syntax) {
        this.syntax = syntax;
    }

    public String toSql(AbstractRelation relation) throws VerdictDBException {
        if (!(relation instanceof SelectQuery)) {
            throw new VerdictDBTypeException("Unexpected type: " + relation.getClass().toString());
        }
        return this.selectQueryToSql((SelectQuery)relation);
    }

    String selectItemToSqlPart(SelectItem item) throws VerdictDBException {
        if (item instanceof AliasedColumn) {
            return this.aliasedColumnToSqlPart((AliasedColumn)item);
        }
        if (item instanceof UnnamedColumn) {
            return this.unnamedColumnToSqlPart((UnnamedColumn)item);
        }
        throw new VerdictDBTypeException("Unexpceted argument type: " + item.getClass().toString());
    }

    String aliasedColumnToSqlPart(AliasedColumn acolumn) throws VerdictDBException {
        String aliasName = acolumn.getAliasName();
        return this.unnamedColumnToSqlPart(acolumn.getColumn()) + " as " + this.quoteName(aliasName);
    }

    String groupingAttributeToSqlPart(GroupingAttribute column) throws VerdictDBException {
        if (column instanceof AsteriskColumn) {
            throw new VerdictDBTypeException("asterisk is not expected in the groupby clause.");
        }
        if (column instanceof AliasReference) {
            AliasReference aliasedColumn = (AliasReference)column;
            return aliasedColumn.getTableAlias() != null ? this.quoteName(aliasedColumn.getTableAlias()) + "." + this.quoteName(aliasedColumn.getAliasName()) : this.quoteName(aliasedColumn.getAliasName());
        }
        return this.unnamedColumnToSqlPart((UnnamedColumn)column);
    }

    String unnamedColumnToSqlPart(UnnamedColumn column) throws VerdictDBException {
        if (column instanceof BaseColumn) {
            BaseColumn base = (BaseColumn)column;
            if (base.getTableSourceAlias() == null) {
                return base.getColumnName();
            }
            if (base.getTableSourceAlias().equals("")) {
                return this.quoteName(base.getColumnName());
            }
            return base.getTableSourceAlias() + "." + this.quoteName(base.getColumnName());
        }
        if (column instanceof ConstantColumn) {
            return ((ConstantColumn)column).getValue().toString();
        }
        if (column instanceof AsteriskColumn) {
            return "*";
        }
        if (column instanceof ColumnOp) {
            ColumnOp columnOp = (ColumnOp)column;
            if (columnOp.getOpType().equals("avg")) {
                return "avg(" + this.unnamedColumnToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("sum")) {
                return "sum(" + this.unnamedColumnToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("count")) {
                if (columnOp.getOperands().isEmpty()) {
                    return "count(*)";
                }
                return "count(" + this.unnamedColumnToSqlPart(columnOp.getOperand(0)) + ")";
            }
            if (columnOp.getOpType().equals("stddev_pop")) {
                String stddevPopulationFunctionName = this.syntax.getStddevPopulationFunctionName();
                return String.format("%s(", stddevPopulationFunctionName) + this.unnamedColumnToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("sqrt")) {
                return "sqrt(" + this.unnamedColumnToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("add")) {
                return this.withParentheses(columnOp.getOperand(0)) + " + " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("subtract")) {
                return this.withParentheses(columnOp.getOperand(0)) + " - " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("multiply")) {
                return this.withParentheses(columnOp.getOperand(0)) + " * " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("divide")) {
                return this.withParentheses(columnOp.getOperand(0)) + " / " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("pow")) {
                return "pow(" + this.unnamedColumnToSqlPart(columnOp.getOperand(0)) + ", " + this.unnamedColumnToSqlPart(columnOp.getOperand(1)) + ")";
            }
            if (columnOp.getOpType().equals("equal")) {
                return this.withParentheses(columnOp.getOperand(0)) + " = " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("and")) {
                return this.withParentheses(columnOp.getOperand(0)) + " and " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("or")) {
                return this.withParentheses(columnOp.getOperand(0)) + " or " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("not")) {
                return "not " + this.withParentheses(columnOp.getOperand(0));
            }
            if (columnOp.getOpType().equals("casewhen")) {
                String sql = "case";
                for (int i = 0; i < columnOp.getOperands().size() - 1; i += 2) {
                    sql = sql + " when " + this.withParentheses(columnOp.getOperand(i)) + " then " + this.withParentheses(columnOp.getOperand(i + 1));
                }
                sql = sql + " else " + this.withParentheses(columnOp.getOperand(columnOp.getOperands().size() - 1)) + " end";
                return sql;
            }
            if (columnOp.getOpType().equals("notequal")) {
                return this.withParentheses(columnOp.getOperand(0)) + " <> " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("notand")) {
                return "not (" + this.withParentheses(columnOp.getOperand(0)) + " and " + this.withParentheses(columnOp.getOperand(1)) + ")";
            }
            if (columnOp.getOpType().equals("isnull")) {
                return "isnull(" + this.withParentheses(columnOp.getOperand(0)) + ")";
            }
            if (columnOp.getOpType().equals("is_null")) {
                return this.withParentheses(columnOp.getOperand(0)) + " is null";
            }
            if (columnOp.getOpType().equals("is_not_null")) {
                return this.withParentheses(columnOp.getOperand(0)) + " is not null";
            }
            if (columnOp.getOpType().equals("interval")) {
                return "interval " + this.withParentheses(columnOp.getOperand(0)) + " " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("date")) {
                return "date " + this.withParentheses(columnOp.getOperand());
            }
            if (columnOp.getOpType().equals("greater")) {
                return this.withParentheses(columnOp.getOperand(0)) + " > " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("less")) {
                return this.withParentheses(columnOp.getOperand(0)) + " < " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("greaterequal")) {
                return this.withParentheses(columnOp.getOperand(0)) + " >= " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("lessequal")) {
                return this.withParentheses(columnOp.getOperand(0)) + " <= " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("min")) {
                return "min(" + this.selectItemToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("max")) {
                return "max(" + this.selectItemToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("min")) {
                return "max(" + this.selectItemToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("floor")) {
                return "floor(" + this.selectItemToSqlPart(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("like")) {
                return this.withParentheses(columnOp.getOperand(0)) + " like " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("notlike")) {
                return this.withParentheses(columnOp.getOperand(0)) + " not like " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("rlike")) {
                return this.withParentheses(columnOp.getOperand(0)) + " rlike " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("notrlike")) {
                return this.withParentheses(columnOp.getOperand(0)) + " not rlike " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("exists")) {
                return "exists " + this.withParentheses(columnOp.getOperand());
            }
            if (columnOp.getOpType().equals("notexists")) {
                return "not exists " + this.withParentheses(columnOp.getOperand());
            }
            if (columnOp.getOpType().equals("between")) {
                return this.withParentheses(columnOp.getOperand(0)) + " between " + this.withParentheses(columnOp.getOperand(1)) + " and " + this.withParentheses(columnOp.getOperand(2));
            }
            if (columnOp.getOpType().equals("in")) {
                List<UnnamedColumn> columns = columnOp.getOperands();
                if (columns.size() == 2 && columns.get(1) instanceof SubqueryColumn) {
                    return this.withParentheses(columns.get(0)) + " in " + this.withParentheses(columns.get(1));
                }
                String temp = "";
                for (int i = 1; i < columns.size(); ++i) {
                    temp = i != columns.size() - 1 ? temp + this.withParentheses(columns.get(i)) + ", " : temp + this.withParentheses(columns.get(i));
                }
                return this.withParentheses(columns.get(0)) + " in (" + temp + ")";
            }
            if (columnOp.getOpType().equals("notin")) {
                List<UnnamedColumn> columns = columnOp.getOperands();
                if (columns.size() == 2 && columns.get(1) instanceof SubqueryColumn) {
                    return this.withParentheses(columns.get(0)) + " not in " + this.withParentheses(columns.get(1));
                }
                String temp = "";
                for (int i = 1; i < columns.size(); ++i) {
                    temp = i != columns.size() - 1 ? temp + this.withParentheses(columns.get(i)) + ", " : temp + this.withParentheses(columns.get(i));
                }
                return this.withParentheses(columns.get(0)) + " not in (" + temp + ")";
            }
            if (columnOp.getOpType().equals("countdistinct")) {
                return "count(distinct " + this.withParentheses(columnOp.getOperand()) + ")";
            }
            if (columnOp.getOpType().equals("substr")) {
                if (columnOp.getOperands().size() == 3) {
                    return "substr(" + this.withParentheses(columnOp.getOperand(0)) + ", " + this.withParentheses(columnOp.getOperand(1)) + ", " + this.withParentheses(columnOp.getOperand(2)) + ")";
                }
                return "substr(" + this.withParentheses(columnOp.getOperand(0)) + ", " + this.withParentheses(columnOp.getOperand(1)) + ")";
            }
            if (columnOp.getOpType().equals("rand")) {
                return this.syntax.randFunction();
            }
            if (columnOp.getOpType().equals("cast")) {
                return "cast(" + this.withParentheses(columnOp.getOperand(0)) + " as " + this.withParentheses(columnOp.getOperand(1)) + ")";
            }
            if (columnOp.getOpType().equals("extract")) {
                return "extract(" + this.withParentheses(columnOp.getOperand(0)) + " from " + this.withParentheses(columnOp.getOperand(1)) + ")";
            }
            if (columnOp.getOpType().equals("||") || columnOp.getOpType().equals("|") || columnOp.getOpType().equals("&") || columnOp.getOpType().equals("#") || columnOp.getOpType().equals(">>") || columnOp.getOpType().equals("<<")) {
                return this.withParentheses(columnOp.getOperand(0)) + " " + columnOp.getOpType() + " " + this.withParentheses(columnOp.getOperand(1));
            }
            if (columnOp.getOpType().equals("overlay")) {
                return "overlay(" + this.withParentheses(columnOp.getOperand(0)) + " placing " + this.withParentheses(columnOp.getOperand(1)) + " from " + this.withParentheses(columnOp.getOperand(2)) + ")";
            }
            if (columnOp.getOpType().equals("substring") && this.syntax instanceof PostgresqlSyntax) {
                String temp = "substring(" + this.withParentheses(columnOp.getOperand(0)) + " from " + this.withParentheses(columnOp.getOperand(1));
                if (columnOp.getOperands().size() == 2) {
                    return temp + ")";
                }
                return temp + " for " + this.withParentheses(columnOp.getOperand(2)) + ")";
            }
            if (columnOp.getOpType().equals("timestampwithoutparentheses")) {
                return "timestamp " + this.withParentheses(columnOp.getOperand(0));
            }
            if (columnOp.getOpType().equals("dateadd")) {
                return "dateadd(" + this.withParentheses(columnOp.getOperand(0)) + ", " + this.withParentheses(columnOp.getOperand(1)) + ", " + this.withParentheses(columnOp.getOperand(2)) + ")";
            }
            List<UnnamedColumn> columns = columnOp.getOperands();
            String temp = columnOp.getOpType() + "(";
            for (int i = 0; i < columns.size(); ++i) {
                temp = i != columns.size() - 1 ? temp + this.withParentheses(columns.get(i)) + ", " : temp + this.withParentheses(columns.get(i));
            }
            return temp + ")";
        }
        if (column instanceof SubqueryColumn) {
            return "(" + this.selectQueryToSql(((SubqueryColumn)column).getSubquery()) + ")";
        }
        if (column instanceof AliasReference) {
            return this.groupingAttributeToSqlPart(column);
        }
        throw new VerdictDBTypeException("Unexpceted argument type: " + column.getClass().toString());
    }

    String withParentheses(UnnamedColumn column) throws VerdictDBException {
        String sql = this.unnamedColumnToSqlPart(column);
        if (column instanceof ColumnOp && !this.opTypeNotRequiringParentheses.contains(((ColumnOp)column).getOpType())) {
            sql = "(" + sql + ")";
        }
        return sql;
    }

    String selectQueryToSql(SelectQuery sel) throws VerdictDBException {
        Optional<UnnamedColumn> filter;
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        List<SelectItem> columns = sel.getSelectList();
        boolean isFirstColumn = true;
        for (SelectItem a : columns) {
            if (isFirstColumn) {
                sql.append(" " + this.selectItemToSqlPart(a));
                isFirstColumn = false;
                continue;
            }
            sql.append(", " + this.selectItemToSqlPart(a));
        }
        List<AbstractRelation> rels = sel.getFromList();
        if (rels.size() > 0) {
            sql.append(" from");
            boolean isFirstRel = true;
            for (AbstractRelation r : rels) {
                if (isFirstRel) {
                    sql.append(" " + this.relationToSqlPart(r));
                    isFirstRel = false;
                    continue;
                }
                sql.append(", " + this.relationToSqlPart(r));
            }
        }
        if ((filter = sel.getFilter()).isPresent()) {
            sql.append(" where ");
            sql.append(this.unnamedColumnToSqlPart((UnnamedColumn)filter.get()));
        }
        List<GroupingAttribute> groupby = sel.getGroupby();
        boolean isFirstGroup = true;
        for (GroupingAttribute a : groupby) {
            if (isFirstGroup) {
                sql.append(" group by ");
                sql.append(this.groupingAttributeToSqlPart(a));
                isFirstGroup = false;
                continue;
            }
            sql.append(", " + this.groupingAttributeToSqlPart(a));
        }
        Optional<UnnamedColumn> having = sel.getHaving();
        if (having.isPresent()) {
            sql.append(" having ");
            sql.append(this.unnamedColumnToSqlPart((UnnamedColumn)having.get()));
        }
        List<OrderbyAttribute> orderby = sel.getOrderby();
        boolean isFirstOrderby = true;
        for (OrderbyAttribute a : orderby) {
            if (isFirstOrderby) {
                sql.append(" order by ");
                sql.append(this.groupingAttributeToSqlPart(a.getAttribute()));
                sql.append(" " + a.getOrder());
                isFirstOrderby = false;
                continue;
            }
            sql.append(", " + this.groupingAttributeToSqlPart(a.getAttribute()));
            sql.append(" " + a.getOrder());
        }
        Optional<UnnamedColumn> limit = sel.getLimit();
        if (limit.isPresent()) {
            sql.append(" limit " + this.unnamedColumnToSqlPart((UnnamedColumn)limit.get()));
        }
        return sql.toString();
    }

    String relationToSqlPart(AbstractRelation relation) throws VerdictDBException {
        StringBuilder sql = new StringBuilder();
        if (relation instanceof BaseTable) {
            BaseTable base = (BaseTable)relation;
            if (base.getSchemaName().isEmpty()) {
                sql.append(this.quoteName(base.getTableName()));
            } else {
                sql.append(this.quoteName(base.getSchemaName()) + "." + this.quoteName(base.getTableName()));
            }
            if (base.getAliasName().isPresent()) {
                sql.append(" as " + (String)base.getAliasName().get());
            }
            return sql.toString();
        }
        if (relation instanceof JoinTable) {
            sql.append(this.relationToSqlPart(((JoinTable)relation).getJoinList().get(0)));
            for (int i = 1; i < ((JoinTable)relation).getJoinList().size(); ++i) {
                if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.inner)) {
                    sql.append(" inner join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.outer)) {
                    sql.append(" outer join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.left)) {
                    sql.append(" left join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.leftouter)) {
                    sql.append(" left outer join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.right)) {
                    sql.append(" right join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.rightouter)) {
                    sql.append(" right outer join ");
                } else if (((JoinTable)relation).getJoinTypeList().get(i - 1).equals((Object)JoinTable.JoinType.cross)) {
                    sql.append(" cross join ");
                }
                sql.append(this.relationToSqlPart(((JoinTable)relation).getJoinList().get(i)));
                if (((JoinTable)relation).getCondition().get(i - 1) == null) continue;
                sql.append(" on " + this.withParentheses(((JoinTable)relation).getCondition().get(i - 1)));
            }
            if (((JoinTable)relation).getAliasName().isPresent()) {
                sql.append(" as " + ((JoinTable)relation).getAliasName().toString());
            }
            return sql.toString();
        }
        if (relation instanceof SetOperationRelation) {
            sql.append("(");
            sql.append(this.selectQueryToSql((SelectQuery)((SetOperationRelation)relation).getLeft()));
            sql.append(" ");
            sql.append(((SetOperationRelation)relation).getSetOpType());
            sql.append(" ");
            sql.append(this.selectQueryToSql((SelectQuery)((SetOperationRelation)relation).getRight()));
            sql.append(")");
            if (relation.getAliasName().isPresent()) {
                sql.append(" as " + (String)relation.getAliasName().get());
            }
            return sql.toString();
        }
        if (!(relation instanceof SelectQuery)) {
            throw new VerdictDBTypeException("Unexpected relation type: " + relation.getClass().toString());
        }
        SelectQuery sel = (SelectQuery)relation;
        Optional<String> aliasName = sel.getAliasName();
        if (!aliasName.isPresent()) {
            throw new VerdictDBValueException("An inner select query must be aliased.");
        }
        return "(" + this.selectQueryToSql(sel) + ") as " + (String)aliasName.get();
    }

    String quoteName(String name) {
        String quoteString = this.syntax.getQuoteString();
        if (name.startsWith(quoteString) && name.endsWith(quoteString)) {
            return name;
        }
        return quoteString + name + quoteString;
    }
}

