/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlwriter;

import org.verdictdb.core.querying.CreateSchemaQuery;
import org.verdictdb.core.sqlobject.CreateTableQuery;
import org.verdictdb.core.sqlobject.DropTableQuery;
import org.verdictdb.core.sqlobject.InsertValuesQuery;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SetOperationRelation;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.exception.VerdictDBValueException;
import org.verdictdb.sqlsyntax.SqlSyntax;
import org.verdictdb.sqlwriter.CreateSchemaToSql;
import org.verdictdb.sqlwriter.CreateTableToSql;
import org.verdictdb.sqlwriter.DropTableToSql;
import org.verdictdb.sqlwriter.InsertQueryToSql;
import org.verdictdb.sqlwriter.SelectQueryToSql;
import org.verdictdb.sqlwriter.SetOperationToSql;

public class QueryToSql {
    public static String convert(SqlSyntax syntax, SqlConvertible query) throws VerdictDBException {
        if (query == null) {
            throw new VerdictDBValueException("null value passed");
        }
        if (query instanceof SelectQuery) {
            SelectQueryToSql tosql = new SelectQueryToSql(syntax);
            return tosql.toSql((SelectQuery)query);
        }
        if (query instanceof CreateSchemaQuery) {
            CreateSchemaToSql tosql = new CreateSchemaToSql(syntax);
            return tosql.toSql((CreateSchemaQuery)query);
        }
        if (query instanceof CreateTableQuery) {
            CreateTableToSql tosql = new CreateTableToSql(syntax);
            return tosql.toSql((CreateTableQuery)query);
        }
        if (query instanceof DropTableQuery) {
            DropTableToSql tosql = new DropTableToSql(syntax);
            return tosql.toSql((DropTableQuery)query);
        }
        if (query instanceof InsertValuesQuery) {
            InsertQueryToSql tosql = new InsertQueryToSql(syntax);
            return tosql.toSql((InsertValuesQuery)query);
        }
        if (query instanceof SetOperationRelation) {
            SetOperationToSql tosql = new SetOperationToSql(syntax);
            return tosql.toSql((SetOperationRelation)((Object)query));
        }
        throw new VerdictDBTypeException(query);
    }
}

