/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlwriter;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.CreateScrambledTableQuery;
import org.verdictdb.core.sqlobject.CreateTableAsSelectQuery;
import org.verdictdb.core.sqlobject.CreateTableDefinitionQuery;
import org.verdictdb.core.sqlobject.CreateTableQuery;
import org.verdictdb.core.sqlobject.DropTableQuery;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBTypeException;
import org.verdictdb.sqlsyntax.HiveSyntax;
import org.verdictdb.sqlsyntax.ImpalaSyntax;
import org.verdictdb.sqlsyntax.PostgresqlSyntax;
import org.verdictdb.sqlsyntax.SparkSyntax;
import org.verdictdb.sqlsyntax.SqlSyntax;
import org.verdictdb.sqlwriter.QueryToSql;
import org.verdictdb.sqlwriter.SelectQueryToSql;

public class CreateTableToSql {
    protected SqlSyntax syntax;

    public CreateTableToSql(SqlSyntax syntax) {
        this.syntax = syntax;
    }

    public String toSql(CreateTableQuery query) throws VerdictDBException {
        String sql;
        if (query instanceof CreateTableAsSelectQuery) {
            sql = this.createAsSelectQueryToSql((CreateTableAsSelectQuery)query);
        } else if (query instanceof CreateTableDefinitionQuery) {
            sql = this.createTableToSql((CreateTableDefinitionQuery)query);
        } else if (query instanceof CreateScrambledTableQuery) {
            sql = this.syntax instanceof PostgresqlSyntax ? this.createPostgresqlPartitionTableToSql((CreateScrambledTableQuery)query) : (this.syntax instanceof ImpalaSyntax ? this.createImpalaPartitionTableToSql((CreateScrambledTableQuery)query) : this.createAsSelectQueryToSql(new CreateTableAsSelectQuery((CreateScrambledTableQuery)query)));
        } else {
            throw new VerdictDBTypeException(query);
        }
        return sql;
    }

    private String createImpalaPartitionTableToSql(CreateScrambledTableQuery query) throws VerdictDBException {
        if (!(this.syntax instanceof ImpalaSyntax)) {
            throw new VerdictDBException("Target database must be Impala.");
        }
        StringBuilder sql = new StringBuilder();
        String schemaName = query.getSchemaName();
        String tableName = query.getTableName();
        SelectQuery select = query.getSelect();
        int randomNum = ThreadLocalRandom.current().nextInt(0, 10000);
        String tempTableName = "verdictdb_scrambling_temp_" + randomNum;
        CreateTableAsSelectQuery tempCreate = new CreateTableAsSelectQuery(schemaName, tempTableName, select);
        sql.append(QueryToSql.convert(this.syntax, tempCreate));
        sql.append(";");
        String aliasName = "t";
        SelectQuery selectAllFromTemp = SelectQuery.create(new AsteriskColumn(), (AbstractRelation)new BaseTable(schemaName, tempTableName, aliasName));
        CreateTableAsSelectQuery insert = new CreateTableAsSelectQuery(schemaName, tableName, selectAllFromTemp);
        for (String col : query.getPartitionColumns()) {
            insert.addPartitionColumn(col);
        }
        sql.append(QueryToSql.convert(this.syntax, insert));
        sql.append(";");
        DropTableQuery drop = new DropTableQuery(schemaName, tempTableName);
        sql.append(QueryToSql.convert(this.syntax, drop));
        sql.append(";");
        return sql.toString();
    }

    private String createPostgresqlPartitionTableToSql(CreateScrambledTableQuery query) throws VerdictDBException {
        if (!(this.syntax instanceof PostgresqlSyntax)) {
            throw new VerdictDBException("Target database must be Postgres.");
        }
        if (query.getPartitionColumns().size() != 1) {
            throw new VerdictDBException("Scrambled tables must have a single partition column in Postgres.");
        }
        StringBuilder sql = new StringBuilder();
        int blockCount = query.getBlockCount();
        String schemaName = query.getSchemaName();
        String tableName = query.getTableName();
        SelectQuery select = query.getSelect();
        sql.append("create table ");
        if (query.isIfNotExists()) {
            sql.append("if not exists ");
        }
        sql.append(this.quoteName(schemaName));
        sql.append(".");
        sql.append(this.quoteName(tableName));
        sql.append(" (");
        ArrayList<String> columns = new ArrayList<String>();
        for (Pair<String, String> col : query.getColumnMeta()) {
            columns.add((String)col.getLeft() + " " + (String)col.getRight());
        }
        sql.append(Joiner.on((String)",").join(columns));
        sql.append(String.format(",%s integer,%s integer", query.getTierColumnName(), query.getBlockColumnName()));
        sql.append(")");
        sql.append(" ");
        sql.append(this.syntax.getPartitionByInCreateTable());
        sql.append(" (");
        String partitionColumn = query.getPartitionColumns().get(0);
        sql.append(this.quoteName(partitionColumn));
        sql.append(")");
        sql.append("; ");
        for (int blockNum = 0; blockNum < blockCount; ++blockNum) {
            sql.append("create table ");
            if (query.isIfNotExists()) {
                sql.append("if not exists ");
            }
            sql.append(this.quoteName(schemaName));
            sql.append(".");
            sql.append(this.quoteName(String.format("%s_vpart%05d", tableName, blockNum)));
            sql.append(String.format(" partition of %s.%s for values in (%d); ", this.quoteName(schemaName), this.quoteName(tableName), blockNum));
        }
        sql.append("insert into ");
        sql.append(this.quoteName(schemaName));
        sql.append(".");
        sql.append(this.quoteName(tableName));
        sql.append(" ");
        SelectQueryToSql selectWriter = new SelectQueryToSql(this.syntax);
        String selectSql = selectWriter.toSql(select);
        sql.append(selectSql);
        return sql.toString();
    }

    String createAsSelectQueryToSql(CreateTableAsSelectQuery query) throws VerdictDBException {
        StringBuilder sql = new StringBuilder();
        String schemaName = query.getSchemaName();
        String tableName = query.getTableName();
        SelectQuery select = query.getSelect();
        sql.append("create table ");
        if (query.isIfNotExists()) {
            sql.append("if not exists ");
        }
        sql.append(this.quoteName(schemaName));
        sql.append(".");
        sql.append(this.quoteName(tableName));
        if (this.syntax.doesSupportTablePartitioning() && query.getPartitionColumns().size() > 0) {
            sql.append(" ");
            sql.append(this.syntax.getPartitionByInCreateTable());
            sql.append(" (");
            List<String> partitionColumns = query.getPartitionColumns();
            boolean isFirstColumn = true;
            for (String col : partitionColumns) {
                if (isFirstColumn) {
                    sql.append(this.quoteName(col));
                    isFirstColumn = false;
                    continue;
                }
                sql.append(", " + this.quoteName(col));
            }
            sql.append(")");
        } else if (this.syntax instanceof SparkSyntax || this.syntax instanceof HiveSyntax) {
            sql.append(" using parquet");
        }
        if (this.syntax.isAsRequiredBeforeSelectInCreateTable()) {
            sql.append(" as ");
        } else {
            sql.append(" ");
        }
        SelectQueryToSql selectWriter = new SelectQueryToSql(this.syntax);
        String selectSql = selectWriter.toSql(select);
        sql.append(selectSql);
        return sql.toString();
    }

    String createTableToSql(CreateTableDefinitionQuery query) {
        StringBuilder sql = new StringBuilder();
        String schemaName = query.getSchemaName();
        String tableName = query.getTableName();
        List<Pair<String, String>> columnAndTypes = query.getColumnNameAndTypes();
        sql.append("create table ");
        if (query.isIfNotExists()) {
            sql.append("if not exists ");
        }
        sql.append(this.quoteName(schemaName));
        sql.append(".");
        sql.append(this.quoteName(tableName));
        sql.append(" (");
        boolean isFirst = true;
        for (Pair<String, String> columnAndType : columnAndTypes) {
            String column = (String)columnAndType.getLeft();
            String type = (String)columnAndType.getRight();
            type = this.syntax.substituteTypeName(type);
            if (!isFirst) {
                sql.append(", ");
            }
            sql.append(String.format("%s %s", this.quoteName(column), type));
            isFirst = false;
        }
        sql.append(")");
        return sql.toString();
    }

    String quoteName(String name) {
        String quoteString = this.syntax.getQuoteString();
        return quoteString + name + quoteString;
    }
}

