/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlsyntax;

import java.util.Map;
import java.util.TreeMap;
import org.verdictdb.sqlsyntax.H2Syntax;
import org.verdictdb.sqlsyntax.HiveSyntax;
import org.verdictdb.sqlsyntax.ImpalaSyntax;
import org.verdictdb.sqlsyntax.MysqlSyntax;
import org.verdictdb.sqlsyntax.PostgresqlSyntax;
import org.verdictdb.sqlsyntax.RedshiftSyntax;
import org.verdictdb.sqlsyntax.SparkSyntax;
import org.verdictdb.sqlsyntax.SqlSyntax;
import org.verdictdb.sqlsyntax.SqliteSyntax;

public class SqlSyntaxList {
    static Map<String, SqlSyntax> nameToSyntax = new TreeMap<String, SqlSyntax>(String.CASE_INSENSITIVE_ORDER);

    public static SqlSyntax getSyntaxFor(String dbName) {
        return nameToSyntax.get(dbName);
    }

    public static SqlSyntax getSyntaxFromConnectionString(String connectionString) {
        String dbName = connectionString.split(":")[1];
        SqlSyntax syntax = SqlSyntaxList.getSyntaxFor(dbName);
        return syntax;
    }

    static {
        nameToSyntax.put("Impala", new ImpalaSyntax());
        nameToSyntax.put("H2", new H2Syntax());
        nameToSyntax.put("Hive", new HiveSyntax());
        nameToSyntax.put("MySQL", new MysqlSyntax());
        nameToSyntax.put("PostgreSQL", new PostgresqlSyntax());
        nameToSyntax.put("Redshift", new RedshiftSyntax());
        nameToSyntax.put("Spark", new SparkSyntax());
        nameToSyntax.put("SQLite", new SqliteSyntax());
    }
}

