/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlsyntax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.verdictdb.sqlsyntax.SqlSyntax;

public class RedshiftSyntax
extends SqlSyntax {
    @Override
    public boolean doesSupportTablePartitioning() {
        return true;
    }

    @Override
    public void dropTable(String schema, String tablename) {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj.getClass() == this.getClass();
    }

    @Override
    public Collection<String> getCandidateJDBCDriverClassNames() {
        ArrayList candidates = Lists.newArrayList((Object[])new String[]{"com.amazon.redshift.jdbc42.Driver", "com.amazon.redshift.jdbc41.Driver"});
        return candidates;
    }

    @Override
    public int getColumnNameColumnIndex() {
        return 0;
    }

    @Override
    public String getColumnsCommand(String schema, String table) {
        return "select \"column\", \"type\" from PG_TABLE_DEF where tablename = '" + table + "' and schemaname = '" + schema + "'";
    }

    @Override
    public int getColumnTypeColumnIndex() {
        return 1;
    }

    @Override
    public String getFallbackDefaultSchema() {
        return "public";
    }

    @Override
    public String getPartitionByInCreateTable() {
        return "COMPOUND SORTKEY";
    }

    @Override
    public String getPartitionCommand(String schema, String table) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("SET search_path to '%s'; ", schema));
        sql.append(String.format("SELECT \"column\", \"type\" FROM PG_TABLE_DEF WHERE \"schemaname\" = '%s' and \"tablename\" = '%s' and \"sortkey\" > 0 ORDER BY \"sortkey\";", schema, table));
        return sql.toString();
    }

    @Override
    public String getQuoteString() {
        return "\"";
    }

    @Override
    public String getSchemaCommand() {
        return "select schema_name from information_schema.schemata";
    }

    @Override
    public int getSchemaNameColumnIndex() {
        return 0;
    }

    @Override
    public String getTableCommand(String schema) {
        return "SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "'";
    }

    @Override
    public int getTableNameColumnIndex() {
        return 0;
    }

    @Override
    public boolean isAsRequiredBeforeSelectInCreateTable() {
        return true;
    }

    @Override
    public String randFunction() {
        return "random()";
    }
}

