/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlsyntax;

import org.verdictdb.sqlsyntax.SqlSyntax;

public class MysqlSyntax
extends SqlSyntax {
    @Override
    public boolean doesSupportTablePartitioning() {
        return true;
    }

    @Override
    public void dropTable(String schema, String tablename) {
    }

    @Override
    public int getColumnNameColumnIndex() {
        return 0;
    }

    @Override
    public String getFallbackDefaultSchema() {
        return "test";
    }

    @Override
    public String getColumnsCommand(String schema, String table) {
        return "show columns in " + this.quoteName(table) + " in " + this.quoteName(schema);
    }

    @Override
    public int getColumnTypeColumnIndex() {
        return 1;
    }

    @Override
    public String getPartitionByInCreateTable() {
        return "partition by key";
    }

    @Override
    public String getPartitionCommand(String schema, String table) {
        return "SELECT DISTINCT REPLACE(PARTITION_EXPRESSION, '`', '') FROM INFORMATION_SCHEMA.PARTITIONS WHERE TABLE_NAME='" + table + "' AND TABLE_SCHEMA='" + schema + "'";
    }

    @Override
    public String getQuoteString() {
        return "`";
    }

    @Override
    public String getSchemaCommand() {
        return "show schemas";
    }

    @Override
    public int getSchemaNameColumnIndex() {
        return 0;
    }

    @Override
    public String getTableCommand(String schema) {
        return "show tables in " + this.quoteName(schema);
    }

    @Override
    public int getTableNameColumnIndex() {
        return 0;
    }

    @Override
    public String randFunction() {
        return "rand()";
    }

    @Override
    public boolean isAsRequiredBeforeSelectInCreateTable() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj.getClass() == this.getClass();
    }
}

