/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlsyntax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.verdictdb.sqlsyntax.SqlSyntax;

public class ImpalaSyntax
extends SqlSyntax {
    @Override
    public boolean doesSupportTablePartitioning() {
        return true;
    }

    @Override
    public void dropTable(String schema, String tablename) {
    }

    @Override
    public Collection<String> getCandidateJDBCDriverClassNames() {
        ArrayList candidates = Lists.newArrayList((Object[])new String[]{"com.cloudera.impala.jdbc41.Driver"});
        return candidates;
    }

    @Override
    public int getColumnNameColumnIndex() {
        return 0;
    }

    @Override
    public String getFallbackDefaultSchema() {
        return "default";
    }

    @Override
    public String getColumnsCommand(String schema, String table) {
        return "DESCRIBE " + this.quoteName(schema) + "." + this.quoteName(table);
    }

    @Override
    public int getColumnTypeColumnIndex() {
        return 1;
    }

    @Override
    public String getPartitionByInCreateTable() {
        return "partitioned by";
    }

    @Override
    public String getPartitionCommand(String schema, String table) {
        return "SHOW PARTITIONS " + this.quoteName(schema) + "." + this.quoteName(table);
    }

    @Override
    public String getQuoteString() {
        return "`";
    }

    @Override
    public String getSchemaCommand() {
        return "SHOW DATABASES";
    }

    @Override
    public int getSchemaNameColumnIndex() {
        return 0;
    }

    @Override
    public String getTableCommand(String schema) {
        return "SHOW TABLES IN " + this.quoteName(schema);
    }

    @Override
    public int getTableNameColumnIndex() {
        return 0;
    }

    @Override
    public String randFunction() {
        int randomNum = ThreadLocalRandom.current().nextInt(0, 1000000000);
        return String.format("rand(unix_timestamp()+%d)", randomNum);
    }

    @Override
    public boolean isAsRequiredBeforeSelectInCreateTable() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj.getClass() == this.getClass();
    }
}

