/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlreader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.MetaDataProvider;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasReference;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.GroupingAttribute;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.OrderbyAttribute;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBDbmsException;

public class RelationStandardizer {
    private MetaDataProvider meta;
    private static long itemID = 1L;
    private static long duplicateIdentifer = 1L;
    private static String verdictTableAliasPrefix = "vt";
    private HashMap<String, String> colNameAndTableAlias = new HashMap();
    private HashMap<Pair<String, String>, String> tableInfoAndAlias = new HashMap();
    private HashMap<String, String> colNameAndColAlias = new HashMap();
    private HashMap<ColumnOp, String> columnOpAliasMap = new HashMap();
    private HashMap<Pair<String, String>, String> duplicateColNameAndColAlias = new HashMap();
    private HashMap<String, String> colNameAndTempColAlias = new HashMap();
    private HashMap<String, String> oldTableAliasMap = new HashMap();

    public RelationStandardizer(MetaDataProvider meta) {
        this.meta = meta;
    }

    private BaseColumn replaceBaseColumn(BaseColumn col) {
        if (col.getTableSourceAlias().equals("")) {
            if (!col.getSchemaName().equals("")) {
                col.setTableSourceAlias(this.tableInfoAndAlias.get(new ImmutablePair((Object)col.getSchemaName(), (Object)col.getTableName())));
            } else {
                col.setTableSourceAlias(this.colNameAndTableAlias.get(col.getColumnName()));
            }
        }
        if (this.colNameAndTempColAlias.containsKey(col.getColumnName())) {
            col.setColumnName(this.colNameAndTempColAlias.get(col.getColumnName()));
        }
        if (this.oldTableAliasMap.containsKey(col.getTableSourceAlias())) {
            col.setTableSourceAlias(this.oldTableAliasMap.get(col.getTableSourceAlias()));
        }
        if (this.tableInfoAndAlias.containsValue(col.getTableSourceAlias())) {
            for (Map.Entry<Pair<String, String>, String> entry : this.tableInfoAndAlias.entrySet()) {
                if (!entry.getValue().equals(col.getTableSourceAlias())) continue;
                col.setSchemaName((String)entry.getKey().getLeft());
                col.setTableName((String)entry.getKey().getRight());
                break;
            }
        }
        if (col.getSchemaName().equals("")) {
            col.setSchemaName(this.meta.getDefaultSchema());
            if (this.tableInfoAndAlias.containsKey(new ImmutablePair((Object)col.getSchemaName(), (Object)col.getTableSourceAlias()))) {
                col.setTableSourceAlias(this.tableInfoAndAlias.get(new ImmutablePair((Object)col.getSchemaName(), (Object)col.getTableSourceAlias())));
            }
        }
        return col;
    }

    private List<SelectItem> replaceSelectList(List<SelectItem> selectItemList) throws VerdictDBDbmsException {
        ArrayList<SelectItem> newSelectItemList = new ArrayList<SelectItem>();
        for (SelectItem sel : selectItemList) {
            if (!(sel instanceof AliasedColumn) && !(sel instanceof AsteriskColumn)) {
                if (sel instanceof BaseColumn) {
                    if (!this.colNameAndColAlias.containsValue(((BaseColumn)(sel = this.replaceBaseColumn((BaseColumn)sel))).getColumnName())) {
                        this.colNameAndColAlias.put(((BaseColumn)sel).getColumnName(), ((BaseColumn)sel).getColumnName());
                        newSelectItemList.add(new AliasedColumn((BaseColumn)sel, ((BaseColumn)sel).getColumnName()));
                        continue;
                    }
                    this.duplicateColNameAndColAlias.put((Pair<String, String>)new ImmutablePair((Object)((BaseColumn)sel).getTableSourceAlias(), (Object)((BaseColumn)sel).getColumnName()), ((BaseColumn)sel).getColumnName() + duplicateIdentifer);
                    newSelectItemList.add(new AliasedColumn((BaseColumn)sel, ((BaseColumn)sel).getColumnName() + duplicateIdentifer++));
                    continue;
                }
                if (!(sel instanceof ColumnOp)) continue;
                if (((ColumnOp)(sel = this.replaceFilter((ColumnOp)sel))).getOpType().equals("count")) {
                    this.columnOpAliasMap.put((ColumnOp)sel, "c" + itemID);
                    newSelectItemList.add(new AliasedColumn((ColumnOp)sel, "c" + itemID++));
                    continue;
                }
                if (((ColumnOp)sel).getOpType().equals("sum")) {
                    this.columnOpAliasMap.put((ColumnOp)sel, "s" + itemID);
                    newSelectItemList.add(new AliasedColumn((ColumnOp)sel, "s" + itemID++));
                    continue;
                }
                if (((ColumnOp)sel).getOpType().equals("avg")) {
                    this.columnOpAliasMap.put((ColumnOp)sel, "a" + itemID);
                    newSelectItemList.add(new AliasedColumn((ColumnOp)sel, "a" + itemID++));
                    continue;
                }
                if (((ColumnOp)sel).getOpType().equals("countdistinct")) {
                    this.columnOpAliasMap.put((ColumnOp)sel, "cd" + itemID);
                    newSelectItemList.add(new AliasedColumn((ColumnOp)sel, "cd" + itemID++));
                    continue;
                }
                this.columnOpAliasMap.put((ColumnOp)sel, "vc" + itemID);
                newSelectItemList.add(new AliasedColumn((ColumnOp)sel, "vc" + itemID++));
                continue;
            }
            if (sel instanceof AliasedColumn) {
                ((AliasedColumn)sel).setColumn(this.replaceFilter(((AliasedColumn)sel).getColumn()));
            }
            newSelectItemList.add(sel);
            if (sel instanceof AliasedColumn && ((AliasedColumn)sel).getColumn() instanceof BaseColumn) {
                this.colNameAndColAlias.put(((BaseColumn)((AliasedColumn)sel).getColumn()).getColumnName(), ((AliasedColumn)sel).getAliasName());
                continue;
            }
            if (!(sel instanceof AliasedColumn) || !(((AliasedColumn)sel).getColumn() instanceof ColumnOp)) continue;
            this.columnOpAliasMap.put((ColumnOp)((AliasedColumn)sel).getColumn(), ((AliasedColumn)sel).getAliasName());
        }
        return newSelectItemList;
    }

    private UnnamedColumn replaceFilter(UnnamedColumn condition) throws VerdictDBDbmsException {
        Vector<UnnamedColumn> searchList = new Vector<UnnamedColumn>();
        searchList.add(condition);
        while (!searchList.isEmpty()) {
            UnnamedColumn cond = (UnnamedColumn)searchList.get(0);
            searchList.remove(0);
            if (cond instanceof BaseColumn) {
                cond = this.replaceBaseColumn((BaseColumn)cond);
                continue;
            }
            if (cond instanceof ColumnOp) {
                for (UnnamedColumn col : ((ColumnOp)cond).getOperands()) {
                    searchList.add(col);
                }
                continue;
            }
            if (!(cond instanceof SubqueryColumn)) continue;
            RelationStandardizer g = new RelationStandardizer(this.meta);
            g.oldTableAliasMap.putAll(this.oldTableAliasMap);
            g.setColNameAndColAlias(this.colNameAndColAlias);
            g.setColumnOpAliasMap(this.columnOpAliasMap);
            g.setColNameAndTableAlias(this.colNameAndTableAlias);
            g.setTableInfoAndAlias(this.tableInfoAndAlias);
            SelectQuery newSubquery = g.standardize(((SubqueryColumn)cond).getSubquery());
            ((SubqueryColumn)cond).setSubquery(newSubquery);
        }
        return condition;
    }

    private List<GroupingAttribute> replaceGroupby(List<SelectItem> selectItems, List<GroupingAttribute> groupingAttributeList) throws VerdictDBDbmsException {
        return this.replaceGroupby(selectItems, groupingAttributeList, false);
    }

    private List<GroupingAttribute> replaceGroupby(List<SelectItem> selectItems, List<GroupingAttribute> groupingAttributeList, boolean isforOrderBy) throws VerdictDBDbmsException {
        ArrayList<GroupingAttribute> newGroupby = new ArrayList<GroupingAttribute>();
        for (GroupingAttribute g : groupingAttributeList) {
            if (g instanceof BaseColumn) {
                if (((BaseColumn)g).getTableSourceAlias() != null) {
                    String columnName;
                    String tableSource = ((BaseColumn)g).getTableSourceAlias();
                    if (this.duplicateColNameAndColAlias.containsKey(new ImmutablePair((Object)tableSource, (Object)(columnName = ((BaseColumn)g).getColumnName())))) {
                        newGroupby.add(new AliasReference(tableSource, this.duplicateColNameAndColAlias.get(new ImmutablePair((Object)tableSource, (Object)columnName))));
                        continue;
                    }
                    if (this.colNameAndColAlias.containsKey(columnName)) {
                        newGroupby.add(new AliasReference(this.colNameAndColAlias.get(columnName)));
                        continue;
                    }
                    newGroupby.add(new AliasReference(((BaseColumn)g).getColumnName()));
                    continue;
                }
                if (this.colNameAndColAlias.containsKey(((BaseColumn)g).getColumnName())) {
                    newGroupby.add(new AliasReference(this.colNameAndColAlias.get(((BaseColumn)g).getColumnName())));
                    continue;
                }
                newGroupby.add(new AliasReference(((BaseColumn)g).getColumnName()));
                continue;
            }
            if (g instanceof ColumnOp) {
                ColumnOp replaced = (ColumnOp)this.replaceFilter((ColumnOp)g);
                if (this.columnOpAliasMap.containsKey(replaced)) {
                    newGroupby.add(new AliasReference(this.columnOpAliasMap.get(replaced)));
                    continue;
                }
                newGroupby.add(replaced);
                continue;
            }
            if (g instanceof ConstantColumn) {
                String value = (String)((ConstantColumn)g).getValue();
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    newGroupby.add(new AliasReference(value));
                    continue;
                }
                int index = Integer.valueOf(value);
                AliasedColumn col = (AliasedColumn)selectItems.get(index - 1);
                UnnamedColumn column = col.getColumn();
                if (column instanceof BaseColumn && !isforOrderBy) {
                    BaseColumn baseCol = (BaseColumn)column;
                    newGroupby.add(new AliasReference(baseCol.getTableSourceAlias(), baseCol.getColumnName()));
                    continue;
                }
                newGroupby.add(new AliasReference(col.getAliasName()));
                continue;
            }
            newGroupby.add(g);
        }
        return newGroupby;
    }

    private List<OrderbyAttribute> replaceOrderby(List<SelectItem> selectItems, List<OrderbyAttribute> orderbyAttributesList) throws VerdictDBDbmsException {
        ArrayList<OrderbyAttribute> newOrderby = new ArrayList<OrderbyAttribute>();
        for (OrderbyAttribute o : orderbyAttributesList) {
            newOrderby.add(new OrderbyAttribute(this.replaceGroupby(selectItems, Arrays.asList(o.getAttribute()), true).get(0), o.getOrder()));
        }
        return newOrderby;
    }

    private Pair<List<String>, AbstractRelation> setupTableSource(AbstractRelation table) throws VerdictDBDbmsException {
        ArrayList<Object> colName;
        if (!(table instanceof JoinTable)) {
            if (table.getAliasName().isPresent()) {
                String alias = (String)table.getAliasName().get();
                alias = alias.replace("`", "");
                alias = alias.replace("\"", "");
                this.oldTableAliasMap.put(alias, verdictTableAliasPrefix + itemID);
            }
            table.setAliasName(verdictTableAliasPrefix + itemID++);
        }
        if (table instanceof BaseTable) {
            colName = new ArrayList<Object>();
            if (((BaseTable)table).getSchemaName() == null) {
                ((BaseTable)table).setSchemaName(this.meta.getDefaultSchema());
            }
            List<Pair<String, String>> cols = this.meta.getColumns(((BaseTable)table).getSchemaName(), ((BaseTable)table).getTableName());
            for (Pair<String, String> c : cols) {
                this.colNameAndTableAlias.put((String)c.getKey(), (String)table.getAliasName().get());
                colName.add(c.getKey());
            }
            this.tableInfoAndAlias.put((Pair<String, String>)new ImmutablePair((Object)((BaseTable)table).getSchemaName(), (Object)((BaseTable)table).getTableName()), (String)table.getAliasName().get());
            return new ImmutablePair(colName, (Object)table);
        }
        if (table instanceof JoinTable) {
            ArrayList joinColName = new ArrayList();
            for (int i = 0; i < ((JoinTable)table).getJoinList().size(); ++i) {
                Pair<List<String>, AbstractRelation> result = this.setupTableSource(((JoinTable)table).getJoinList().get(i));
                ((JoinTable)table).getJoinList().set(i, (AbstractRelation)result.getValue());
                joinColName.addAll((Collection)result.getKey());
                if (i == 0) continue;
                ((JoinTable)table).getCondition().set(i - 1, this.replaceFilter(((JoinTable)table).getCondition().get(i - 1)));
            }
            return new ImmutablePair(joinColName, (Object)table);
        }
        if (table instanceof SelectQuery) {
            colName = new ArrayList();
            RelationStandardizer g = new RelationStandardizer(this.meta);
            g.oldTableAliasMap.putAll(this.oldTableAliasMap);
            g.setTableInfoAndAlias(this.tableInfoAndAlias);
            g.setColNameAndTableAlias(this.colNameAndTableAlias);
            g.setColNameAndColAlias(this.colNameAndColAlias);
            String aliasName = (String)table.getAliasName().get();
            table = g.standardize((SelectQuery)table);
            table.setAliasName(aliasName);
            for (SelectItem sel : ((SelectQuery)table).getSelectList()) {
                if (sel instanceof AliasedColumn) {
                    if (((AliasedColumn)sel).getColumn() instanceof BaseColumn && ((AliasedColumn)sel).getAliasName().matches("^vc[0-9]+$")) {
                        this.colNameAndTableAlias.put(((BaseColumn)((AliasedColumn)sel).getColumn()).getColumnName(), (String)table.getAliasName().get());
                        this.colNameAndTempColAlias.put(((BaseColumn)((AliasedColumn)sel).getColumn()).getColumnName(), ((AliasedColumn)sel).getAliasName());
                    } else {
                        this.colNameAndTableAlias.put(((AliasedColumn)sel).getAliasName(), (String)table.getAliasName().get());
                    }
                    colName.add(((AliasedColumn)sel).getAliasName());
                    continue;
                }
                if (!(sel instanceof AsteriskColumn)) continue;
                HashMap<String, String> subqueryColumnList = g.getColNameAndTableAlias();
                for (String col : subqueryColumnList.keySet()) {
                    this.colNameAndTableAlias.put(col, (String)table.getAliasName().get());
                    colName.add(col);
                }
            }
            return new ImmutablePair(colName, (Object)table);
        }
        return null;
    }

    private List<AbstractRelation> setupTableSources(SelectQuery relationToAlias) throws VerdictDBDbmsException {
        List<AbstractRelation> fromList = relationToAlias.getFromList();
        for (int i = 0; i < fromList.size(); ++i) {
            fromList.set(i, (AbstractRelation)this.setupTableSource(fromList.get(i)).getValue());
        }
        return fromList;
    }

    public SelectQuery standardize(SelectQuery relationToAlias) throws VerdictDBDbmsException {
        List<AbstractRelation> fromList = this.setupTableSources(relationToAlias);
        List<SelectItem> selectItemList = this.replaceSelectList(relationToAlias.getSelectList());
        SelectQuery AliasedRelation = SelectQuery.create(selectItemList, fromList);
        if (relationToAlias.getFilter().isPresent()) {
            UnnamedColumn where = this.replaceFilter((UnnamedColumn)relationToAlias.getFilter().get());
            AliasedRelation.addFilterByAnd(where);
        }
        if (relationToAlias.getGroupby().size() != 0) {
            List<GroupingAttribute> groupby = this.replaceGroupby(selectItemList, relationToAlias.getGroupby());
            AliasedRelation.addGroupby(groupby);
        }
        if (relationToAlias.getHaving().isPresent()) {
            UnnamedColumn having = this.replaceFilter((UnnamedColumn)relationToAlias.getHaving().get());
            if (having instanceof ColumnOp) {
                ArrayList<ColumnOp> checklist = new ArrayList<ColumnOp>();
                checklist.add((ColumnOp)having);
                while (!checklist.isEmpty()) {
                    ColumnOp columnOp = (ColumnOp)checklist.get(0);
                    checklist.remove(0);
                    for (UnnamedColumn operand : columnOp.getOperands()) {
                        if (!(operand instanceof ColumnOp)) continue;
                        if (this.columnOpAliasMap.containsKey(operand)) {
                            columnOp.setOperand(columnOp.getOperands().indexOf(operand), new AliasReference(this.columnOpAliasMap.get(operand)));
                            continue;
                        }
                        checklist.add((ColumnOp)operand);
                    }
                }
            }
            AliasedRelation.addHavingByAnd(having);
        }
        if (relationToAlias.getOrderby().size() != 0) {
            List<OrderbyAttribute> orderby = this.replaceOrderby(selectItemList, relationToAlias.getOrderby());
            AliasedRelation.addOrderby(orderby);
        }
        if (relationToAlias.getLimit().isPresent()) {
            AliasedRelation.addLimit((UnnamedColumn)relationToAlias.getLimit().get());
        }
        return AliasedRelation;
    }

    public HashMap<String, String> getColNameAndColAlias() {
        return this.colNameAndColAlias;
    }

    public HashMap<Pair<String, String>, String> getTableInfoAndAlias() {
        return this.tableInfoAndAlias;
    }

    public HashMap<String, String> getColNameAndTableAlias() {
        return this.colNameAndTableAlias;
    }

    public void setColNameAndTableAlias(HashMap<String, String> colNameAndTableAlias) {
        for (String key : colNameAndTableAlias.keySet()) {
            this.colNameAndTableAlias.put(key, colNameAndTableAlias.get(key));
        }
    }

    public void setTableInfoAndAlias(HashMap<Pair<String, String>, String> tableInfoAndAlias) {
        for (Pair<String, String> key : tableInfoAndAlias.keySet()) {
            this.tableInfoAndAlias.put(key, tableInfoAndAlias.get(key));
        }
    }

    public void setColNameAndColAlias(HashMap<String, String> colNameAndColAlias) {
        for (String key : colNameAndColAlias.keySet()) {
            this.colNameAndColAlias.put(key, colNameAndColAlias.get(key));
        }
    }

    public void setColumnOpAliasMap(HashMap<ColumnOp, String> columnOpAliasMap) {
        this.columnOpAliasMap = columnOpAliasMap;
    }

    public HashMap<ColumnOp, String> getColumnOpAliasMap() {
        return this.columnOpAliasMap;
    }

    public static void resetItemID() {
        itemID = 1L;
    }
}

