/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlreader;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.GroupingAttribute;
import org.verdictdb.core.sqlobject.JoinTable;
import org.verdictdb.core.sqlobject.OrderbyAttribute;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.parser.VerdictSQLParser;
import org.verdictdb.parser.VerdictSQLParserBaseVisitor;
import org.verdictdb.sqlreader.CondGen;
import org.verdictdb.sqlreader.ExpressionGen;

public class RelationGen
extends VerdictSQLParserBaseVisitor<AbstractRelation> {
    private List<SelectItem> selectElems = new ArrayList<SelectItem>();
    private UnnamedColumn joinCond = null;
    private JoinTable.JoinType joinType = null;

    @Override
    public SelectQuery visitSelect_statement(VerdictSQLParser.Select_statementContext ctx) {
        SelectQuery sel = (SelectQuery)this.visit((ParseTree)ctx.query_expression());
        if (ctx.order_by_clause() != null) {
            for (VerdictSQLParser.Order_by_expressionContext o : ctx.order_by_clause().order_by_expression()) {
                ExpressionGen g = new ExpressionGen();
                UnnamedColumn c = (UnnamedColumn)g.visit((ParseTree)o.expression());
                OrderbyAttribute orderbyCol = new OrderbyAttribute(c, o.DESC() == null ? "asc" : "desc");
                sel.addOrderby(orderbyCol);
            }
        }
        if (ctx.limit_clause() != null) {
            sel.addLimit(ConstantColumn.valueOf(ctx.limit_clause().number().getText()));
        }
        return sel;
    }

    @Override
    public AbstractRelation visitQuery_expression(VerdictSQLParser.Query_expressionContext ctx) {
        AbstractRelation r = null;
        if (ctx.query_specification() != null) {
            r = (AbstractRelation)this.visit((ParseTree)ctx.query_specification());
        } else if (ctx.query_expression() != null) {
            r = (AbstractRelation)this.visit((ParseTree)ctx.query_expression());
        }
        return r;
    }

    @Override
    public AbstractRelation visitQuery_specification(VerdictSQLParser.Query_specificationContext ctx) {
        List elems;
        ArrayList<AbstractRelation> tableSources = new ArrayList<AbstractRelation>();
        for (VerdictSQLParser.Table_sourceContext s : ctx.table_source()) {
            AbstractRelation r1 = (AbstractRelation)this.visit((ParseTree)s);
            tableSources.add(r1);
        }
        UnnamedColumn where = null;
        if (ctx.WHERE() != null) {
            CondGen g = new CondGen();
            where = (UnnamedColumn)g.visit((ParseTree)ctx.where);
        }
        class SelectListExtractor
        extends VerdictSQLParserBaseVisitor<List<SelectItem>> {
            SelectListExtractor() {
            }

            @Override
            public List<SelectItem> visitSelect_list(VerdictSQLParser.Select_listContext ctx) {
                ArrayList<SelectItem> selectList = new ArrayList<SelectItem>();
                for (VerdictSQLParser.Select_list_elemContext a : ctx.select_list_elem()) {
                    VerdictSQLParserBaseVisitor<SelectItem> v = new VerdictSQLParserBaseVisitor<SelectItem>(){

                        @Override
                        public SelectItem visitSelect_list_elem(VerdictSQLParser.Select_list_elemContext ctx) {
                            SelectItem elem = null;
                            if (ctx.STAR() != null) {
                                elem = ctx.table_name() == null ? new AsteriskColumn() : new AsteriskColumn(RelationGen.this.stripQuote(ctx.table_name().getText()));
                            } else {
                                ExpressionGen g = new ExpressionGen();
                                elem = (SelectItem)g.visit((ParseTree)ctx.expression());
                                if (elem instanceof BaseColumn) {
                                    if (ctx.column_alias() != null) {
                                        elem = new AliasedColumn((BaseColumn)elem, ctx.column_alias().getText());
                                    }
                                } else if (elem instanceof ColumnOp) {
                                    if (ctx.column_alias() != null) {
                                        elem = new AliasedColumn((ColumnOp)elem, ctx.column_alias().getText());
                                    }
                                } else if (elem instanceof ConstantColumn && ctx.column_alias() != null) {
                                    elem = new AliasedColumn((ConstantColumn)elem, ctx.column_alias().getText());
                                }
                            }
                            return elem;
                        }
                    };
                    SelectItem e = (SelectItem)v.visit((ParseTree)a);
                    selectList.add(e);
                }
                return selectList;
            }
        }
        SelectListExtractor select = new SelectListExtractor();
        this.selectElems = elems = (List)select.visit((ParseTree)ctx.select_list());
        SelectQuery sel = SelectQuery.create(this.selectElems, tableSources);
        if (where != null) {
            sel.addFilterByAnd(where);
        }
        if (ctx.GROUP() != null) {
            ArrayList<GroupingAttribute> groupby = new ArrayList<GroupingAttribute>();
            for (VerdictSQLParser.Group_by_itemContext g : ctx.group_by_item()) {
                UnnamedColumn c;
                UnnamedColumn gexpr = null;
                ExpressionGen expressionGen = new ExpressionGen();
                gexpr = c = (UnnamedColumn)expressionGen.visit((ParseTree)g);
                boolean aliasFound = false;
                if (aliasFound) continue;
                groupby.add(gexpr);
            }
            if (!groupby.isEmpty()) {
                sel.addGroupby(groupby);
            }
        }
        UnnamedColumn having = null;
        if (ctx.HAVING() != null) {
            CondGen g = new CondGen();
            having = (UnnamedColumn)g.visit((ParseTree)ctx.having);
        }
        if (having != null) {
            sel.addHavingByAnd(having);
        }
        return sel;
    }

    @Override
    public AbstractRelation visitTable_source(VerdictSQLParser.Table_sourceContext ctx) {
        return this.visitTable_source_item_joined(ctx.table_source_item_joined());
    }

    @Override
    public AbstractRelation visitTable_source_item_joined(VerdictSQLParser.Table_source_item_joinedContext ctx) {
        AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source_item());
        if (ctx.join_part().isEmpty()) {
            return r;
        }
        JoinTable jr = JoinTable.createBase(r, new ArrayList<JoinTable.JoinType>(), new ArrayList<UnnamedColumn>());
        for (VerdictSQLParser.Join_partContext j : ctx.join_part()) {
            AbstractRelation r2 = (AbstractRelation)this.visit((ParseTree)j);
            jr.addJoinTable(r2, this.joinType, this.joinCond);
        }
        return jr;
    }

    @Override
    public AbstractRelation visitJoin_part(VerdictSQLParser.Join_partContext ctx) {
        if (ctx.INNER() != null) {
            AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source());
            CondGen g = new CondGen();
            UnnamedColumn cond = (UnnamedColumn)g.visit((ParseTree)ctx.search_condition());
            this.joinType = JoinTable.JoinType.inner;
            this.joinCond = cond;
            return r;
        }
        if (ctx.LEFT() != null) {
            AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source());
            CondGen g = new CondGen();
            UnnamedColumn cond = (UnnamedColumn)g.visit((ParseTree)ctx.search_condition());
            this.joinType = JoinTable.JoinType.leftouter;
            this.joinCond = cond;
            return r;
        }
        if (ctx.RIGHT() != null) {
            AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source());
            CondGen g = new CondGen();
            UnnamedColumn cond = (UnnamedColumn)g.visit((ParseTree)ctx.search_condition());
            this.joinType = JoinTable.JoinType.rightouter;
            this.joinCond = cond;
            return r;
        }
        if (ctx.CROSS() != null) {
            AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source());
            this.joinType = JoinTable.JoinType.cross;
            this.joinCond = null;
            return r;
        }
        AbstractRelation r = (AbstractRelation)this.visit((ParseTree)ctx.table_source());
        CondGen g = new CondGen();
        if (ctx.search_condition() != null) {
            UnnamedColumn cond = (UnnamedColumn)g.visit((ParseTree)ctx.search_condition());
            this.joinType = JoinTable.JoinType.inner;
            this.joinCond = cond;
        } else {
            this.joinType = JoinTable.JoinType.cross;
            this.joinCond = null;
        }
        return r;
    }

    private String stripQuote(String expr) {
        return expr.replace("\"", "").replace("`", "");
    }

    @Override
    public AbstractRelation visitHinted_table_name_item(VerdictSQLParser.Hinted_table_name_itemContext ctx) {
        BaseTable r = null;
        r = ctx.as_table_alias() != null ? (ctx.table_name_with_hint().table_name().schema != null ? new BaseTable(this.stripQuote(ctx.table_name_with_hint().table_name().schema.getText()), this.stripQuote(ctx.table_name_with_hint().table_name().table.getText()), this.stripQuote(ctx.as_table_alias().table_alias().getText())) : BaseTable.getBaseTableWithoutSchema(this.stripQuote(ctx.table_name_with_hint().table_name().table.getText()), this.stripQuote(ctx.as_table_alias().table_alias().getText()))) : (ctx.table_name_with_hint().table_name().schema != null ? new BaseTable(this.stripQuote(ctx.table_name_with_hint().table_name().schema.getText()), this.stripQuote(ctx.table_name_with_hint().table_name().table.getText())) : new BaseTable(this.stripQuote(ctx.table_name_with_hint().table_name().table.getText())));
        return r;
    }

    @Override
    public AbstractRelation visitDerived_table_source_item(VerdictSQLParser.Derived_table_source_itemContext ctx) {
        RelationGen gen = new RelationGen();
        SelectQuery r = (SelectQuery)gen.visit((ParseTree)ctx.derived_table().subquery().select_statement());
        if (ctx.as_table_alias() != null) {
            r.setAliasName(ctx.as_table_alias().table_alias().getText());
        }
        if (ctx.column_alias_list() != null) {
            for (int i = 0; i < ctx.column_alias_list().column_alias().size(); ++i) {
                r.getSelectList().set(i, new AliasedColumn((UnnamedColumn)r.getSelectList().get(i), ctx.column_alias_list().column_alias(i).getText()));
            }
        }
        return r;
    }
}

