/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlreader;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.parser.VerdictSQLParser;
import org.verdictdb.parser.VerdictSQLParserBaseVisitor;
import org.verdictdb.sqlreader.CondGen;
import org.verdictdb.sqlreader.RelationGen;

public class ExpressionGen
extends VerdictSQLParserBaseVisitor<UnnamedColumn> {
    @Override
    public ColumnOp visitInterval(VerdictSQLParser.IntervalContext ctx) {
        String unit = "day";
        if (ctx.DAY() != null || ctx.DAYS() != null) {
            unit = "day";
        } else if (ctx.MONTH() != null || ctx.MONTHS() != null) {
            unit = "month";
        } else if (ctx.YEAR() != null || ctx.YEARS() != null) {
            unit = "year";
        }
        return new ColumnOp("interval", Arrays.asList(ConstantColumn.valueOf(ctx.constant_expression().getText()), ConstantColumn.valueOf(unit)));
    }

    @Override
    public ColumnOp visitDate(VerdictSQLParser.DateContext ctx) {
        return new ColumnOp("date", Arrays.asList(ConstantColumn.valueOf(ctx.constant_expression().getText())));
    }

    @Override
    public ConstantColumn visitPrimitive_expression(VerdictSQLParser.Primitive_expressionContext ctx) {
        return ConstantColumn.valueOf(ctx.getText());
    }

    @Override
    public ConstantColumn visitTime_unit(VerdictSQLParser.Time_unitContext ctx) {
        return ConstantColumn.valueOf(ctx.getText());
    }

    @Override
    public BaseColumn visitColumn_ref_expression(VerdictSQLParser.Column_ref_expressionContext ctx) {
        VerdictSQLParser.Full_column_nameContext fullColName = ctx.full_column_name();
        if (fullColName == null) {
            return null;
        }
        VerdictSQLParser.Column_nameContext columnName = fullColName.column_name();
        String colName = this.stripQuote(columnName.getText());
        if (fullColName.table_name() == null) {
            return new BaseColumn(colName);
        }
        String tableName = this.stripQuote(fullColName.table_name().table.getText());
        if (fullColName.table_name().schema == null) {
            return new BaseColumn(tableName, colName);
        }
        return new BaseColumn(this.stripQuote(fullColName.table_name().schema.getText()), tableName, colName);
    }

    private String stripQuote(String expr) {
        return expr.replace("\"", "").replace("`", "");
    }

    @Override
    public ColumnOp visitBinary_operator_expression(VerdictSQLParser.Binary_operator_expressionContext ctx) {
        String opType = null;
        opType = ctx.op.getText().equals("+") ? "add" : (ctx.op.getText().equals("-") ? "subtract" : (ctx.op.getText().equals("*") ? "multiply" : (ctx.op.getText().equals("/") ? "divide" : ctx.op.getText())));
        return new ColumnOp(opType, Arrays.asList((UnnamedColumn)this.visit((ParseTree)ctx.expression(0)), (UnnamedColumn)this.visit((ParseTree)ctx.expression(1))));
    }

    @Override
    public UnnamedColumn visitIs_null_expression(VerdictSQLParser.Is_null_expressionContext ctx) {
        UnnamedColumn left = (UnnamedColumn)this.visit((ParseTree)ctx.expression());
        if (ctx.null_notnull().NOT() == null) {
            return ColumnOp.rightisnull(left);
        }
        return ColumnOp.rightisnotnull(left);
    }

    @Override
    public UnnamedColumn visitNot_expression(VerdictSQLParser.Not_expressionContext ctx) {
        UnnamedColumn col = (UnnamedColumn)this.visit((ParseTree)ctx.expression());
        return ColumnOp.not(col);
    }

    @Override
    public ColumnOp visitFunction_call_expression(VerdictSQLParser.Function_call_expressionContext ctx) {
        VerdictSQLParserBaseVisitor<ColumnOp> v = new VerdictSQLParserBaseVisitor<ColumnOp>(){

            @Override
            public ColumnOp visitAggregate_windowed_function(VerdictSQLParser.Aggregate_windowed_functionContext ctx) {
                String fname;
                ExpressionGen g;
                UnnamedColumn col = null;
                if (ctx.all_distinct_expression() != null) {
                    g = new ExpressionGen();
                    col = (UnnamedColumn)g.visit((ParseTree)ctx.all_distinct_expression());
                }
                if (ctx.AVG() != null) {
                    fname = "avg";
                } else if (ctx.SUM() != null) {
                    fname = "sum";
                } else if (ctx.COUNT() != null) {
                    if (ctx.all_distinct_expression() != null && ctx.all_distinct_expression().DISTINCT() != null) {
                        fname = "countdistinct";
                    } else {
                        fname = "count";
                        if (ctx.all_distinct_expression() != null) {
                            g = new ExpressionGen();
                            col = (UnnamedColumn)g.visit((ParseTree)ctx.all_distinct_expression());
                        } else {
                            col = new AsteriskColumn();
                        }
                    }
                } else {
                    fname = ctx.MIN() != null ? "min" : (ctx.MAX() != null ? "max" : "UNKNOWN");
                }
                return new ColumnOp(fname, col);
            }

            @Override
            public ColumnOp visitUnary_function(VerdictSQLParser.Unary_functionContext ctx) {
                ExpressionGen g = new ExpressionGen();
                String fname = ctx.function_name.getText().toLowerCase();
                if (fname.equals("cast")) {
                    ArrayList<String> dataTypeStr = new ArrayList<String>();
                    for (ParseTree child : ctx.cast_as_expression().data_type().children) {
                        dataTypeStr.add(child.getText());
                    }
                    return new ColumnOp(fname, Arrays.asList((UnnamedColumn)g.visit((ParseTree)ctx.cast_as_expression().expression()), ConstantColumn.valueOf(Joiner.on((String)" ").join(dataTypeStr))));
                }
                return new ColumnOp(fname, (UnnamedColumn)g.visit((ParseTree)ctx.expression()));
            }

            @Override
            public ColumnOp visitNoparam_function(VerdictSQLParser.Noparam_functionContext ctx) {
                String fname = ctx.function_name.getText().toLowerCase();
                return new ColumnOp(fname);
            }

            @Override
            public ColumnOp visitBinary_function(VerdictSQLParser.Binary_functionContext ctx) {
                String fname = ctx.function_name.getText().toLowerCase();
                ExpressionGen g = new ExpressionGen();
                return new ColumnOp(fname, Arrays.asList((UnnamedColumn)g.visit((ParseTree)ctx.expression(0)), (UnnamedColumn)g.visit((ParseTree)ctx.expression(1))));
            }

            @Override
            public ColumnOp visitTernary_function(VerdictSQLParser.Ternary_functionContext ctx) {
                String fname = ctx.function_name.getText().toLowerCase();
                ExpressionGen g = new ExpressionGen();
                return new ColumnOp(fname, Arrays.asList((UnnamedColumn)g.visit((ParseTree)ctx.expression(0)), (UnnamedColumn)g.visit((ParseTree)ctx.expression(1)), (UnnamedColumn)g.visit((ParseTree)ctx.expression(2))));
            }

            @Override
            public ColumnOp visitNary_function(VerdictSQLParser.Nary_functionContext ctx) {
                String fname = ctx.function_name.getText().toLowerCase();
                ExpressionGen g = new ExpressionGen();
                ArrayList<UnnamedColumn> columns = new ArrayList<UnnamedColumn>();
                for (VerdictSQLParser.ExpressionContext expressionContext : ctx.expression()) {
                    columns.add((UnnamedColumn)g.visit((ParseTree)expressionContext));
                }
                return new ColumnOp(fname, columns);
            }

            @Override
            public ColumnOp visitExtract_time_function(VerdictSQLParser.Extract_time_functionContext ctx) {
                String fname = "extract";
                ExpressionGen g = new ExpressionGen();
                return new ColumnOp(fname, Arrays.asList(ConstantColumn.valueOf(ctx.extract_unit().getText()), (UnnamedColumn)g.visit((ParseTree)ctx.expression())));
            }

            @Override
            public ColumnOp visitOverlay_string_function(VerdictSQLParser.Overlay_string_functionContext ctx) {
                String fname = "overlay";
                ExpressionGen g = new ExpressionGen();
                ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(0)));
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(1)));
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(2)));
                if (ctx.expression().size() == 4) {
                    operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(3)));
                }
                return new ColumnOp(fname, operands);
            }

            @Override
            public ColumnOp visitSubstring_string_function(VerdictSQLParser.Substring_string_functionContext ctx) {
                String fname = "substring";
                ExpressionGen g = new ExpressionGen();
                ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(0)));
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(1)));
                if (ctx.expression().size() == 3) {
                    operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(2)));
                }
                return new ColumnOp(fname, operands);
            }

            @Override
            public ColumnOp visitTimestamp_function(VerdictSQLParser.Timestamp_functionContext ctx) {
                ExpressionGen g = new ExpressionGen();
                return new ColumnOp("timestampwithoutparentheses", (UnnamedColumn)g.visit((ParseTree)ctx.expression()));
            }

            @Override
            public ColumnOp visitDateadd_function(VerdictSQLParser.Dateadd_functionContext ctx) {
                String fname = "dateadd";
                ExpressionGen g = new ExpressionGen();
                ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.time_unit()));
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(0)));
                operands.add((UnnamedColumn)g.visit((ParseTree)ctx.expression(1)));
                return new ColumnOp(fname, operands);
            }
        };
        return (ColumnOp)v.visit((ParseTree)ctx);
    }

    @Override
    public ColumnOp visitCase_expr(VerdictSQLParser.Case_exprContext ctx) {
        if (ctx.search_condition() != null) {
            ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
            CondGen gen = new CondGen();
            for (VerdictSQLParser.ExpressionContext expressionContext : ctx.expression()) {
                int index = ctx.expression().indexOf((Object)expressionContext);
                if (index != ctx.expression().size() - 1) {
                    operands.add((UnnamedColumn)gen.visit((ParseTree)ctx.search_condition(index)));
                }
                operands.add((UnnamedColumn)this.visit((ParseTree)expressionContext));
            }
            return new ColumnOp("casewhen", operands);
        }
        ArrayList<UnnamedColumn> operands = new ArrayList<UnnamedColumn>();
        ExpressionGen gen = new ExpressionGen();
        for (VerdictSQLParser.ExpressionContext expressionContext : ctx.expression()) {
            operands.add((UnnamedColumn)gen.visit((ParseTree)expressionContext));
        }
        return new ColumnOp("caseexprwhen", operands);
    }

    @Override
    public UnnamedColumn visitBracket_expression(VerdictSQLParser.Bracket_expressionContext ctx) {
        return (UnnamedColumn)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public SubqueryColumn visitSubquery_expression(VerdictSQLParser.Subquery_expressionContext ctx) {
        RelationGen g = new RelationGen();
        return SubqueryColumn.getSubqueryColumn((SelectQuery)g.visit((ParseTree)ctx.subquery().select_statement()));
    }

    public UnnamedColumn getSearch_condition(List<VerdictSQLParser.Search_conditionContext> ctx) {
        CondGen g = new CondGen();
        if (ctx.size() == 1) {
            return (UnnamedColumn)g.visit((ParseTree)ctx.get(0));
        }
        UnnamedColumn col = (UnnamedColumn)this.visit((ParseTree)ctx.get(0));
        for (int i = 0; i < ctx.size(); ++i) {
            col = new ColumnOp("and", Arrays.asList(col, (UnnamedColumn)g.visit((ParseTree)ctx.get(i))));
        }
        return col;
    }
}

