/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.sqlreader;

import java.util.ArrayList;
import java.util.Arrays;
import org.antlr.v4.runtime.tree.ParseTree;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SubqueryColumn;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.parser.VerdictSQLParser;
import org.verdictdb.parser.VerdictSQLParserBaseVisitor;
import org.verdictdb.sqlreader.ExpressionGen;
import org.verdictdb.sqlreader.RelationGen;

public class CondGen
extends VerdictSQLParserBaseVisitor<UnnamedColumn> {
    @Override
    public UnnamedColumn visitComp_expr_predicate(VerdictSQLParser.Comp_expr_predicateContext ctx) {
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn e1 = (UnnamedColumn)g.visit((ParseTree)ctx.expression(0));
        UnnamedColumn e2 = (UnnamedColumn)g.visit((ParseTree)ctx.expression(1));
        if (ctx.comparison_operator().getText().equals("=")) {
            return new ColumnOp("equal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals(">")) {
            return new ColumnOp("greater", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals(">=")) {
            return new ColumnOp("greaterequal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<")) {
            return new ColumnOp("less", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<=")) {
            return new ColumnOp("lessequal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<>") || ctx.comparison_operator().getText().equals("!=")) {
            return new ColumnOp("notequal", Arrays.asList(e1, e2));
        }
        return null;
    }

    @Override
    public UnnamedColumn visitComp_pred_expr_predicate(VerdictSQLParser.Comp_pred_expr_predicateContext ctx) {
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn e1 = (UnnamedColumn)this.visit((ParseTree)ctx.predicate());
        UnnamedColumn e2 = (UnnamedColumn)g.visit((ParseTree)ctx.expression());
        if (ctx.comparison_operator().getText().equals("=")) {
            return new ColumnOp("equal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals(">")) {
            return new ColumnOp("greater", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals(">=")) {
            return new ColumnOp("greaterequal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<")) {
            return new ColumnOp("less", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<=")) {
            return new ColumnOp("lessequal", Arrays.asList(e1, e2));
        }
        if (ctx.comparison_operator().getText().equals("<>") || ctx.comparison_operator().getText().equals("!=")) {
            return new ColumnOp("notequal", Arrays.asList(e1, e2));
        }
        return null;
    }

    @Override
    public UnnamedColumn visitSearch_condition_or(VerdictSQLParser.Search_condition_orContext ctx) {
        UnnamedColumn concat = null;
        for (VerdictSQLParser.Search_condition_notContext nctx : ctx.search_condition_not()) {
            if (concat == null) {
                concat = (UnnamedColumn)this.visit((ParseTree)nctx);
                continue;
            }
            concat = new ColumnOp("or", Arrays.asList(concat, (UnnamedColumn)this.visit((ParseTree)nctx)));
        }
        return concat;
    }

    @Override
    public UnnamedColumn visitSearch_condition(VerdictSQLParser.Search_conditionContext ctx) {
        UnnamedColumn concat = null;
        for (VerdictSQLParser.Search_condition_orContext octx : ctx.search_condition_or()) {
            if (concat == null) {
                concat = (UnnamedColumn)this.visit((ParseTree)octx);
                continue;
            }
            concat = new ColumnOp("and", Arrays.asList(concat, (UnnamedColumn)this.visit((ParseTree)octx)));
        }
        return concat;
    }

    @Override
    public UnnamedColumn visitBracket_predicate(VerdictSQLParser.Bracket_predicateContext ctx) {
        return (UnnamedColumn)this.visit((ParseTree)ctx.search_condition());
    }

    @Override
    public UnnamedColumn visitSearch_condition_not(VerdictSQLParser.Search_condition_notContext ctx) {
        if (ctx.NOT() == null) {
            return (UnnamedColumn)this.visit((ParseTree)ctx.predicate());
        }
        UnnamedColumn predicate = (UnnamedColumn)this.visit((ParseTree)ctx.predicate());
        return ColumnOp.not(predicate);
    }

    @Override
    public UnnamedColumn visitIs_predicate(VerdictSQLParser.Is_predicateContext ctx) {
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn left = (UnnamedColumn)g.visit((ParseTree)ctx.expression());
        if (ctx.null_notnull().NOT() == null) {
            return ColumnOp.rightisnull(left);
        }
        return ColumnOp.rightisnotnull(left);
    }

    @Override
    public UnnamedColumn visitIn_predicate(VerdictSQLParser.In_predicateContext ctx) {
        ExpressionGen g1 = new ExpressionGen();
        if (ctx.subquery() != null) {
            UnnamedColumn left = (UnnamedColumn)g1.visit((ParseTree)ctx.expression());
            boolean not = ctx.NOT() != null;
            RelationGen g2 = new RelationGen();
            SubqueryColumn subquery = SubqueryColumn.getSubqueryColumn((SelectQuery)g2.visit((ParseTree)ctx.subquery()));
            return not ? ColumnOp.notin(Arrays.asList(left, subquery)) : ColumnOp.in(Arrays.asList(left, subquery));
        }
        UnnamedColumn left = (UnnamedColumn)g1.visit((ParseTree)ctx.expression());
        boolean not = ctx.NOT() != null;
        ArrayList<UnnamedColumn> expressionList = new ArrayList<UnnamedColumn>();
        expressionList.add(left);
        for (VerdictSQLParser.ExpressionContext ectx : ctx.expression_list().expression()) {
            expressionList.add((UnnamedColumn)g1.visit((ParseTree)ectx));
        }
        return not ? ColumnOp.notin(expressionList) : ColumnOp.in(expressionList);
    }

    @Override
    public UnnamedColumn visitExists_predicate(VerdictSQLParser.Exists_predicateContext ctx) {
        if (ctx.subquery() == null) {
            return null;
        }
        RelationGen g = new RelationGen();
        SubqueryColumn subquery = SubqueryColumn.getSubqueryColumn((SelectQuery)g.visit((ParseTree)ctx.subquery()));
        return ColumnOp.exists(subquery);
    }

    @Override
    public UnnamedColumn visitLike_predicate(VerdictSQLParser.Like_predicateContext ctx) {
        boolean not;
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn left = (UnnamedColumn)g.visit((ParseTree)ctx.expression(0));
        UnnamedColumn right = (UnnamedColumn)g.visit((ParseTree)ctx.expression(1));
        boolean bl = not = ctx.NOT() != null;
        if (ctx.LIKE() != null) {
            return not ? ColumnOp.notlike(left, right) : ColumnOp.like(left, right);
        }
        if (ctx.RLIKE() != null) {
            return not ? ColumnOp.notrlike(left, right) : ColumnOp.rlike(left, right);
        }
        return null;
    }

    @Override
    public UnnamedColumn visitFunc_predicate(VerdictSQLParser.Func_predicateContext ctx) {
        UnnamedColumn pred = (UnnamedColumn)this.visit((ParseTree)ctx.predicate_function());
        return pred;
    }

    @Override
    public UnnamedColumn visitPredicate_function(VerdictSQLParser.Predicate_functionContext ctx) {
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn col = (UnnamedColumn)g.visit((ParseTree)ctx.expression());
        return col;
    }

    @Override
    public UnnamedColumn visitComp_between_expr(VerdictSQLParser.Comp_between_exprContext ctx) {
        ExpressionGen g = new ExpressionGen();
        UnnamedColumn col = (UnnamedColumn)g.visit((ParseTree)ctx.expression(0));
        UnnamedColumn left = (UnnamedColumn)g.visit((ParseTree)ctx.expression(1));
        UnnamedColumn right = (UnnamedColumn)g.visit((ParseTree)ctx.expression(2));
        return new ColumnOp("between", Arrays.asList(col, left, right));
    }

    @Override
    public UnnamedColumn visitTrue_orfalse(VerdictSQLParser.True_orfalseContext ctx) {
        ConstantColumn c = null;
        c = ctx.TRUE() != null ? ConstantColumn.valueOf("TRUE") : ConstantColumn.valueOf("FALSE");
        return c;
    }
}

