/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.metastore;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsConnection;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.querying.CreateSchemaQuery;
import org.verdictdb.core.scrambling.ScrambleMeta;
import org.verdictdb.core.scrambling.ScrambleMetaSet;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.CreateTableDefinitionQuery;
import org.verdictdb.core.sqlobject.InsertValuesQuery;
import org.verdictdb.core.sqlobject.OrderbyAttribute;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.metastore.VerdictMetaStore;
import org.verdictdb.sqlwriter.QueryToSql;

public class ScrambleMetaStore
extends VerdictMetaStore {
    private static final String DEFAULT_STORE_SCHEMA = "verdictdbmetadata";
    private static final String ADDED_AT_COLUMN = "addedat";
    private static final String SCHEMA_COLUMN = "schema";
    private static final String TABLE_COLUMN = "table";
    private static final String DATA_COLUMN = "data";
    private DbmsConnection conn;
    private String storeSchema = "verdictdbmetadata";

    public ScrambleMetaStore(DbmsConnection conn) {
        this(conn, DEFAULT_STORE_SCHEMA);
    }

    public ScrambleMetaStore(DbmsConnection conn, String storeSchema) {
        this.conn = conn;
        this.storeSchema = storeSchema;
    }

    public String getStoreSchema() {
        return this.storeSchema;
    }

    public static String getDefaultStoreSchema() {
        return DEFAULT_STORE_SCHEMA;
    }

    public static String getAddedAtColumn() {
        return ADDED_AT_COLUMN;
    }

    public static String getSchemaColumn() {
        return SCHEMA_COLUMN;
    }

    public static String getTableColumn() {
        return TABLE_COLUMN;
    }

    public static String getDataColumn() {
        return DATA_COLUMN;
    }

    public void addToStore(ScrambleMeta scrambleMeta) throws VerdictDBException {
        ScrambleMetaSet scrambleMetaSet = new ScrambleMetaSet();
        scrambleMetaSet.addScrambleMeta(scrambleMeta);
        this.addToStore(scrambleMetaSet);
    }

    public void addToStore(ScrambleMetaSet scrambleMetaSet) throws VerdictDBException {
        CreateSchemaQuery createSchemaQuery = new CreateSchemaQuery(this.storeSchema);
        createSchemaQuery.setIfNotExists(true);
        String sql = QueryToSql.convert(this.conn.getSyntax(), createSchemaQuery);
        this.conn.execute(sql);
        CreateTableDefinitionQuery createTableQuery = this.createScrambleMetaStoreTableStatement();
        sql = QueryToSql.convert(this.conn.getSyntax(), createTableQuery);
        this.conn.execute(sql);
        StringBuilder insertSqls = new StringBuilder();
        for (ScrambleMeta meta : scrambleMetaSet) {
            InsertValuesQuery q = this.createInsertMetaQuery(meta);
            String s = QueryToSql.convert(this.conn.getSyntax(), q);
            insertSqls.append(s);
            insertSqls.append("; ");
        }
        this.conn.execute(insertSqls.toString());
    }

    private CreateTableDefinitionQuery createScrambleMetaStoreTableStatement() {
        CreateTableDefinitionQuery query = new CreateTableDefinitionQuery();
        query.setSchemaName(this.storeSchema);
        query.setTableName(this.getMetaStoreTableName());
        query.addColumnNameAndType((Pair<String, String>)Pair.of((Object)ADDED_AT_COLUMN, (Object)"TIMESTAMP"));
        query.addColumnNameAndType((Pair<String, String>)Pair.of((Object)SCHEMA_COLUMN, (Object)"VARCHAR(100)"));
        query.addColumnNameAndType((Pair<String, String>)Pair.of((Object)TABLE_COLUMN, (Object)"VARCHAR(100)"));
        query.addColumnNameAndType((Pair<String, String>)Pair.of((Object)DATA_COLUMN, (Object)"TEXT"));
        query.setIfNotExists(true);
        return query;
    }

    private InsertValuesQuery createInsertMetaQuery(ScrambleMeta meta) {
        InsertValuesQuery query = new InsertValuesQuery();
        query.setSchemaName(this.getStoreSchema());
        query.setTableName(this.getMetaStoreTableName());
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String scrambleSchema = meta.getSchemaName();
        String scrambleTable = meta.getTableName();
        String jsonString = meta.toJsonString();
        query.setValues(Arrays.asList(timeStamp, scrambleSchema, scrambleTable, jsonString));
        return query;
    }

    public ScrambleMetaSet retrieve() {
        ScrambleMetaSet retrieved = new ScrambleMetaSet();
        try {
            String storeSchema = this.getStoreSchema();
            String storeTable = this.getMetaStoreTableName();
            List<String> existingSchemas = this.conn.getSchemas();
            if (!existingSchemas.contains(storeSchema)) {
                return new ScrambleMetaSet();
            }
            List<String> existingTables = this.conn.getTables(storeSchema);
            if (!existingTables.contains(storeTable)) {
                return new ScrambleMetaSet();
            }
            String tableAlias = "t";
            SelectQuery query = SelectQuery.create(Arrays.asList(new BaseColumn(tableAlias, ADDED_AT_COLUMN), new BaseColumn(tableAlias, SCHEMA_COLUMN), new BaseColumn(tableAlias, TABLE_COLUMN), new BaseColumn(tableAlias, DATA_COLUMN)), (AbstractRelation)new BaseTable(storeSchema, storeTable, tableAlias));
            query.addOrderby(new OrderbyAttribute(ADDED_AT_COLUMN));
            String sql = QueryToSql.convert(this.conn.getSyntax(), query);
            DbmsQueryResult result = this.conn.execute(sql);
            while (result.next()) {
                String jsonString = result.getString(3);
                ScrambleMeta meta = ScrambleMeta.fromJsonString(jsonString);
                retrieved.addScrambleMeta(meta);
            }
        }
        catch (VerdictDBException e) {
            e.printStackTrace();
        }
        return retrieved;
    }
}

