/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.jdbc41;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.verdictdb.connection.DataTypeConverter;
import org.verdictdb.coordinator.VerdictSingleResult;

public class VerdictResultSetMetaData
implements ResultSetMetaData {
    private VerdictSingleResult queryResult;
    List<String> caseSensitiveColumnTypes = Arrays.asList("char", "string", "text");
    List<String> signedColumnTypes = Arrays.asList("double", "int", "real");

    public VerdictResultSetMetaData(VerdictSingleResult queryResult) {
        this.queryResult = queryResult;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported function.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not supported function.");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.queryResult.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.queryResult.getMetaData().isAutoIncrement.get(column - 1);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        String typeName = DataTypeConverter.typeName(this.queryResult.getColumnType(column - 1));
        for (String a : this.caseSensitiveColumnTypes) {
            if (!typeName.contains(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.queryResult.getMetaData().isCurrency.get(column - 1);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.queryResult.getMetaData().isNullable.get(column - 1);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        String typeName = DataTypeConverter.typeName(this.queryResult.getColumnType(column - 1));
        for (String a : this.signedColumnTypes) {
            if (!typeName.contains(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.queryResult.getMetaData().columnDisplaySize.get(column - 1);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.queryResult.getColumnName(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.queryResult.getColumnName(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("Not supported function.");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.queryResult.getMetaData().precision.get(column - 1);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.queryResult.getMetaData().scale.get(column - 1);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("Not supported function.");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("Not supported function.");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.queryResult.getColumnType(column - 1);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return DataTypeConverter.typeName(this.queryResult.getColumnType(column - 1));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.queryResult.getMetaData().columnClassName.get(column - 1);
    }
}

