/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.jdbc41;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.verdictdb.coordinator.VerdictSingleResult;
import org.verdictdb.jdbc41.VerdictResultSetMetaData;

public class VerdictResultSet
implements ResultSet {
    private VerdictSingleResult queryResult;
    private ResultSetMetaData metadata;
    private long rowIndex = 0L;
    private HashMap<String, Integer> colNameIdx = new HashMap();

    public VerdictResultSet(VerdictSingleResult queryResult) {
        this.queryResult = queryResult;
        for (int i = 0; i < queryResult.getColumnCount(); ++i) {
            this.colNameIdx.put(queryResult.getColumnName(i), i);
        }
        this.metadata = new VerdictResultSetMetaData(queryResult);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowIndex = this.queryResult.getRowCount() + 1L;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rowIndex = 0L;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 1) {
            throw new SQLException("Column index must be a positive integer.");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.colNameIdx.get(this.standardizedLabel(columnLabel.toLowerCase())) + 1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.queryResult.getRowCount() == 0L) {
            return false;
        }
        this.rowIndex = 1L;
        return true;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getArray(columnIndex - 1);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getArray(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getAsciiStream(columnIndex - 1);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getAsciiStream(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBigDecimal(columnIndex - 1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBigDecimal(columnIndex - 1, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBigDecimal(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBigDecimal(this.standardizedLabel(columnLabel.toLowerCase()), scale);
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBinaryStream(columnIndex - 1);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBinaryStream(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBlob(columnIndex - 1);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBlob(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBoolean(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBoolean(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getByte(columnIndex - 1);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getByte(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getBytes(columnIndex - 1);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getBytes(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getClob(columnIndex - 1);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getClob(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getDate(columnIndex - 1);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getDate(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getDouble(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getFloat(columnIndex - 1);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getFloat(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getInt(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getLong(columnIndex - 1);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getLong(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.standardizedLabel(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getNClob(columnIndex - 1);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getNClob(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.standardizedLabel(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getValue(columnIndex - 1);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.getObject(this.colNameIdx.get(this.standardizedLabel(columnLabel.toLowerCase())) + 1);
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return (T)this.getObject(this.standardizedLabel(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.standardizedLabel(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.queryResult.getRef(columnIndex - 1);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getRef(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public int getRow() throws SQLException {
        return Long.valueOf(this.rowIndex).intValue();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.queryResult.getRowId(columnIndex - 1);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getRowId(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getShort(columnIndex - 1);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getShort(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.queryResult.getSQLXML(columnIndex - 1);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getSQLXML(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.queryResult.getString(columnIndex - 1);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getString(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getTime(columnIndex - 1);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getTime(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getTimestamp(columnIndex - 1);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getTimestamp(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getType() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.queryResult.getUnicodeStream(columnIndex - 1);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getUnicodeStream(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.queryResult.getURL(columnIndex - 1);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        if (this.colNameIdx.containsKey(this.standardizedLabel(columnLabel))) {
            return this.queryResult.getURL(this.standardizedLabel(columnLabel.toLowerCase()));
        }
        throw new SQLException("ColumnLabel does not exist.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowIndex > this.queryResult.getRowCount();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowIndex == 0L;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowIndex == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rowIndex == this.queryResult.getRowCount();
    }

    private boolean isValidType(String expected, int columnindex) {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasMore = this.queryResult.next();
        if (hasMore) {
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    String standardizedLabel(String label) {
        return label.toLowerCase();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.queryResult.wasNull();
    }
}

