/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.jdbc41;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import org.verdictdb.exception.VerdictDBDbmsException;
import org.verdictdb.jdbc41.VerdictConnection;

public class Driver
implements java.sql.Driver {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            String newUrl = url;
            try {
                String[] tokens = url.split(":");
                if (tokens.length >= 2 && (tokens[1].equalsIgnoreCase("verdict") || tokens[1].equalsIgnoreCase("verdictdb"))) {
                    ArrayList<String> newTokens = new ArrayList<String>();
                    for (int i = 0; i < tokens.length; ++i) {
                        if (i == 1) continue;
                        newTokens.add(tokens[i]);
                    }
                    newUrl = Joiner.on((String)":").join(newTokens);
                }
                VerdictConnection verdictConnection = new VerdictConnection(newUrl, info);
                System.out.println("VerdictConnection has been created: " + verdictConnection);
                return verdictConnection;
            }
            catch (VerdictDBDbmsException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        String[] tokens = url.split(":");
        return tokens.length >= 2 && (tokens[1].equalsIgnoreCase("verdict") || tokens[1].equalsIgnoreCase("verdictdb"));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 5;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            System.err.println("Error occurred while registering VerdictDB driver:");
            System.err.println(e.getMessage());
        }
    }
}

