/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.sqlobject;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.GroupingAttribute;
import org.verdictdb.core.sqlobject.OrderbyAttribute;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.UnnamedColumn;

public class SelectQuery
extends AbstractRelation
implements SqlConvertible {
    private static final long serialVersionUID = -4830209213341883527L;
    List<SelectItem> selectList = new ArrayList<SelectItem>();
    List<AbstractRelation> fromList = new ArrayList<AbstractRelation>();
    Optional<UnnamedColumn> filter = Optional.absent();
    List<GroupingAttribute> groupby = new ArrayList<GroupingAttribute>();
    List<OrderbyAttribute> orderby = new ArrayList<OrderbyAttribute>();
    Optional<UnnamedColumn> having = Optional.absent();
    Optional<UnnamedColumn> limit = Optional.absent();

    public static SelectQuery create(SelectItem column) {
        return SelectQuery.create(Arrays.asList(column), Arrays.asList(new AbstractRelation[0]));
    }

    public static SelectQuery create(SelectItem column, AbstractRelation relation) {
        return SelectQuery.create(Arrays.asList(column), relation);
    }

    public static SelectQuery create(List<SelectItem> columns, AbstractRelation relation) {
        SelectQuery sel = new SelectQuery();
        for (SelectItem c : columns) {
            sel.addSelectItem(c);
        }
        sel.addTableSource(relation);
        return sel;
    }

    public static SelectQuery create(List<SelectItem> columns, AbstractRelation relation, UnnamedColumn predicate) {
        SelectQuery sel = new SelectQuery();
        for (SelectItem c : columns) {
            sel.addSelectItem(c);
        }
        sel.addTableSource(relation);
        sel.filter = Optional.of((Object)predicate);
        return sel;
    }

    public static SelectQuery create(List<SelectItem> columns, List<AbstractRelation> relation) {
        SelectQuery sel = new SelectQuery();
        for (SelectItem c : columns) {
            sel.addSelectItem(c);
        }
        for (AbstractRelation r : relation) {
            sel.addTableSource(r);
        }
        return sel;
    }

    @Override
    public SelectQuery deepcopy() {
        SelectQuery sel = new SelectQuery();
        for (SelectItem c : this.getSelectList()) {
            sel.addSelectItem(c.deepcopy());
        }
        for (AbstractRelation r : this.getFromList()) {
            sel.addTableSource(r.deepcopy());
        }
        if (this.getFilter().isPresent()) {
            sel.addFilterByAnd(((UnnamedColumn)this.getFilter().get()).deepcopy());
        }
        for (GroupingAttribute a : this.getGroupby()) {
            sel.addGroupby(a);
        }
        if (this.getAliasName().isPresent()) {
            sel.setAliasName((String)this.getAliasName().get());
        }
        return sel;
    }

    public void addSelectItem(SelectItem column) {
        this.selectList.add(column);
    }

    public void addTableSource(AbstractRelation relation) {
        this.fromList.add(relation);
    }

    public void addFilterByAnd(UnnamedColumn predicate) {
        this.filter = !this.filter.isPresent() ? Optional.of((Object)predicate) : Optional.of((Object)ColumnOp.and((UnnamedColumn)this.filter.get(), predicate));
    }

    public void addGroupby(GroupingAttribute column) {
        this.groupby.add(column);
    }

    public void addGroupby(List<GroupingAttribute> columns) {
        this.groupby.addAll(columns);
    }

    public void addHavingByAnd(UnnamedColumn predicate) {
        this.having = !this.having.isPresent() ? Optional.of((Object)predicate) : Optional.of((Object)ColumnOp.and((UnnamedColumn)this.having.get(), predicate));
    }

    public void addLimit(UnnamedColumn limit) {
        this.limit = Optional.of((Object)limit);
    }

    public void addOrderby(List<OrderbyAttribute> columns) {
        this.orderby.addAll(columns);
    }

    public void addOrderby(OrderbyAttribute column) {
        this.orderby.add(column);
    }

    public void setFromList(List<AbstractRelation> fromList) {
        this.fromList = fromList;
    }

    public void clearFilters() {
        this.filter = Optional.absent();
    }

    public void clearFromList() {
        this.fromList = new ArrayList<AbstractRelation>();
    }

    public void clearGroupby() {
        this.groupby = new ArrayList<GroupingAttribute>();
    }

    public void clearSelectList() {
        this.selectList = new ArrayList<SelectItem>();
    }

    public List<SelectItem> getSelectList() {
        return this.selectList;
    }

    public Optional<UnnamedColumn> getFilter() {
        return this.filter;
    }

    public List<AbstractRelation> getFromList() {
        return this.fromList;
    }

    public List<GroupingAttribute> getGroupby() {
        return this.groupby;
    }

    public Optional<UnnamedColumn> getHaving() {
        return this.having;
    }

    public Optional<UnnamedColumn> getLimit() {
        return this.limit;
    }

    public List<OrderbyAttribute> getOrderby() {
        return this.orderby;
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public SelectQuery selectListDeepCopy() {
        ArrayList<SelectItem> newSelectItemList = new ArrayList<SelectItem>();
        for (SelectItem sel : this.selectList) {
            SelectItem newSel = sel.deepcopy();
            newSelectItemList.add(newSel);
        }
        SelectQuery query = SelectQuery.create(newSelectItemList, this.fromList);
        query.filter = this.filter;
        query.groupby = this.groupby;
        query.orderby = this.orderby;
        query.having = this.having;
        query.limit = this.limit;
        query.aliasName = this.aliasName;
        return query;
    }
}

