/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.sqlobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.UnnamedColumn;

public class JoinTable
extends AbstractRelation {
    private static final long serialVersionUID = 4600469783922264549L;
    List<AbstractRelation> joinList = new ArrayList<AbstractRelation>();
    List<JoinType> joinTypeList = new ArrayList<JoinType>();
    List<UnnamedColumn> condition = new ArrayList<UnnamedColumn>();

    public static JoinTable create(List<AbstractRelation> joinList, List<JoinType> joinTypeList, List<UnnamedColumn> condition) {
        JoinTable join = new JoinTable();
        join.joinList = joinList;
        join.joinTypeList = joinTypeList;
        join.condition = condition;
        return join;
    }

    public static JoinTable createBase(AbstractRelation joinBaseTable, List<JoinType> joinTypeList, List<UnnamedColumn> condition) {
        JoinTable join = new JoinTable();
        join.joinList.add(joinBaseTable);
        join.joinTypeList = joinTypeList;
        join.condition = condition;
        return join;
    }

    public void addJoinTable(AbstractRelation joinTable, JoinType joinType, UnnamedColumn conditon) {
        this.condition.add(conditon);
        this.joinList.add(joinTable);
        this.joinTypeList.add(joinType);
    }

    public List<AbstractRelation> getJoinList() {
        return this.joinList;
    }

    public List<JoinType> getJoinTypeList() {
        return this.joinTypeList;
    }

    public List<UnnamedColumn> getCondition() {
        return this.condition;
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public JoinTable deepcopy() {
        ArrayList<AbstractRelation> newJoinlist = new ArrayList<AbstractRelation>();
        ArrayList<UnnamedColumn> newJoinCond = new ArrayList<UnnamedColumn>();
        for (AbstractRelation j : this.joinList) {
            newJoinlist.add(j.deepcopy());
        }
        for (UnnamedColumn c : this.condition) {
            if (c != null) {
                newJoinCond.add(c.deepcopy());
                continue;
            }
            newJoinCond.add(null);
        }
        return JoinTable.create(newJoinlist, this.joinTypeList, newJoinCond);
    }

    public static enum JoinType {
        left,
        leftouter,
        right,
        rightouter,
        inner,
        outer,
        cross;

    }
}

