/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.sqlobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.verdictdb.core.sqlobject.CreateScrambledTableQuery;
import org.verdictdb.core.sqlobject.CreateTableQuery;
import org.verdictdb.core.sqlobject.SelectQuery;

public class CreateTableAsSelectQuery
extends CreateTableQuery {
    private static final long serialVersionUID = -4077488589201481833L;
    protected SelectQuery select;
    protected List<String> partitionColumns = new ArrayList<String>();
    protected boolean overwrite = false;

    public CreateTableAsSelectQuery(String schemaName, String tableName, SelectQuery select) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.select = select;
    }

    public CreateTableAsSelectQuery(CreateScrambledTableQuery query) {
        this.schemaName = query.schemaName;
        this.tableName = query.tableName;
        this.partitionColumns.addAll(query.partitionColumns);
        this.select = query.select;
        this.overwrite = query.overwrite;
        this.ifNotExists = query.ifNotExists;
    }

    public void addPartitionColumn(String column) {
        this.partitionColumns.add(column);
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public SelectQuery getSelect() {
        return this.select;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

