/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.scrambling.ScramblingMethodBase;
import org.verdictdb.core.scrambling.TableSizeCountNode;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.UnnamedColumn;

public class UniformScramblingMethod
extends ScramblingMethodBase {
    private final String MAIN_TABLE_SOURCE_ALIAS = "t";
    private int totalNumberOfblocks = -1;

    public UniformScramblingMethod(long blockSize) {
        super(blockSize);
    }

    @Override
    public List<ExecutableNodeBase> getStatisticsNode(String oldSchemaName, String oldTableName, String columnMetaTokenKey, String partitionMetaTokenKey) {
        TableSizeCountNode countNode = new TableSizeCountNode(oldSchemaName, oldTableName);
        return Arrays.asList(countNode);
    }

    @Override
    public List<UnnamedColumn> getTierExpressions(Map<String, Object> metaData) {
        return Arrays.asList(new UnnamedColumn[0]);
    }

    @Override
    public List<Double> getCumulativeProbabilityDistributionForTier(Map<String, Object> metaData, int tier) {
        DbmsQueryResult tableSizeResult = (DbmsQueryResult)metaData.get(TableSizeCountNode.class.getSimpleName());
        tableSizeResult.next();
        long tableSize = tableSizeResult.getLong("verdictdbtotalcount");
        this.totalNumberOfblocks = (int)Math.ceil((float)tableSize / (float)this.blockSize);
        ArrayList<Double> prob = new ArrayList<Double>();
        for (int i = 0; i < this.totalNumberOfblocks; ++i) {
            prob.add((double)(i + 1) / (double)this.totalNumberOfblocks);
        }
        this.storeCumulativeProbabilityDistribution(tier, prob);
        return prob;
    }

    @Override
    public AbstractRelation getScramblingSource(String originalSchema, String originalTable, Map<String, Object> metaData) {
        String tableSourceAlias = "t";
        return new BaseTable(originalSchema, originalTable, tableSourceAlias);
    }

    @Override
    public String getMainTableAlias() {
        return "t";
    }

    @Override
    public int getBlockCount() {
        return this.totalNumberOfblocks;
    }

    @Override
    public int getTierCount() {
        return 1;
    }
}

