/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import org.verdictdb.core.scrambling.BaseScrambler;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.AsteriskColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.CreateTableAsSelectQuery;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;

public class UniformScrambler
extends BaseScrambler {
    public UniformScrambler(String originalSchemaName, String originalTableName, String scrambledSchemaName, String scrambledTableName, int aggregationBlockCount) {
        super(originalSchemaName, originalTableName, scrambledSchemaName, scrambledTableName, aggregationBlockCount);
    }

    public CreateTableAsSelectQuery createQuery() {
        SelectQuery selectQuery = this.scramblingQuery();
        CreateTableAsSelectQuery createQuery = new CreateTableAsSelectQuery(this.scrambledSchemaName, this.scrambledTableName, selectQuery);
        createQuery.addPartitionColumn(aggregationBlockColumn);
        return createQuery;
    }

    SelectQuery scramblingQuery() {
        AliasedColumn aggBlockValue = new AliasedColumn(ColumnOp.cast(ColumnOp.floor(ColumnOp.multiply(ColumnOp.rand(), ConstantColumn.valueOf(this.aggregationBlockCount))), ConstantColumn.valueOf("smallint")), aggregationBlockColumn);
        AliasedColumn subsampleValue = new AliasedColumn(ColumnOp.cast(ColumnOp.floor(ColumnOp.multiply(ColumnOp.rand(), ConstantColumn.valueOf(100))), ConstantColumn.valueOf("smallint")), subsampleColumn);
        AliasedColumn tierValue = new AliasedColumn(ConstantColumn.valueOf(1), tierColumn);
        ArrayList<SelectItem> newSelectList = new ArrayList<SelectItem>();
        newSelectList.add(new AsteriskColumn());
        newSelectList.add(aggBlockValue);
        newSelectList.add(subsampleValue);
        newSelectList.add(tierValue);
        SelectQuery augmentedRelation = SelectQuery.create(newSelectList, (AbstractRelation)new BaseTable(this.originalSchemaName, this.originalTableName));
        return augmentedRelation;
    }
}

