/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.List;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.scrambling.StatiticsQueryGenerator;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;

public class StatisticsRetrievalNode
extends QueryNodeBase {
    private static final long serialVersionUID = -2135920046094297794L;
    String schemaName;
    String tableName;
    StatiticsQueryGenerator queryGenerator;

    public StatisticsRetrievalNode(String schemaName, String tableName) {
        super(null);
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public static StatisticsRetrievalNode create(StatiticsQueryGenerator queryGenerator, String schemaName, String tableName) {
        StatisticsRetrievalNode node = new StatisticsRetrievalNode(schemaName, tableName);
        node.queryGenerator = queryGenerator;
        return node;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        List columnNamesAndTypes = (List)tokens.get(0).getValue("columnMeta");
        this.selectQuery = this.queryGenerator.create(this.schemaName, this.tableName, columnNamesAndTypes, null);
        return this.selectQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue("queryResult", result);
        return token;
    }

    @Override
    public ExecutableNodeBase deepcopy() {
        StatisticsRetrievalNode node = new StatisticsRetrievalNode(this.schemaName, this.tableName);
        this.copyFields((QueryNodeBase)this, (QueryNodeBase)node);
        return node;
    }

    protected void copyFields(StatisticsRetrievalNode from, StatisticsRetrievalNode to) {
        super.copyFields(from, to);
        to.queryGenerator = from.queryGenerator;
    }
}

