/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.verdictdb.core.execplan.ExecutableNode;
import org.verdictdb.core.execplan.ExecutablePlan;
import org.verdictdb.core.querying.ExecutableNodeBase;

public class SimpleTreePlan
implements ExecutablePlan {
    ExecutableNodeBase root;

    public SimpleTreePlan(ExecutableNodeBase root) {
        this.root = root;
    }

    @Override
    public Set<Integer> getNodeGroupIDs() {
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        List<ExecutableNodeBase> nodes = this.retrieveAllDescendant(this.root);
        for (int i = 0; i < nodes.size(); ++i) {
            groupIDs.add(i);
        }
        return groupIDs;
    }

    private List<ExecutableNodeBase> retrieveAllDescendant(ExecutableNodeBase root) {
        ArrayList<ExecutableNodeBase> nodes = new ArrayList<ExecutableNodeBase>();
        LinkedList<ExecutableNodeBase> pool = new LinkedList<ExecutableNodeBase>();
        pool.add(root);
        while (!pool.isEmpty()) {
            ExecutableNodeBase n = (ExecutableNodeBase)pool.remove(0);
            if (nodes.contains(n)) continue;
            nodes.add(n);
            pool.addAll(n.getExecutableNodeBaseDependents());
        }
        return nodes;
    }

    @Override
    public List<ExecutableNode> getNodesInGroup(int groupId) {
        List<ExecutableNodeBase> nodes = this.retrieveAllDescendant(this.root);
        return Arrays.asList(nodes.get(groupId));
    }

    @Override
    public ExecutableNode getReportingNode() {
        return this.root;
    }
}

