/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.List;
import java.util.Map;
import org.verdictdb.core.querying.ExecutableNodeBase;
import org.verdictdb.core.scrambling.ColumnMetadataRetrievalNode;
import org.verdictdb.core.scrambling.PartitionMetadataRetrievalNode;
import org.verdictdb.core.scrambling.ScramblingMethod;
import org.verdictdb.core.scrambling.ScramblingNode;
import org.verdictdb.core.scrambling.SimpleTreePlan;

public class ScramblingPlan
extends SimpleTreePlan {
    public static final String COLUMN_METADATA_KEY = "scramblingPlan:columnMetaData";
    static final String PARTITION_METADATA_KEY = "scramblingPlan:partitionMetaData";

    private ScramblingPlan(ExecutableNodeBase root) {
        super(root);
    }

    public static ScramblingPlan create(String newSchemaName, String newTableName, String oldSchemaName, String oldTableName, ScramblingMethod method, Map<String, String> options) {
        ColumnMetadataRetrievalNode columnMetaDataNode = ColumnMetadataRetrievalNode.create(oldSchemaName, oldTableName, COLUMN_METADATA_KEY);
        PartitionMetadataRetrievalNode partitionMetaDataNode = PartitionMetadataRetrievalNode.create(oldSchemaName, oldTableName, PARTITION_METADATA_KEY);
        List<ExecutableNodeBase> statsNodes = method.getStatisticsNode(oldSchemaName, oldTableName, COLUMN_METADATA_KEY, PARTITION_METADATA_KEY);
        for (ExecutableNodeBase n : statsNodes) {
            n.subscribeTo(columnMetaDataNode, 100);
            n.subscribeTo(partitionMetaDataNode, 101);
        }
        ScramblingNode scramblingNode = ScramblingNode.create(newSchemaName, newTableName, oldSchemaName, oldTableName, method, options);
        scramblingNode.subscribeTo(columnMetaDataNode, 100);
        for (int i = 0; i < statsNodes.size(); ++i) {
            scramblingNode.subscribeTo(statsNodes.get(i), i);
        }
        ScramblingPlan scramblingPlan = new ScramblingPlan(scramblingNode);
        return scramblingPlan;
    }
}

