/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.IdCreator;
import org.verdictdb.core.scrambling.CreateScrambledTableNode;
import org.verdictdb.core.scrambling.ScramblingMethod;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.ConstantColumn;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;

public class ScramblingNode
extends CreateScrambledTableNode {
    private static final long serialVersionUID = 3921018031181756963L;

    public ScramblingNode(IdCreator namer, String originalSchemaName, String originalTableName, ScramblingMethod method, String tierColumnName, String blockColumnName) {
        super(namer, null, originalSchemaName, originalTableName, method, tierColumnName, blockColumnName);
    }

    public static ScramblingNode create(final String newSchemaName, final String newTableName, String oldSchemaName, String oldTableName, ScramblingMethod method, Map<String, String> options) {
        IdCreator idCreator = new IdCreator(){

            @Override
            public String generateAliasName() {
                return null;
            }

            @Override
            public Pair<String, String> generateTempTableName() {
                return Pair.of((Object)newSchemaName, (Object)newTableName);
            }
        };
        String tierColumnName = options.get("tierColumnName");
        String blockColumnName = options.get("blockColumnName");
        return new ScramblingNode(idCreator, oldSchemaName, oldTableName, method, tierColumnName, blockColumnName);
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        for (ExecutionInfoToken token : tokens) {
            for (Map.Entry<String, Object> keyValue : token.entrySet()) {
                String key = keyValue.getKey();
                Object value = keyValue.getValue();
                metaData.put(key, value);
            }
        }
        this.selectQuery = this.composeQuery(metaData);
        this.addPartitionColumn(this.blockColumnName);
        return super.createQuery(tokens);
    }

    SelectQuery composeQuery(Map<String, Object> metaData) {
        List<UnnamedColumn> tierPredicates = this.method.getTierExpressions(metaData);
        int tierCount = tierPredicates.size() + 1;
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List columnNamesAndTypes = (List)metaData.get("scramblingPlan:columnMetaData");
        String mainTableAlias = this.method.getMainTableAlias();
        for (Pair nameAndType : columnNamesAndTypes) {
            String name = (String)nameAndType.getLeft();
            selectItems.add(new BaseColumn(mainTableAlias, name));
        }
        ArrayList<UnnamedColumn> tierOperands = new ArrayList<UnnamedColumn>();
        UnnamedColumn tierExpr = null;
        if (tierPredicates.size() == 0) {
            tierExpr = ConstantColumn.valueOf(0);
        } else if (tierPredicates.size() > 0) {
            for (int i = 0; i < tierPredicates.size(); ++i) {
                UnnamedColumn pred = tierPredicates.get(i);
                tierOperands.add(pred);
                tierOperands.add(ConstantColumn.valueOf(i));
            }
            tierOperands.add(ConstantColumn.valueOf(tierPredicates.size()));
            tierExpr = ColumnOp.casewhen(tierOperands);
        }
        selectItems.add(new AliasedColumn(tierExpr, this.tierColumnName));
        UnnamedColumn blockExpr = null;
        ArrayList<UnnamedColumn> blockOperands = new ArrayList<UnnamedColumn>();
        for (int i = 0; i < tierCount; ++i) {
            List<Double> cumulProb = this.method.getCumulativeProbabilityDistributionForTier(metaData, i);
            List<Double> condProb = this.computeConditionalProbabilityDistribution(cumulProb);
            int blockCount = cumulProb.size();
            ArrayList<UnnamedColumn> blockForTierOperands = new ArrayList<UnnamedColumn>();
            for (int j = 0; j < blockCount; ++j) {
                blockForTierOperands.add(ColumnOp.lessequal(ColumnOp.rand(), ConstantColumn.valueOf(condProb.get(j))));
                blockForTierOperands.add(ConstantColumn.valueOf(j));
            }
            UnnamedColumn blockForTierExpr = blockForTierOperands.size() <= 1 ? ConstantColumn.valueOf(0) : ColumnOp.casewhen(blockForTierOperands);
            if (i < tierCount - 1) {
                blockOperands.add(ColumnOp.equal(tierExpr, ConstantColumn.valueOf(i)));
            }
            blockOperands.add(blockForTierExpr);
        }
        blockExpr = tierCount == 1 ? (UnnamedColumn)blockOperands.get(0) : ColumnOp.casewhen(blockOperands);
        selectItems.add(new AliasedColumn(blockExpr, this.blockColumnName));
        AbstractRelation tableSource = this.method.getScramblingSource(this.originalSchemaName, this.originalTableName, metaData);
        SelectQuery scramblingQuery = SelectQuery.create(selectItems, tableSource);
        return scramblingQuery;
    }

    List<Double> computeConditionalProbabilityDistribution(List<Double> cumulativeProbabilityDistribution) {
        ArrayList<Double> cond = new ArrayList<Double>();
        int length = cumulativeProbabilityDistribution.size();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                cond.add(cumulativeProbabilityDistribution.get(i));
                continue;
            }
            double numerator = cumulativeProbabilityDistribution.get(i) - cumulativeProbabilityDistribution.get(i - 1);
            double denominator = 1.0 - cumulativeProbabilityDistribution.get(i - 1);
            double condProb = 0.0;
            if (denominator != 0.0) {
                condProb = numerator / denominator;
            }
            cond.add(condProb);
        }
        return cond;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        return super.createToken(result);
    }
}

