/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.core.scrambling.ScrambleMeta;

public class ScrambleMetaSet
implements Serializable,
Iterable<ScrambleMeta> {
    private static final long serialVersionUID = 5106301901144427405L;
    Map<Pair<String, String>, ScrambleMeta> meta = new HashMap<Pair<String, String>, ScrambleMeta>();

    public String getAggregationBlockColumn(String schemaName, String tableName) {
        return this.meta.get(this.metaKey(schemaName, tableName)).getAggregationBlockColumn();
    }

    public ScrambleMeta getMetaForTable(String schemaName, String tableName) {
        return this.meta.get(new ImmutablePair((Object)schemaName, (Object)tableName));
    }

    public int getAggregationBlockCount(String schemaName, String tableName) {
        return this.meta.get(this.metaKey(schemaName, tableName)).getAggregationBlockCount();
    }

    @Deprecated
    public String getSubsampleColumn(String aliasName) {
        return this.meta.get(this.metaKey(aliasName)).getSubsampleColumn();
    }

    public String getSubsampleColumn(String schemaName, String tableName) {
        return this.meta.get(this.metaKey(schemaName, tableName)).getSubsampleColumn();
    }

    @Deprecated
    public String getTierColumn(String aliasName) {
        return this.meta.get(this.metaKey(aliasName)).getTierColumn();
    }

    public String getTierColumn(String schemaName, String tableName) {
        return this.meta.get(this.metaKey(schemaName, tableName)).getTierColumn();
    }

    public void addScrambleMeta(ScrambleMeta tablemeta) {
        String schema = tablemeta.getSchemaName();
        String table = tablemeta.getTableName();
        this.meta.put(this.metaKey(schema, table), tablemeta);
    }

    @Deprecated
    public void insertScrambleMetaEntry(String aliasName, String subsampleColumn, String tierColumn) {
        ScrambleMeta tableMeta = new ScrambleMeta();
        tableMeta.setSubsampleColumn(subsampleColumn);
        tableMeta.setTierColumn(tierColumn);
        this.meta.put(this.metaKey(aliasName), tableMeta);
    }

    public void insertScrambleMetaEntry(String schemaName, String tableName, String aggregationBlockColumn, String subsampleColumn, String tierColumn, int aggregationBlockCount) {
        ScrambleMeta tableMeta = new ScrambleMeta();
        tableMeta.setSchemaName(schemaName);
        tableMeta.setTableName(tableName);
        tableMeta.setAggregationBlockColumn(aggregationBlockColumn);
        tableMeta.setSubsampleColumn(subsampleColumn);
        tableMeta.setTierColumn(tierColumn);
        tableMeta.setAggregationBlockCount(aggregationBlockCount);
        this.meta.put(this.metaKey(schemaName, tableName), tableMeta);
    }

    @Deprecated
    public boolean isScrambled(String aliasName) {
        return this.meta.containsKey(this.metaKey(aliasName));
    }

    public boolean isScrambled(String schemaName, String tableName) {
        return this.meta.containsKey(this.metaKey(schemaName, tableName));
    }

    @Deprecated
    private Pair<String, String> metaKey(String aliasName) {
        return Pair.of((Object)"aliasName", (Object)aliasName);
    }

    private Pair<String, String> metaKey(String schemaName, String tableName) {
        return Pair.of((Object)schemaName, (Object)tableName);
    }

    @Override
    public Iterator<ScrambleMeta> iterator() {
        return this.meta.values().iterator();
    }
}

