/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.verdictdb.exception.VerdictDBValueException;

@JsonPropertyOrder(value={"schemaName", "tableName", "originalSchemaName", "originalTableName", "aggregationBlockColumn", "aggregationBlockCount", "tierColumn", "numberOfTiers"})
public class ScrambleMeta
implements Serializable {
    private static final long serialVersionUID = -8422601151874567149L;
    String schemaName;
    String tableName;
    String aggregationBlockColumn;
    int aggregationBlockCount;
    String tierColumn;
    int numberOfTiers;
    String originalSchemaName;
    String originalTableName;
    @JsonProperty(value="cumulativeDistributions")
    Map<Integer, List<Double>> cumulativeDistributionForTier = new HashMap<Integer, List<Double>>();
    @JsonIgnore
    String subsampleColumn;

    public ScrambleMeta() {
    }

    public ScrambleMeta(String scrambleSchemaName, String scrambleTableName, String originalSchemaName, String originalTableName, String blockColumn, int blockCount, String tierColumn, int tierCount, Map<Integer, List<Double>> cumulativeMassDistributionPerTier) throws VerdictDBValueException {
        if (tierCount != cumulativeMassDistributionPerTier.size()) {
            throw new VerdictDBValueException("The number of tiers don't match.");
        }
        for (Map.Entry<Integer, List<Double>> p : cumulativeMassDistributionPerTier.entrySet()) {
            List<Double> dist = p.getValue();
            if (dist == null) {
                throw new VerdictDBValueException("NULL is passed for a cumulative distribution.");
            }
            if (blockCount == dist.size()) continue;
            throw new VerdictDBValueException("The number of blocks don't match.");
        }
        this.schemaName = scrambleSchemaName;
        this.tableName = scrambleTableName;
        this.aggregationBlockColumn = blockColumn;
        this.aggregationBlockCount = blockCount;
        this.tierColumn = tierColumn;
        this.numberOfTiers = tierCount;
        this.originalSchemaName = originalSchemaName;
        this.originalTableName = originalTableName;
        this.cumulativeDistributionForTier = cumulativeMassDistributionPerTier;
    }

    public String getAggregationBlockColumn() {
        return this.aggregationBlockColumn;
    }

    public int getAggregationBlockCount() {
        return this.aggregationBlockCount;
    }

    public List<Double> getCumulativeDistributionForTier(int tier) {
        return this.cumulativeDistributionForTier.get(tier);
    }

    public int getNumberOfTiers() {
        return this.numberOfTiers;
    }

    public String getOriginalSchemaName() {
        return this.originalSchemaName;
    }

    public String getOriginalTableName() {
        return this.originalTableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSubsampleColumn() {
        return this.subsampleColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTierColumn() {
        return this.tierColumn;
    }

    public void setAggregationBlockColumn(String aggregationBlockColumn) {
        this.aggregationBlockColumn = aggregationBlockColumn;
    }

    public void setAggregationBlockCount(int aggregationBlockCount) {
        this.aggregationBlockCount = aggregationBlockCount;
    }

    public void setCumulativeDistributionForTier(Map<Integer, List<Double>> cumulativeDistributionForTier) {
        this.cumulativeDistributionForTier = cumulativeDistributionForTier;
    }

    public void setNumberOfTiers(int numberOfTiers) {
        this.numberOfTiers = numberOfTiers;
    }

    public void setOriginalSchemaName(String originalSchemaName) {
        this.originalSchemaName = originalSchemaName;
    }

    public void setOriginalTableName(String originalTableName) {
        this.originalTableName = originalTableName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSubsampleColumn(String subsampleColumn) {
        this.subsampleColumn = subsampleColumn;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTierColumn(String tierColumn) {
        this.tierColumn = tierColumn;
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonString = objectMapper.writeValueAsString((Object)this);
            return jsonString;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ScrambleMeta fromJsonString(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ScrambleMeta meta = (ScrambleMeta)objectMapper.readValue(jsonString, ScrambleMeta.class);
            return meta;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

