/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.verdictdb.connection.DataTypeConverter;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.BaseColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.SelectItem;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.exception.VerdictDBException;
import org.verdictdb.exception.VerdictDBValueException;

class PercentilesAndCountNode
extends QueryNodeBase {
    private static final long serialVersionUID = -1745299539668490874L;
    private String schemaName;
    private String tableName;
    private String columnMetaTokenKey;
    private String partitionMetaTokenKey;
    private Optional<String> primaryColumnName;
    public static final String AVG_PREFIX = "verdictdbavg";
    public static final String STDDEV_PREFIX = "verdictdbstddev";
    public static final String TOTAL_COUNT_ALIAS_NAME = "verdictdbtotalcount";

    public PercentilesAndCountNode(String schemaName, String tableName, String columnMetaTokenKey, String partitionMetaTokenKey, Optional<String> primaryColumnName) {
        super(null);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnMetaTokenKey = columnMetaTokenKey;
        this.partitionMetaTokenKey = partitionMetaTokenKey;
        this.primaryColumnName = primaryColumnName;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        if (tokens.size() == 0) {
            throw new VerdictDBValueException("No token is passed.");
        }
        List columnNameAndTypes = (List)tokens.get(0).getValue(this.columnMetaTokenKey);
        if (columnNameAndTypes == null) {
            throw new VerdictDBValueException("The passed token does not have the key: " + this.columnMetaTokenKey);
        }
        List<String> numericColumns = this.getNumericColumns(columnNameAndTypes);
        String tableSourceAlias = "t";
        ArrayList<SelectItem> selectList = new ArrayList<SelectItem>();
        for (String col : numericColumns) {
            if (this.primaryColumnName.isPresent() && col.equals(this.primaryColumnName.get())) continue;
            AliasedColumn item = new AliasedColumn(ColumnOp.avg(new BaseColumn(tableSourceAlias, col)), AVG_PREFIX + col);
            selectList.add(item);
            item = new AliasedColumn(ColumnOp.std(new BaseColumn(tableSourceAlias, col)), STDDEV_PREFIX + col);
            selectList.add(item);
        }
        selectList.add(new AliasedColumn(ColumnOp.count(), TOTAL_COUNT_ALIAS_NAME));
        this.selectQuery = SelectQuery.create(selectList, (AbstractRelation)new BaseTable(this.schemaName, this.tableName, tableSourceAlias));
        return this.selectQuery;
    }

    private List<String> getNumericColumns(List<Pair<String, String>> columnNameAndTypes) {
        ArrayList<String> numericColumns = new ArrayList<String>();
        for (Pair<String, String> nameAndType : columnNameAndTypes) {
            String name = (String)nameAndType.getLeft();
            String type = (String)nameAndType.getRight();
            if (!DataTypeConverter.isNumeric(type)) continue;
            numericColumns.add(name);
        }
        return numericColumns;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue(this.getClass().getSimpleName(), result);
        return token;
    }
}

