/*
 * Decompiled with CFR 0.152.
 */
package org.verdictdb.core.scrambling;

import java.util.List;
import org.verdictdb.connection.DbmsQueryResult;
import org.verdictdb.core.execplan.ExecutionInfoToken;
import org.verdictdb.core.querying.QueryNodeBase;
import org.verdictdb.core.scrambling.FastConvergeScramblingMethod;
import org.verdictdb.core.scrambling.PercentilesAndCountNode;
import org.verdictdb.core.sqlobject.AbstractRelation;
import org.verdictdb.core.sqlobject.AliasedColumn;
import org.verdictdb.core.sqlobject.BaseTable;
import org.verdictdb.core.sqlobject.ColumnOp;
import org.verdictdb.core.sqlobject.SelectQuery;
import org.verdictdb.core.sqlobject.SqlConvertible;
import org.verdictdb.core.sqlobject.UnnamedColumn;
import org.verdictdb.exception.VerdictDBException;

class OutlierProportionNode
extends QueryNodeBase {
    private static final long serialVersionUID = 3650001574444658985L;
    private String schemaName;
    private String tableName;
    public static String OUTLIER_SIZE_ALIAS = "verdictdbOutlierProportion";

    public OutlierProportionNode(String schemaName, String tableName) {
        super(null);
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Override
    public SqlConvertible createQuery(List<ExecutionInfoToken> tokens) throws VerdictDBException {
        DbmsQueryResult percentileAndCountResult = (DbmsQueryResult)tokens.get(0).getValue(PercentilesAndCountNode.class.getSimpleName());
        String tableSourceAliasName = "t1";
        UnnamedColumn outlierPrediacte = FastConvergeScramblingMethod.createOutlierTuplePredicate(percentileAndCountResult, tableSourceAliasName);
        this.selectQuery = SelectQuery.create(new AliasedColumn(ColumnOp.count(), OUTLIER_SIZE_ALIAS), (AbstractRelation)new BaseTable(this.schemaName, this.tableName, tableSourceAliasName));
        this.selectQuery.addFilterByAnd(outlierPrediacte);
        return this.selectQuery;
    }

    @Override
    public ExecutionInfoToken createToken(DbmsQueryResult result) {
        ExecutionInfoToken token = new ExecutionInfoToken();
        token.setKeyValue(this.getClass().getSimpleName(), result);
        return token;
    }
}

